/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class RouteParametersCopier {
    static Map<String, ParameterConstraints> copy(Map<String, ? extends ParameterConstraints> routeParametersParam) {
        Map<String, ParameterConstraints> map;
        if (routeParametersParam == null || routeParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ParameterConstraints> modifiableMap = new LinkedHashMap<>();
            routeParametersParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ParameterConstraints> copyFromBuilder(
            Map<String, ? extends ParameterConstraints.Builder> routeParametersParam) {
        Map<String, ParameterConstraints> map;
        if (routeParametersParam == null || routeParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ParameterConstraints> modifiableMap = new LinkedHashMap<>();
            routeParametersParam.forEach((key, value) -> {
                ParameterConstraints member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ParameterConstraints.Builder> copyToBuilder(
            Map<String, ? extends ParameterConstraints> routeParametersParam) {
        Map<String, ParameterConstraints.Builder> map;
        if (routeParametersParam == null || routeParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ParameterConstraints.Builder> modifiableMap = new LinkedHashMap<>();
            routeParametersParam.forEach((key, value) -> {
                ParameterConstraints.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
