/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates a DomainName.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainNameRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateDomainNameRequest.Builder, UpdateDomainNameRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateDomainNameRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()).build();

    private static final SdkField<List<DomainNameConfiguration>> DOMAIN_NAME_CONFIGURATIONS_FIELD = SdkField
            .<List<DomainNameConfiguration>> builder(MarshallingType.LIST)
            .memberName("DomainNameConfigurations")
            .getter(getter(UpdateDomainNameRequest::domainNameConfigurations))
            .setter(setter(Builder::domainNameConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainNameConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainNameConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MutualTlsAuthenticationInput> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField
            .<MutualTlsAuthenticationInput> builder(MarshallingType.SDK_POJO).memberName("MutualTlsAuthentication")
            .getter(getter(UpdateDomainNameRequest::mutualTlsAuthentication)).setter(setter(Builder::mutualTlsAuthentication))
            .constructor(MutualTlsAuthenticationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_NAME_CONFIGURATIONS_FIELD, MUTUAL_TLS_AUTHENTICATION_FIELD));

    private final String domainName;

    private final List<DomainNameConfiguration> domainNameConfigurations;

    private final MutualTlsAuthenticationInput mutualTlsAuthentication;

    private UpdateDomainNameRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameConfigurations = builder.domainNameConfigurations;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainNameConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainNameConfigurations() {
        return domainNameConfigurations != null && !(domainNameConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domain name configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainNameConfigurations} method.
     * </p>
     * 
     * @return The domain name configurations.
     */
    public final List<DomainNameConfiguration> domainNameConfigurations() {
        return domainNameConfigurations;
    }

    /**
     * <p>
     * The mutual TLS authentication configuration for a custom domain name.
     * </p>
     * 
     * @return The mutual TLS authentication configuration for a custom domain name.
     */
    public final MutualTlsAuthenticationInput mutualTlsAuthentication() {
        return mutualTlsAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainNameConfigurations() ? domainNameConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mutualTlsAuthentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameRequest)) {
            return false;
        }
        UpdateDomainNameRequest other = (UpdateDomainNameRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && hasDomainNameConfigurations() == other.hasDomainNameConfigurations()
                && Objects.equals(domainNameConfigurations(), other.domainNameConfigurations())
                && Objects.equals(mutualTlsAuthentication(), other.mutualTlsAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainNameRequest").add("DomainName", domainName())
                .add("DomainNameConfigurations", hasDomainNameConfigurations() ? domainNameConfigurations() : null)
                .add("MutualTlsAuthentication", mutualTlsAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainNameConfigurations":
            return Optional.ofNullable(clazz.cast(domainNameConfigurations()));
        case "MutualTlsAuthentication":
            return Optional.ofNullable(clazz.cast(mutualTlsAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainNameRequest, T> g) {
        return obj -> g.apply((UpdateDomainNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainNameRequest> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainNameConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<DomainNameConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainNameConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #domainNameConfigurations(List<DomainNameConfiguration>)}.
         * 
         * @param domainNameConfigurations
         *        a consumer that will call methods on {@link List<DomainNameConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainNameConfigurations(List<DomainNameConfiguration>)
         */
        Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * 
         * @param mutualTlsAuthentication
         *        The mutual TLS authentication configuration for a custom domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualTlsAuthentication(MutualTlsAuthenticationInput mutualTlsAuthentication);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * This is a convenience that creates an instance of the {@link MutualTlsAuthenticationInput.Builder} avoiding
         * the need to create one manually via {@link MutualTlsAuthenticationInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link MutualTlsAuthenticationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #mutualTlsAuthentication(MutualTlsAuthenticationInput)}.
         * 
         * @param mutualTlsAuthentication
         *        a consumer that will call methods on {@link MutualTlsAuthenticationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualTlsAuthentication(MutualTlsAuthenticationInput)
         */
        default Builder mutualTlsAuthentication(Consumer<MutualTlsAuthenticationInput.Builder> mutualTlsAuthentication) {
            return mutualTlsAuthentication(MutualTlsAuthenticationInput.builder().applyMutation(mutualTlsAuthentication).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String domainName;

        private List<DomainNameConfiguration> domainNameConfigurations = DefaultSdkAutoConstructList.getInstance();

        private MutualTlsAuthenticationInput mutualTlsAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainNameRequest model) {
            super(model);
            domainName(model.domainName);
            domainNameConfigurations(model.domainNameConfigurations);
            mutualTlsAuthentication(model.mutualTlsAuthentication);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<DomainNameConfiguration.Builder> getDomainNameConfigurations() {
            List<DomainNameConfiguration.Builder> result = DomainNameConfigurationsCopier
                    .copyToBuilder(this.domainNameConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNameConfigurations(Collection<DomainNameConfiguration.BuilderImpl> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copyFromBuilder(domainNameConfigurations);
        }

        @Override
        @Transient
        public final Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copy(domainNameConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations) {
            domainNameConfigurations(Arrays.asList(domainNameConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations) {
            domainNameConfigurations(Stream.of(domainNameConfigurations)
                    .map(c -> DomainNameConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MutualTlsAuthenticationInput.Builder getMutualTlsAuthentication() {
            return mutualTlsAuthentication != null ? mutualTlsAuthentication.toBuilder() : null;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthenticationInput.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        @Override
        @Transient
        public final Builder mutualTlsAuthentication(MutualTlsAuthenticationInput mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainNameRequest build() {
            return new UpdateDomainNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
