/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfVpcLinkCopier {
    static List<VpcLink> copy(Collection<? extends VpcLink> __listOfVpcLinkParam) {
        List<VpcLink> list;
        if (__listOfVpcLinkParam == null || __listOfVpcLinkParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcLink> modifiableList = new ArrayList<>();
            __listOfVpcLinkParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VpcLink> copyFromBuilder(Collection<? extends VpcLink.Builder> __listOfVpcLinkParam) {
        List<VpcLink> list;
        if (__listOfVpcLinkParam == null || __listOfVpcLinkParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcLink> modifiableList = new ArrayList<>();
            __listOfVpcLinkParam.forEach(entry -> {
                VpcLink member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VpcLink.Builder> copyToBuilder(Collection<? extends VpcLink> __listOfVpcLinkParam) {
        List<VpcLink.Builder> list;
        if (__listOfVpcLinkParam == null || __listOfVpcLinkParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcLink.Builder> modifiableList = new ArrayList<>();
            __listOfVpcLinkParam.forEach(entry -> {
                VpcLink.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
