/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates an Integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIntegrationRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateIntegrationRequest.Builder, UpdateIntegrationRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(UpdateIntegrationRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId").getter(getter(UpdateIntegrationRequest::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(UpdateIntegrationRequest::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();

    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentHandlingStrategy").getter(getter(UpdateIntegrationRequest::contentHandlingStrategyAsString))
            .setter(setter(Builder::contentHandlingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build())
            .build();

    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialsArn").getter(getter(UpdateIntegrationRequest::credentialsArn))
            .setter(setter(Builder::credentialsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateIntegrationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INTEGRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationId").getter(getter(UpdateIntegrationRequest::integrationId))
            .setter(setter(Builder::integrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("integrationId").build()).build();

    private static final SdkField<String> INTEGRATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationMethod").getter(getter(UpdateIntegrationRequest::integrationMethod))
            .setter(setter(Builder::integrationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationMethod").build()).build();

    private static final SdkField<String> INTEGRATION_SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationSubtype").getter(getter(UpdateIntegrationRequest::integrationSubtype))
            .setter(setter(Builder::integrationSubtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationSubtype").build())
            .build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationType").getter(getter(UpdateIntegrationRequest::integrationTypeAsString))
            .setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()).build();

    private static final SdkField<String> INTEGRATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationUri").getter(getter(UpdateIntegrationRequest::integrationUri))
            .setter(setter(Builder::integrationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationUri").build()).build();

    private static final SdkField<String> PASSTHROUGH_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PassthroughBehavior").getter(getter(UpdateIntegrationRequest::passthroughBehaviorAsString))
            .setter(setter(Builder::passthroughBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughBehavior").build())
            .build();

    private static final SdkField<String> PAYLOAD_FORMAT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadFormatVersion").getter(getter(UpdateIntegrationRequest::payloadFormatVersion))
            .setter(setter(Builder::payloadFormatVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormatVersion").build())
            .build();

    private static final SdkField<Map<String, String>> REQUEST_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RequestParameters")
            .getter(getter(UpdateIntegrationRequest::requestParameters))
            .setter(setter(Builder::requestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REQUEST_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RequestTemplates")
            .getter(getter(UpdateIntegrationRequest::requestTemplates))
            .setter(setter(Builder::requestTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Map<String, String>>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("ResponseParameters")
            .getter(getter(UpdateIntegrationRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TemplateSelectionExpression")
            .getter(getter(UpdateIntegrationRequest::templateSelectionExpression))
            .setter(setter(Builder::templateSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression")
                    .build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInMillis").getter(getter(UpdateIntegrationRequest::timeoutInMillis))
            .setter(setter(Builder::timeoutInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMillis").build()).build();

    private static final SdkField<TlsConfigInput> TLS_CONFIG_FIELD = SdkField.<TlsConfigInput> builder(MarshallingType.SDK_POJO)
            .memberName("TlsConfig").getter(getter(UpdateIntegrationRequest::tlsConfig)).setter(setter(Builder::tlsConfig))
            .constructor(TlsConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            CONNECTION_ID_FIELD, CONNECTION_TYPE_FIELD, CONTENT_HANDLING_STRATEGY_FIELD, CREDENTIALS_ARN_FIELD,
            DESCRIPTION_FIELD, INTEGRATION_ID_FIELD, INTEGRATION_METHOD_FIELD, INTEGRATION_SUBTYPE_FIELD, INTEGRATION_TYPE_FIELD,
            INTEGRATION_URI_FIELD, PASSTHROUGH_BEHAVIOR_FIELD, PAYLOAD_FORMAT_VERSION_FIELD, REQUEST_PARAMETERS_FIELD,
            REQUEST_TEMPLATES_FIELD, RESPONSE_PARAMETERS_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD, TIMEOUT_IN_MILLIS_FIELD,
            TLS_CONFIG_FIELD));

    private final String apiId;

    private final String connectionId;

    private final String connectionType;

    private final String contentHandlingStrategy;

    private final String credentialsArn;

    private final String description;

    private final String integrationId;

    private final String integrationMethod;

    private final String integrationSubtype;

    private final String integrationType;

    private final String integrationUri;

    private final String passthroughBehavior;

    private final String payloadFormatVersion;

    private final Map<String, String> requestParameters;

    private final Map<String, String> requestTemplates;

    private final Map<String, Map<String, String>> responseParameters;

    private final String templateSelectionExpression;

    private final Integer timeoutInMillis;

    private final TlsConfigInput tlsConfig;

    private UpdateIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.connectionId = builder.connectionId;
        this.connectionType = builder.connectionType;
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.integrationId = builder.integrationId;
        this.integrationMethod = builder.integrationMethod;
        this.integrationSubtype = builder.integrationSubtype;
        this.integrationType = builder.integrationType;
        this.integrationUri = builder.integrationUri;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.payloadFormatVersion = builder.payloadFormatVersion;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.responseParameters = builder.responseParameters;
        this.templateSelectionExpression = builder.templateSelectionExpression;
        this.timeoutInMillis = builder.timeoutInMillis;
        this.tlsConfig = builder.tlsConfig;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The ID of the VPC link for a private integration. Supported only for HTTP APIs.
     * </p>
     * 
     * @return The ID of the VPC link for a private integration. Supported only for HTTP APIs.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The type of the network connection to the integration endpoint. Specify INTERNET for connections through the
     * public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The
     * default value is INTERNET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the network connection to the integration endpoint. Specify INTERNET for connections through
     *         the public routable internet or VPC_LINK for private connections between API Gateway and resources in a
     *         VPC. The default value is INTERNET.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the network connection to the integration endpoint. Specify INTERNET for connections through the
     * public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The
     * default value is INTERNET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the network connection to the integration endpoint. Specify INTERNET for connections through
     *         the public routable internet or VPC_LINK for private connections between API Gateway and resources in a
     *         VPC. The default value is INTERNET.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported
     * values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
     *         Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public final ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(contentHandlingStrategy);
    }

    /**
     * <p>
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported
     * values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
     *         Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public final String contentHandlingStrategyAsString() {
        return contentHandlingStrategy;
    }

    /**
     * <p>
     * Specifies the credentials required for the integration, if any. For AWS integrations, three options are
     * available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To
     * require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*.
     * To use resource-based permissions on supported AWS services, specify null.
     * </p>
     * 
     * @return Specifies the credentials required for the integration, if any. For AWS integrations, three options are
     *         available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN).
     *         To require that the caller's identity be passed through from the request, specify the string
     *         arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.
     */
    public final String credentialsArn() {
        return credentialsArn;
    }

    /**
     * <p>
     * The description of the integration
     * </p>
     * 
     * @return The description of the integration
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The integration ID.
     * </p>
     * 
     * @return The integration ID.
     */
    public final String integrationId() {
        return integrationId;
    }

    /**
     * <p>
     * Specifies the integration's HTTP method type.
     * </p>
     * 
     * @return Specifies the integration's HTTP method type.
     */
    public final String integrationMethod() {
        return integrationMethod;
    }

    /**
     * <p>
     * Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more,
     * see <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html"
     * >Integration subtype reference</a>.
     * </p>
     * 
     * @return Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn
     *         more, see <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html"
     *         >Integration subtype reference</a>.
     */
    public final String integrationSubtype() {
        return integrationSubtype;
    }

    /**
     * <p>
     * The integration type of an integration. One of the following:
     * </p>
     * <p>
     * AWS: for integrating the route or method request with an AWS service action, including the Lambda
     * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
     * integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket
     * APIs.
     * </p>
     * <p>
     * AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This
     * integration is also referred to as a Lambda proxy integration.
     * </p>
     * <p>
     * HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as
     * the HTTP custom integration. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed
     * through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an
     * HTTP_PROXY integration.
     * </p>
     * <p>
     * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any
     * backend. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The integration type of an integration. One of the following:</p>
     *         <p>
     *         AWS: for integrating the route or method request with an AWS service action, including the Lambda
     *         function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
     *         custom integration. With any other AWS service action, this is known as AWS integration. Supported only
     *         for WebSocket APIs.
     *         </p>
     *         <p>
     *         AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service
     *         action. This integration is also referred to as a Lambda proxy integration.
     *         </p>
     *         <p>
     *         HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also
     *         referred to as the HTTP custom integration. Supported only for WebSocket APIs.
     *         </p>
     *         <p>
     *         HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request
     *         passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private
     *         integrations, use an HTTP_PROXY integration.
     *         </p>
     *         <p>
     *         MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
     *         invoking any backend. Supported only for WebSocket APIs.
     * @see IntegrationType
     */
    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * The integration type of an integration. One of the following:
     * </p>
     * <p>
     * AWS: for integrating the route or method request with an AWS service action, including the Lambda
     * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
     * integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket
     * APIs.
     * </p>
     * <p>
     * AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This
     * integration is also referred to as a Lambda proxy integration.
     * </p>
     * <p>
     * HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as
     * the HTTP custom integration. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed
     * through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an
     * HTTP_PROXY integration.
     * </p>
     * <p>
     * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any
     * backend. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The integration type of an integration. One of the following:</p>
     *         <p>
     *         AWS: for integrating the route or method request with an AWS service action, including the Lambda
     *         function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
     *         custom integration. With any other AWS service action, this is known as AWS integration. Supported only
     *         for WebSocket APIs.
     *         </p>
     *         <p>
     *         AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service
     *         action. This integration is also referred to as a Lambda proxy integration.
     *         </p>
     *         <p>
     *         HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also
     *         referred to as the HTTP custom integration. Supported only for WebSocket APIs.
     *         </p>
     *         <p>
     *         HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request
     *         passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private
     *         integrations, use an HTTP_PROXY integration.
     *         </p>
     *         <p>
     *         MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
     *         invoking any backend. Supported only for WebSocket APIs.
     * @see IntegrationType
     */
    public final String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * For a Lambda integration, specify the URI of a Lambda function.
     * </p>
     * <p>
     * For an HTTP integration, specify a fully-qualified URL.
     * </p>
     * <p>
     * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load
     * Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses
     * DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn
     * more, see <a
     * href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For
     * private integrations, all resources must be owned by the same AWS account.
     * </p>
     * 
     * @return For a Lambda integration, specify the URI of a Lambda function.</p>
     *         <p>
     *         For an HTTP integration, specify a fully-qualified URL.
     *         </p>
     *         <p>
     *         For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network
     *         Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API
     *         Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific
     *         resources. To learn more, see <a
     *         href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>.
     *         For private integrations, all resources must be owned by the same AWS account.
     */
    public final String integrationUri() {
        return integrationUri;
    }

    /**
     * <p>
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and
     * the available mapping templates specified as the requestTemplates property on the Integration resource. There are
     * three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
     * transformation.
     * </p>
     * <p>
     * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     * </p>
     * <p>
     * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if
     * there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
     * Unsupported Media Type response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #passthroughBehavior} will return {@link PassthroughBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #passthroughBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
     *         request, and the available mapping templates specified as the requestTemplates property on the
     *         Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
     *         Supported only for WebSocket APIs.</p>
     *         <p>
     *         WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
     *         without transformation.
     *         </p>
     *         <p>
     *         NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     *         </p>
     *         <p>
     *         WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
     *         However, if there is at least one content type defined, unmapped content types will be rejected with the
     *         same HTTP 415 Unsupported Media Type response.
     * @see PassthroughBehavior
     */
    public final PassthroughBehavior passthroughBehavior() {
        return PassthroughBehavior.fromValue(passthroughBehavior);
    }

    /**
     * <p>
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and
     * the available mapping templates specified as the requestTemplates property on the Integration resource. There are
     * three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
     * transformation.
     * </p>
     * <p>
     * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     * </p>
     * <p>
     * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if
     * there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
     * Unsupported Media Type response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #passthroughBehavior} will return {@link PassthroughBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #passthroughBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
     *         request, and the available mapping templates specified as the requestTemplates property on the
     *         Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
     *         Supported only for WebSocket APIs.</p>
     *         <p>
     *         WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
     *         without transformation.
     *         </p>
     *         <p>
     *         NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     *         </p>
     *         <p>
     *         WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
     *         However, if there is at least one content type defined, unmapped content types will be rejected with the
     *         same HTTP 415 Unsupported Media Type response.
     * @see PassthroughBehavior
     */
    public final String passthroughBehaviorAsString() {
        return passthroughBehavior;
    }

    /**
     * <p>
     * Specifies the format of the payload sent to an integration. Required for HTTP APIs.
     * </p>
     * 
     * @return Specifies the format of the payload sent to an integration. Required for HTTP APIs.
     */
    public final String payloadFormatVersion() {
        return payloadFormatVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestParameters() {
        return requestParameters != null && !(requestParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the
     * backend. The key is an integration request parameter name and the associated value is a method request parameter
     * value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The
     * method request parameter value must match the pattern of
     * method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable> , where
     * <replaceable>{location}</replaceable> is querystring, path, or header; and <replaceable>{name}</replaceable> must
     * be a valid and unique method request parameter name.
     * </p>
     * <p>
     * For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying
     * parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage
     * variables, or context variables that are evaluated at runtime. To learn more, see <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html"
     * >Working with AWS service integrations for HTTP APIs</a>.
     * </p>
     * <p>
     * For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map
     * specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern
     * &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite or remove.
     * For values, you can provide static values, or map request data, stage variables, or context variables that are
     * evaluated at runtime. To learn more, see <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming API
     * requests and responses</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestParameters} method.
     * </p>
     * 
     * @return For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request
     *         to the backend. The key is an integration request parameter name and the associated value is a method
     *         request parameter value or static value that must be enclosed within single quotes and pre-encoded as
     *         required by the backend. The method request parameter value must match the pattern of
     *         method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable> , where
     *         <replaceable>{location}</replaceable> is querystring, path, or header; and
     *         <replaceable>{name}</replaceable> must be a valid and unique method request parameter name.</p>
     *         <p>
     *         For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map
     *         specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map
     *         request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a
     *         href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html"
     *         >Working with AWS service integrations for HTTP APIs</a>.
     *         </p>
     *         <p>
     *         For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map
     *         specifying how to transform HTTP requests before sending them to the backend. The key should follow the
     *         pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append,
     *         overwrite or remove. For values, you can provide static values, or map request data, stage variables, or
     *         context variables that are evaluated at runtime. To learn more, see <a
     *         href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping."
     *         >Transforming API requests and responses</a>.
     */
    public final Map<String, String> requestParameters() {
        return requestParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestTemplates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestTemplates() {
        return requestTemplates != null && !(requestTemplates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the
     * Content-Type header sent by the client. The content type value is the key in this map, and the template (as a
     * String) is the value. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestTemplates} method.
     * </p>
     * 
     * @return Represents a map of Velocity templates that are applied on the request payload based on the value of the
     *         Content-Type header sent by the client. The content type value is the key in this map, and the template
     *         (as a String) is the value. Supported only for WebSocket APIs.
     */
    public final Map<String, String> requestTemplates() {
        return requestTemplates;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend
     * integration before returning the response to clients. Specify a key-value map from a selection key to response
     * parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters
     * are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or
     * overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to
     * response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming
     * API requests and responses</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseParameters} method.
     * </p>
     * 
     * @return Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend
     *         integration before returning the response to clients. Specify a key-value map from a selection key to
     *         response parameters. The selection key must be a valid HTTP status code within the range of 200-599.
     *         Response parameters are a key-value map. The key must match pattern
     *         &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append,
     *         overwrite or remove. The value can be a static value, or map to response data, stage variables, or
     *         context variables that are evaluated at runtime. To learn more, see <a
     *         href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html"
     *         >Transforming API requests and responses</a>.
     */
    public final Map<String, Map<String, String>> responseParameters() {
        return responseParameters;
    }

    /**
     * <p>
     * The template selection expression for the integration.
     * </p>
     * 
     * @return The template selection expression for the integration.
     */
    public final String templateSelectionExpression() {
        return templateSelectionExpression;
    }

    /**
     * <p>
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for
     * HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * </p>
     * 
     * @return Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000
     *         milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP
     *         APIs.
     */
    public final Integer timeoutInMillis() {
        return timeoutInMillis;
    }

    /**
     * <p>
     * The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic
     * uses the HTTPS protocol. Supported only for HTTP APIs.
     * </p>
     * 
     * @return The TLS configuration for a private integration. If you specify a TLS configuration, private integration
     *         traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     */
    public final TlsConfigInput tlsConfig() {
        return tlsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(integrationId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(integrationSubtype());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationUri());
        hashCode = 31 * hashCode + Objects.hashCode(passthroughBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(payloadFormatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestParameters() ? requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestTemplates() ? requestTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(tlsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationRequest)) {
            return false;
        }
        UpdateIntegrationRequest other = (UpdateIntegrationRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString())
                && Objects.equals(credentialsArn(), other.credentialsArn()) && Objects.equals(description(), other.description())
                && Objects.equals(integrationId(), other.integrationId())
                && Objects.equals(integrationMethod(), other.integrationMethod())
                && Objects.equals(integrationSubtype(), other.integrationSubtype())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationUri(), other.integrationUri())
                && Objects.equals(passthroughBehaviorAsString(), other.passthroughBehaviorAsString())
                && Objects.equals(payloadFormatVersion(), other.payloadFormatVersion())
                && hasRequestParameters() == other.hasRequestParameters()
                && Objects.equals(requestParameters(), other.requestParameters())
                && hasRequestTemplates() == other.hasRequestTemplates()
                && Objects.equals(requestTemplates(), other.requestTemplates())
                && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && Objects.equals(templateSelectionExpression(), other.templateSelectionExpression())
                && Objects.equals(timeoutInMillis(), other.timeoutInMillis()) && Objects.equals(tlsConfig(), other.tlsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIntegrationRequest").add("ApiId", apiId()).add("ConnectionId", connectionId())
                .add("ConnectionType", connectionTypeAsString())
                .add("ContentHandlingStrategy", contentHandlingStrategyAsString()).add("CredentialsArn", credentialsArn())
                .add("Description", description()).add("IntegrationId", integrationId())
                .add("IntegrationMethod", integrationMethod()).add("IntegrationSubtype", integrationSubtype())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationUri", integrationUri())
                .add("PassthroughBehavior", passthroughBehaviorAsString()).add("PayloadFormatVersion", payloadFormatVersion())
                .add("RequestParameters", hasRequestParameters() ? requestParameters() : null)
                .add("RequestTemplates", hasRequestTemplates() ? requestTemplates() : null)
                .add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("TemplateSelectionExpression", templateSelectionExpression()).add("TimeoutInMillis", timeoutInMillis())
                .add("TlsConfig", tlsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "ContentHandlingStrategy":
            return Optional.ofNullable(clazz.cast(contentHandlingStrategyAsString()));
        case "CredentialsArn":
            return Optional.ofNullable(clazz.cast(credentialsArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IntegrationId":
            return Optional.ofNullable(clazz.cast(integrationId()));
        case "IntegrationMethod":
            return Optional.ofNullable(clazz.cast(integrationMethod()));
        case "IntegrationSubtype":
            return Optional.ofNullable(clazz.cast(integrationSubtype()));
        case "IntegrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "IntegrationUri":
            return Optional.ofNullable(clazz.cast(integrationUri()));
        case "PassthroughBehavior":
            return Optional.ofNullable(clazz.cast(passthroughBehaviorAsString()));
        case "PayloadFormatVersion":
            return Optional.ofNullable(clazz.cast(payloadFormatVersion()));
        case "RequestParameters":
            return Optional.ofNullable(clazz.cast(requestParameters()));
        case "RequestTemplates":
            return Optional.ofNullable(clazz.cast(requestTemplates()));
        case "ResponseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "TemplateSelectionExpression":
            return Optional.ofNullable(clazz.cast(templateSelectionExpression()));
        case "TimeoutInMillis":
            return Optional.ofNullable(clazz.cast(timeoutInMillis()));
        case "TlsConfig":
            return Optional.ofNullable(clazz.cast(tlsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationRequest, T> g) {
        return obj -> g.apply((UpdateIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIntegrationRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The ID of the VPC link for a private integration. Supported only for HTTP APIs.
         * </p>
         * 
         * @param connectionId
         *        The ID of the VPC link for a private integration. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The type of the network connection to the integration endpoint. Specify INTERNET for connections through the
         * public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The
         * default value is INTERNET.
         * </p>
         * 
         * @param connectionType
         *        The type of the network connection to the integration endpoint. Specify INTERNET for connections
         *        through the public routable internet or VPC_LINK for private connections between API Gateway and
         *        resources in a VPC. The default value is INTERNET.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the network connection to the integration endpoint. Specify INTERNET for connections through the
         * public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The
         * default value is INTERNET.
         * </p>
         * 
         * @param connectionType
         *        The type of the network connection to the integration endpoint. Specify INTERNET for connections
         *        through the public routable internet or VPC_LINK for private connections between API Gateway and
         *        resources in a VPC. The default value is INTERNET.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         * Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         *        Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(String contentHandlingStrategy);

        /**
         * <p>
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         * Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         *        Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy);

        /**
         * <p>
         * Specifies the credentials required for the integration, if any. For AWS integrations, three options are
         * available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To
         * require that the caller's identity be passed through from the request, specify the string
         * arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.
         * </p>
         * 
         * @param credentialsArn
         *        Specifies the credentials required for the integration, if any. For AWS integrations, three options
         *        are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name
         *        (ARN). To require that the caller's identity be passed through from the request, specify the string
         *        arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsArn(String credentialsArn);

        /**
         * <p>
         * The description of the integration
         * </p>
         * 
         * @param description
         *        The description of the integration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The integration ID.
         * </p>
         * 
         * @param integrationId
         *        The integration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationId(String integrationId);

        /**
         * <p>
         * Specifies the integration's HTTP method type.
         * </p>
         * 
         * @param integrationMethod
         *        Specifies the integration's HTTP method type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationMethod(String integrationMethod);

        /**
         * <p>
         * Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn
         * more, see <a href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html"
         * >Integration subtype reference</a>.
         * </p>
         * 
         * @param integrationSubtype
         *        Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To
         *        learn more, see <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html"
         *        >Integration subtype reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationSubtype(String integrationSubtype);

        /**
         * <p>
         * The integration type of an integration. One of the following:
         * </p>
         * <p>
         * AWS: for integrating the route or method request with an AWS service action, including the Lambda
         * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
         * integration. With any other AWS service action, this is known as AWS integration. Supported only for
         * WebSocket APIs.
         * </p>
         * <p>
         * AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action.
         * This integration is also referred to as a Lambda proxy integration.
         * </p>
         * <p>
         * HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to
         * as the HTTP custom integration. Supported only for WebSocket APIs.
         * </p>
         * <p>
         * HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed
         * through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an
         * HTTP_PROXY integration.
         * </p>
         * <p>
         * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking
         * any backend. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param integrationType
         *        The integration type of an integration. One of the following:</p>
         *        <p>
         *        AWS: for integrating the route or method request with an AWS service action, including the Lambda
         *        function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
         *        custom integration. With any other AWS service action, this is known as AWS integration. Supported
         *        only for WebSocket APIs.
         *        </p>
         *        <p>
         *        AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service
         *        action. This integration is also referred to as a Lambda proxy integration.
         *        </p>
         *        <p>
         *        HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also
         *        referred to as the HTTP custom integration. Supported only for WebSocket APIs.
         *        </p>
         *        <p>
         *        HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request
         *        passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private
         *        integrations, use an HTTP_PROXY integration.
         *        </p>
         *        <p>
         *        MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
         *        invoking any backend. Supported only for WebSocket APIs.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * The integration type of an integration. One of the following:
         * </p>
         * <p>
         * AWS: for integrating the route or method request with an AWS service action, including the Lambda
         * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
         * integration. With any other AWS service action, this is known as AWS integration. Supported only for
         * WebSocket APIs.
         * </p>
         * <p>
         * AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action.
         * This integration is also referred to as a Lambda proxy integration.
         * </p>
         * <p>
         * HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to
         * as the HTTP custom integration. Supported only for WebSocket APIs.
         * </p>
         * <p>
         * HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed
         * through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an
         * HTTP_PROXY integration.
         * </p>
         * <p>
         * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking
         * any backend. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param integrationType
         *        The integration type of an integration. One of the following:</p>
         *        <p>
         *        AWS: for integrating the route or method request with an AWS service action, including the Lambda
         *        function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
         *        custom integration. With any other AWS service action, this is known as AWS integration. Supported
         *        only for WebSocket APIs.
         *        </p>
         *        <p>
         *        AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service
         *        action. This integration is also referred to as a Lambda proxy integration.
         *        </p>
         *        <p>
         *        HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also
         *        referred to as the HTTP custom integration. Supported only for WebSocket APIs.
         *        </p>
         *        <p>
         *        HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request
         *        passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private
         *        integrations, use an HTTP_PROXY integration.
         *        </p>
         *        <p>
         *        MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
         *        invoking any backend. Supported only for WebSocket APIs.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * For a Lambda integration, specify the URI of a Lambda function.
         * </p>
         * <p>
         * For an HTTP integration, specify a fully-qualified URL.
         * </p>
         * <p>
         * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load
         * Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway
         * uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To
         * learn more, see <a
         * href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a>. For
         * private integrations, all resources must be owned by the same AWS account.
         * </p>
         * 
         * @param integrationUri
         *        For a Lambda integration, specify the URI of a Lambda function.</p>
         *        <p>
         *        For an HTTP integration, specify a fully-qualified URL.
         *        </p>
         *        <p>
         *        For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network
         *        Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service,
         *        API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target
         *        specific resources. To learn more, see <a
         *        href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html"
         *        >DiscoverInstances</a>. For private integrations, all resources must be owned by the same AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationUri(String integrationUri);

        /**
         * <p>
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request,
         * and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
         * </p>
         * <p>
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
         * transformation.
         * </p>
         * <p>
         * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         * </p>
         * <p>
         * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However,
         * if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
         * Unsupported Media Type response.
         * </p>
         * 
         * @param passthroughBehavior
         *        Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
         *        request, and the available mapping templates specified as the requestTemplates property on the
         *        Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         *        Supported only for WebSocket APIs.</p>
         *        <p>
         *        WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
         *        without transformation.
         *        </p>
         *        <p>
         *        NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         *        </p>
         *        <p>
         *        WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
         *        However, if there is at least one content type defined, unmapped content types will be rejected with
         *        the same HTTP 415 Unsupported Media Type response.
         * @see PassthroughBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PassthroughBehavior
         */
        Builder passthroughBehavior(String passthroughBehavior);

        /**
         * <p>
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request,
         * and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
         * </p>
         * <p>
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
         * transformation.
         * </p>
         * <p>
         * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         * </p>
         * <p>
         * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However,
         * if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
         * Unsupported Media Type response.
         * </p>
         * 
         * @param passthroughBehavior
         *        Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
         *        request, and the available mapping templates specified as the requestTemplates property on the
         *        Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         *        Supported only for WebSocket APIs.</p>
         *        <p>
         *        WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
         *        without transformation.
         *        </p>
         *        <p>
         *        NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         *        </p>
         *        <p>
         *        WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
         *        However, if there is at least one content type defined, unmapped content types will be rejected with
         *        the same HTTP 415 Unsupported Media Type response.
         * @see PassthroughBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PassthroughBehavior
         */
        Builder passthroughBehavior(PassthroughBehavior passthroughBehavior);

        /**
         * <p>
         * Specifies the format of the payload sent to an integration. Required for HTTP APIs.
         * </p>
         * 
         * @param payloadFormatVersion
         *        Specifies the format of the payload sent to an integration. Required for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadFormatVersion(String payloadFormatVersion);

        /**
         * <p>
         * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to
         * the backend. The key is an integration request parameter name and the associated value is a method request
         * parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the
         * backend. The method request parameter value must match the pattern of
         * method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable> , where
         * <replaceable>{location}</replaceable> is querystring, path, or header; and <replaceable>{name}</replaceable>
         * must be a valid and unique method request parameter name.
         * </p>
         * <p>
         * For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map
         * specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map
         * request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a
         * href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html"
         * >Working with AWS service integrations for HTTP APIs</a>.
         * </p>
         * <p>
         * For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map
         * specifying how to transform HTTP requests before sending them to the backend. The key should follow the
         * pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be append, overwrite
         * or remove. For values, you can provide static values, or map request data, stage variables, or context
         * variables that are evaluated at runtime. To learn more, see <a
         * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.">Transforming
         * API requests and responses</a>.
         * </p>
         * 
         * @param requestParameters
         *        For WebSocket APIs, a key-value map specifying request parameters that are passed from the method
         *        request to the backend. The key is an integration request parameter name and the associated value is a
         *        method request parameter value or static value that must be enclosed within single quotes and
         *        pre-encoded as required by the backend. The method request parameter value must match the pattern of
         *        method.request.<replaceable>{location}</replaceable>.<replaceable>{name}</replaceable> , where
         *        <replaceable>{location}</replaceable> is querystring, path, or header; and
         *        <replaceable>{name}</replaceable> must be a valid and unique method request parameter name.</p>
         *        <p>
         *        For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map
         *        specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map
         *        request data, stage variables, or context variables that are evaluated at runtime. To learn more, see
         *        <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html"
         *        >Working with AWS service integrations for HTTP APIs</a>.
         *        </p>
         *        <p>
         *        For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value
         *        map specifying how to transform HTTP requests before sending them to the backend. The key should
         *        follow the pattern &lt;action&gt;:&lt;header|querystring|path&gt;.&lt;location&gt; where action can be
         *        append, overwrite or remove. For values, you can provide static values, or map request data, stage
         *        variables, or context variables that are evaluated at runtime. To learn more, see <a
         *        href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping."
         *        >Transforming API requests and responses</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestParameters(Map<String, String> requestParameters);

        /**
         * <p>
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the
         * Content-Type header sent by the client. The content type value is the key in this map, and the template (as a
         * String) is the value. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param requestTemplates
         *        Represents a map of Velocity templates that are applied on the request payload based on the value of
         *        the Content-Type header sent by the client. The content type value is the key in this map, and the
         *        template (as a String) is the value. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTemplates(Map<String, String> requestTemplates);

        /**
         * <p>
         * Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend
         * integration before returning the response to clients. Specify a key-value map from a selection key to
         * response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response
         * parameters are a key-value map. The key must match pattern &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or
         * overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map
         * to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a
         * href
         * ="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming
         * API requests and responses</a>.
         * </p>
         * 
         * @param responseParameters
         *        Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a
         *        backend integration before returning the response to clients. Specify a key-value map from a selection
         *        key to response parameters. The selection key must be a valid HTTP status code within the range of
         *        200-599. Response parameters are a key-value map. The key must match pattern
         *        &lt;action&gt;:&lt;header&gt;.&lt;location&gt; or overwrite.statuscode. The action can be append,
         *        overwrite or remove. The value can be a static value, or map to response data, stage variables, or
         *        context variables that are evaluated at runtime. To learn more, see <a
         *        href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html"
         *        >Transforming API requests and responses</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, ? extends Map<String, String>> responseParameters);

        /**
         * <p>
         * The template selection expression for the integration.
         * </p>
         * 
         * @param templateSelectionExpression
         *        The template selection expression for the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSelectionExpression(String templateSelectionExpression);

        /**
         * <p>
         * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds
         * for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
         * </p>
         * 
         * @param timeoutInMillis
         *        Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000
         *        milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for
         *        HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMillis(Integer timeoutInMillis);

        /**
         * <p>
         * The TLS configuration for a private integration. If you specify a TLS configuration, private integration
         * traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * </p>
         * 
         * @param tlsConfig
         *        The TLS configuration for a private integration. If you specify a TLS configuration, private
         *        integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsConfig(TlsConfigInput tlsConfig);

        /**
         * <p>
         * The TLS configuration for a private integration. If you specify a TLS configuration, private integration
         * traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * </p>
         * This is a convenience that creates an instance of the {@link TlsConfigInput.Builder} avoiding the need to
         * create one manually via {@link TlsConfigInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TlsConfigInput.Builder#build()} is called immediately and its
         * result is passed to {@link #tlsConfig(TlsConfigInput)}.
         * 
         * @param tlsConfig
         *        a consumer that will call methods on {@link TlsConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsConfig(TlsConfigInput)
         */
        default Builder tlsConfig(Consumer<TlsConfigInput.Builder> tlsConfig) {
            return tlsConfig(TlsConfigInput.builder().applyMutation(tlsConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String connectionId;

        private String connectionType;

        private String contentHandlingStrategy;

        private String credentialsArn;

        private String description;

        private String integrationId;

        private String integrationMethod;

        private String integrationSubtype;

        private String integrationType;

        private String integrationUri;

        private String passthroughBehavior;

        private String payloadFormatVersion;

        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Map<String, String>> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private String templateSelectionExpression;

        private Integer timeoutInMillis;

        private TlsConfigInput tlsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationRequest model) {
            super(model);
            apiId(model.apiId);
            connectionId(model.connectionId);
            connectionType(model.connectionType);
            contentHandlingStrategy(model.contentHandlingStrategy);
            credentialsArn(model.credentialsArn);
            description(model.description);
            integrationId(model.integrationId);
            integrationMethod(model.integrationMethod);
            integrationSubtype(model.integrationSubtype);
            integrationType(model.integrationType);
            integrationUri(model.integrationUri);
            passthroughBehavior(model.passthroughBehavior);
            payloadFormatVersion(model.payloadFormatVersion);
            requestParameters(model.requestParameters);
            requestTemplates(model.requestTemplates);
            responseParameters(model.responseParameters);
            templateSelectionExpression(model.templateSelectionExpression);
            timeoutInMillis(model.timeoutInMillis);
            tlsConfig(model.tlsConfig);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        @Transient
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        @Transient
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getContentHandlingStrategy() {
            return contentHandlingStrategy;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        @Override
        @Transient
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy == null ? null : contentHandlingStrategy.toString());
            return this;
        }

        public final String getCredentialsArn() {
            return credentialsArn;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        @Override
        @Transient
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIntegrationId() {
            return integrationId;
        }

        public final void setIntegrationId(String integrationId) {
            this.integrationId = integrationId;
        }

        @Override
        @Transient
        public final Builder integrationId(String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        public final String getIntegrationMethod() {
            return integrationMethod;
        }

        public final void setIntegrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
        }

        @Override
        @Transient
        public final Builder integrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
            return this;
        }

        public final String getIntegrationSubtype() {
            return integrationSubtype;
        }

        public final void setIntegrationSubtype(String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
        }

        @Override
        @Transient
        public final Builder integrationSubtype(String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
            return this;
        }

        public final String getIntegrationType() {
            return integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        @Transient
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        @Transient
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationUri() {
            return integrationUri;
        }

        public final void setIntegrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
        }

        @Override
        @Transient
        public final Builder integrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        public final String getPassthroughBehavior() {
            return passthroughBehavior;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        @Override
        @Transient
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior(passthroughBehavior == null ? null : passthroughBehavior.toString());
            return this;
        }

        public final String getPayloadFormatVersion() {
            return payloadFormatVersion;
        }

        public final void setPayloadFormatVersion(String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
        }

        @Override
        @Transient
        public final Builder payloadFormatVersion(String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        public final Map<String, String> getRequestParameters() {
            if (requestParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestParameters;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
        }

        @Override
        @Transient
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
            return this;
        }

        public final Map<String, String> getRequestTemplates() {
            if (requestTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return requestTemplates;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
        }

        @Override
        @Transient
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters;
        }

        public final void setResponseParameters(Map<String, ? extends Map<String, String>> responseParameters) {
            this.responseParameters = ResponseParametersCopier.copy(responseParameters);
        }

        @Override
        @Transient
        public final Builder responseParameters(Map<String, ? extends Map<String, String>> responseParameters) {
            this.responseParameters = ResponseParametersCopier.copy(responseParameters);
            return this;
        }

        public final String getTemplateSelectionExpression() {
            return templateSelectionExpression;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        @Override
        @Transient
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final Integer getTimeoutInMillis() {
            return timeoutInMillis;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        @Transient
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final TlsConfigInput.Builder getTlsConfig() {
            return tlsConfig != null ? tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfigInput.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder tlsConfig(TlsConfigInput tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIntegrationRequest build() {
            return new UpdateIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
