/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apigatewayv2.model.AccessDeniedException;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Exception;
import software.amazon.awssdk.services.apigatewayv2.model.BadRequestException;
import software.amazon.awssdk.services.apigatewayv2.model.ConflictException;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApisRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApisResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRoutesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetStagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetStagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetTagsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetTagsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ImportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.NotFoundException;
import software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ReimportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigatewayv2.model.TagResourceRequest;
import software.amazon.awssdk.services.apigatewayv2.model.TagResourceResponse;
import software.amazon.awssdk.services.apigatewayv2.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateApiMappingRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateRouteResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.CreateVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteAccessLogSettingsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteApiMappingRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteCorsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteRouteRequestParameterRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteRouteResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteRouteSettingsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.DeleteVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.ExportApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetApiMappingRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetApiMappingsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetApisRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetIntegrationResponsesRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetModelRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetModelTemplateRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetRouteRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetRouteResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetRouteResponsesRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetRoutesRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetStagesRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.GetVpcLinksRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.ImportApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.ReimportApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.ResetAuthorizersCacheRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateApiMappingRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateApiRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateRouteRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateRouteResponseRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.services.apigatewayv2.transform.UpdateVpcLinkRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ApiGatewayV2Client}.
 *
 * @see ApiGatewayV2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayV2Client implements ApiGatewayV2Client {
    private static final Logger log = Logger.loggerFor(DefaultApiGatewayV2Client.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApiGatewayV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates an Api resource.
     * </p>
     *
     * @param createApiRequest
     *        Creates a new Api resource to represent an API.
     * @return Result of the CreateApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateApi
     */
    @Override
    public CreateApiResponse createApi(CreateApiRequest createApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApi");

            return clientHandler.execute(new ClientExecutionParams<CreateApiRequest, CreateApiResponse>()
                    .withOperationName("CreateApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createApiRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an API mapping.
     * </p>
     *
     * @param createApiMappingRequest
     *        Creates a new ApiMapping resource to represent an API mapping.
     * @return Result of the CreateApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateApiMapping
     */
    @Override
    public CreateApiMappingResponse createApiMapping(CreateApiMappingRequest createApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiMappingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiMapping");

            return clientHandler.execute(new ClientExecutionParams<CreateApiMappingRequest, CreateApiMappingResponse>()
                    .withOperationName("CreateApiMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createApiMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Authorizer for an API.
     * </p>
     *
     * @param createAuthorizerRequest
     *        Creates a new Authorizer resource to represent an authorizer.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateAuthorizer
     */
    @Override
    public CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                    .withOperationName("CreateAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Deployment for an API.
     * </p>
     *
     * @param createDeploymentRequest
     *        Creates a new Deployment resource to represent a deployment.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateDeployment
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");

            return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                    .withOperationName("CreateDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        Creates a new DomainName resource to represent a domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateDomainName
     */
    @Override
    public CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainName");

            return clientHandler.execute(new ClientExecutionParams<CreateDomainNameRequest, CreateDomainNameResponse>()
                    .withOperationName("CreateDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Integration.
     * </p>
     *
     * @param createIntegrationRequest
     *        Creates a new Integration resource to represent an integration.
     * @return Result of the CreateIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateIntegration
     */
    @Override
    public CreateIntegrationResponse createIntegration(CreateIntegrationRequest createIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegration");

            return clientHandler.execute(new ClientExecutionParams<CreateIntegrationRequest, CreateIntegrationResponse>()
                    .withOperationName("CreateIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IntegrationResponses.
     * </p>
     *
     * @param createIntegrationResponseRequest
     *        Creates a new IntegrationResponse resource to represent an integration response.
     * @return Result of the CreateIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateIntegrationResponse
     */
    @Override
    public CreateIntegrationResponseResponse createIntegrationResponse(
            CreateIntegrationResponseRequest createIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIntegrationResponseRequest, CreateIntegrationResponseResponse>()
                            .withOperationName("CreateIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Model for an API.
     * </p>
     *
     * @param createModelRequest
     *        Creates a new Model.
     * @return Result of the CreateModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateModel
     */
    @Override
    public CreateModelResponse createModel(CreateModelRequest createModelRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");

            return clientHandler.execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                    .withOperationName("CreateModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Route for an API.
     * </p>
     *
     * @param createRouteRequest
     *        Creates a new Route resource to represent a route.
     * @return Result of the CreateRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateRoute
     */
    @Override
    public CreateRouteResponse createRoute(CreateRouteRequest createRouteRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRouteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoute");

            return clientHandler.execute(new ClientExecutionParams<CreateRouteRequest, CreateRouteResponse>()
                    .withOperationName("CreateRoute").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createRouteRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a RouteResponse for a Route.
     * </p>
     *
     * @param createRouteResponseRequest
     *        Creates a new RouteResponse resource to represent a route response.
     * @return Result of the CreateRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateRouteResponse
     */
    @Override
    public CreateRouteResponseResponse createRouteResponse(CreateRouteResponseRequest createRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRouteResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRouteResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouteResponse");

            return clientHandler.execute(new ClientExecutionParams<CreateRouteResponseRequest, CreateRouteResponseResponse>()
                    .withOperationName("CreateRouteResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createRouteResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouteResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Stage for an API.
     * </p>
     *
     * @param createStageRequest
     *        Creates a new Stage resource to represent a stage.
     * @return Result of the CreateStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateStage
     */
    @Override
    public CreateStageResponse createStage(CreateStageRequest createStageRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStage");

            return clientHandler.execute(new ClientExecutionParams<CreateStageRequest, CreateStageResponse>()
                    .withOperationName("CreateStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VPC link.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateVpcLink
     */
    @Override
    public CreateVpcLinkResponse createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcLink");

            return clientHandler.execute(new ClientExecutionParams<CreateVpcLinkRequest, CreateVpcLinkResponse>()
                    .withOperationName("CreateVpcLink").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createVpcLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     * </p>
     *
     * @param deleteAccessLogSettingsRequest
     * @return Result of the DeleteAccessLogSettings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteAccessLogSettings
     */
    @Override
    public DeleteAccessLogSettingsResponse deleteAccessLogSettings(DeleteAccessLogSettingsRequest deleteAccessLogSettingsRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccessLogSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccessLogSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessLogSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessLogSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessLogSettingsRequest, DeleteAccessLogSettingsResponse>()
                            .withOperationName("DeleteAccessLogSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccessLogSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccessLogSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Api resource.
     * </p>
     *
     * @param deleteApiRequest
     * @return Result of the DeleteApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteApi
     */
    @Override
    public DeleteApiResponse deleteApi(DeleteApiRequest deleteApiRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApi");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiRequest, DeleteApiResponse>()
                    .withOperationName("DeleteApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteApiRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an API mapping.
     * </p>
     *
     * @param deleteApiMappingRequest
     * @return Result of the DeleteApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteApiMapping
     */
    @Override
    public DeleteApiMappingResponse deleteApiMapping(DeleteApiMappingRequest deleteApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiMappingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiMapping");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiMappingRequest, DeleteApiMappingResponse>()
                    .withOperationName("DeleteApiMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteApiMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApiMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Authorizer.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteAuthorizer
     */
    @Override
    public DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                    .withOperationName("DeleteAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a CORS configuration.
     * </p>
     *
     * @param deleteCorsConfigurationRequest
     * @return Result of the DeleteCorsConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteCorsConfiguration
     */
    @Override
    public DeleteCorsConfigurationResponse deleteCorsConfiguration(DeleteCorsConfigurationRequest deleteCorsConfigurationRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCorsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCorsConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCorsConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCorsConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCorsConfigurationRequest, DeleteCorsConfigurationResponse>()
                            .withOperationName("DeleteCorsConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteCorsConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCorsConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Deployment.
     * </p>
     *
     * @param deleteDeploymentRequest
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteDeployment
     */
    @Override
    public DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeployment");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentRequest, DeleteDeploymentResponse>()
                    .withOperationName("DeleteDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a domain name.
     * </p>
     *
     * @param deleteDomainNameRequest
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteDomainName
     */
    @Override
    public DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainName");

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainNameRequest, DeleteDomainNameResponse>()
                    .withOperationName("DeleteDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteIntegration
     */
    @Override
    public DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");

            return clientHandler.execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                    .withOperationName("DeleteIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an IntegrationResponses.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteIntegrationResponse
     */
    @Override
    public DeleteIntegrationResponseResponse deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse>()
                            .withOperationName("DeleteIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Model.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteModel
     */
    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                    .withOperationName("DeleteModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Route.
     * </p>
     *
     * @param deleteRouteRequest
     * @return Result of the DeleteRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRoute
     */
    @Override
    public DeleteRouteResponse deleteRoute(DeleteRouteRequest deleteRouteRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoute");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteRequest, DeleteRouteResponse>()
                    .withOperationName("DeleteRoute").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteRouteRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a route request parameter.
     * </p>
     *
     * @param deleteRouteRequestParameterRequest
     * @return Result of the DeleteRouteRequestParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteRequestParameter
     */
    @Override
    public DeleteRouteRequestParameterResponse deleteRouteRequestParameter(
            DeleteRouteRequestParameterRequest deleteRouteRequestParameterRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouteRequestParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRouteRequestParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteRequestParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteRequestParameter");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRouteRequestParameterRequest, DeleteRouteRequestParameterResponse>()
                            .withOperationName("DeleteRouteRequestParameter").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRouteRequestParameterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRouteRequestParameterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a RouteResponse.
     * </p>
     *
     * @param deleteRouteResponseRequest
     * @return Result of the DeleteRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteResponse
     */
    @Override
    public DeleteRouteResponseResponse deleteRouteResponse(DeleteRouteResponseRequest deleteRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouteResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRouteResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteResponse");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteResponseRequest, DeleteRouteResponseResponse>()
                    .withOperationName("DeleteRouteResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteRouteResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the RouteSettings for a stage.
     * </p>
     *
     * @param deleteRouteSettingsRequest
     * @return Result of the DeleteRouteSettings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteSettings
     */
    @Override
    public DeleteRouteSettingsResponse deleteRouteSettings(DeleteRouteSettingsRequest deleteRouteSettingsRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouteSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRouteSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteSettingsRequest, DeleteRouteSettingsResponse>()
                    .withOperationName("DeleteRouteSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteRouteSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Stage.
     * </p>
     *
     * @param deleteStageRequest
     * @return Result of the DeleteStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteStage
     */
    @Override
    public DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStage");

            return clientHandler.execute(new ClientExecutionParams<DeleteStageRequest, DeleteStageResponse>()
                    .withOperationName("DeleteStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a VPC link.
     * </p>
     *
     * @param deleteVpcLinkRequest
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteVpcLink
     */
    @Override
    public DeleteVpcLinkResponse deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcLink");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpcLinkRequest, DeleteVpcLinkResponse>()
                    .withOperationName("DeleteVpcLink").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpcLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the ExportApi operation.
     *
     * @param exportApiRequest
     * @return Result of the ExportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ExportApi
     */
    @Override
    public ExportApiResponse exportApi(ExportApiRequest exportApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<ExportApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExportApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportApi");

            return clientHandler.execute(new ClientExecutionParams<ExportApiRequest, ExportApiResponse>()
                    .withOperationName("ExportApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(exportApiRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ExportApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an Api resource.
     * </p>
     *
     * @param getApiRequest
     * @return Result of the GetApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApi
     */
    @Override
    public GetApiResponse getApi(GetApiRequest getApiRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApi");

            return clientHandler.execute(new ClientExecutionParams<GetApiRequest, GetApiResponse>().withOperationName("GetApi")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getApiRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an API mapping.
     * </p>
     *
     * @param getApiMappingRequest
     * @return Result of the GetApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApiMapping
     */
    @Override
    public GetApiMappingResponse getApiMapping(GetApiMappingRequest getApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiMappingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiMapping");

            return clientHandler.execute(new ClientExecutionParams<GetApiMappingRequest, GetApiMappingResponse>()
                    .withOperationName("GetApiMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getApiMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApiMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets API mappings.
     * </p>
     *
     * @param getApiMappingsRequest
     * @return Result of the GetApiMappings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApiMappings
     */
    @Override
    public GetApiMappingsResponse getApiMappings(GetApiMappingsRequest getApiMappingsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiMappingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiMappingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiMappings");

            return clientHandler.execute(new ClientExecutionParams<GetApiMappingsRequest, GetApiMappingsResponse>()
                    .withOperationName("GetApiMappings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getApiMappingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApiMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     *
     * @param getApisRequest
     * @return Result of the GetApis operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApis
     */
    @Override
    public GetApisResponse getApis(GetApisRequest getApisRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApis");

            return clientHandler.execute(new ClientExecutionParams<GetApisRequest, GetApisResponse>()
                    .withOperationName("GetApis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getApisRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an Authorizer.
     * </p>
     *
     * @param getAuthorizerRequest
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetAuthorizer
     */
    @Override
    public GetAuthorizerResponse getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<GetAuthorizerRequest, GetAuthorizerResponse>()
                    .withOperationName("GetAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Authorizers for an API.
     * </p>
     *
     * @param getAuthorizersRequest
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetAuthorizers
     */
    @Override
    public GetAuthorizersResponse getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAuthorizersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizers");

            return clientHandler.execute(new ClientExecutionParams<GetAuthorizersRequest, GetAuthorizersResponse>()
                    .withOperationName("GetAuthorizers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAuthorizersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAuthorizersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a Deployment.
     * </p>
     *
     * @param getDeploymentRequest
     * @return Result of the GetDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDeployment
     */
    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                    .withOperationName("GetDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Deployments for an API.
     * </p>
     *
     * @param getDeploymentsRequest
     * @return Result of the GetDeployments operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDeployments
     */
    @Override
    public GetDeploymentsResponse getDeployments(GetDeploymentsRequest getDeploymentsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeploymentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployments");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentsRequest, GetDeploymentsResponse>()
                    .withOperationName("GetDeployments").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a domain name.
     * </p>
     *
     * @param getDomainNameRequest
     * @return Result of the GetDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainName
     */
    @Override
    public GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainName");

            return clientHandler.execute(new ClientExecutionParams<GetDomainNameRequest, GetDomainNameResponse>()
                    .withOperationName("GetDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     *
     * @param getDomainNamesRequest
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainNames
     */
    @Override
    public GetDomainNamesResponse getDomainNames(GetDomainNamesRequest getDomainNamesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDomainNamesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainNames");

            return clientHandler.execute(new ClientExecutionParams<GetDomainNamesRequest, GetDomainNamesResponse>()
                    .withOperationName("GetDomainNames").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDomainNamesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDomainNamesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an Integration.
     * </p>
     *
     * @param getIntegrationRequest
     * @return Result of the GetIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegration
     */
    @Override
    public GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegration");

            return clientHandler.execute(new ClientExecutionParams<GetIntegrationRequest, GetIntegrationResponse>()
                    .withOperationName("GetIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an IntegrationResponses.
     * </p>
     *
     * @param getIntegrationResponseRequest
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrationResponse
     */
    @Override
    public GetIntegrationResponseResponse getIntegrationResponse(GetIntegrationResponseRequest getIntegrationResponseRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationResponseRequest, GetIntegrationResponseResponse>()
                            .withOperationName("GetIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the IntegrationResponses for an Integration.
     * </p>
     *
     * @param getIntegrationResponsesRequest
     * @return Result of the GetIntegrationResponses operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrationResponses
     */
    @Override
    public GetIntegrationResponsesResponse getIntegrationResponses(GetIntegrationResponsesRequest getIntegrationResponsesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIntegrationResponsesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegrationResponses");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationResponsesRequest, GetIntegrationResponsesResponse>()
                            .withOperationName("GetIntegrationResponses").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getIntegrationResponsesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIntegrationResponsesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Integrations for an API.
     * </p>
     *
     * @param getIntegrationsRequest
     * @return Result of the GetIntegrations operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrations
     */
    @Override
    public GetIntegrationsResponse getIntegrations(GetIntegrationsRequest getIntegrationsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIntegrationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegrations");

            return clientHandler.execute(new ClientExecutionParams<GetIntegrationsRequest, GetIntegrationsResponse>()
                    .withOperationName("GetIntegrations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getIntegrationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIntegrationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a Model.
     * </p>
     *
     * @param getModelRequest
     * @return Result of the GetModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModel
     */
    @Override
    public GetModelResponse getModel(GetModelRequest getModelRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModel");

            return clientHandler.execute(new ClientExecutionParams<GetModelRequest, GetModelResponse>()
                    .withOperationName("GetModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getModelRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a model template.
     * </p>
     *
     * @param getModelTemplateRequest
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModelTemplate
     */
    @Override
    public GetModelTemplateResponse getModelTemplate(GetModelTemplateRequest getModelTemplateRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetModelTemplateRequest, GetModelTemplateResponse>()
                    .withOperationName("GetModelTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getModelTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetModelTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Models for an API.
     * </p>
     *
     * @param getModelsRequest
     * @return Result of the GetModels operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModels
     */
    @Override
    public GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModels");

            return clientHandler.execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>()
                    .withOperationName("GetModels").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getModelsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a Route.
     * </p>
     *
     * @param getRouteRequest
     * @return Result of the GetRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRoute
     */
    @Override
    public GetRouteResponse getRoute(GetRouteRequest getRouteRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRoute");

            return clientHandler.execute(new ClientExecutionParams<GetRouteRequest, GetRouteResponse>()
                    .withOperationName("GetRoute").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRouteRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a RouteResponse.
     * </p>
     *
     * @param getRouteResponseRequest
     * @return Result of the GetRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRouteResponse
     */
    @Override
    public GetRouteResponseResponse getRouteResponse(GetRouteResponseRequest getRouteResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouteResponseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRouteResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouteResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouteResponse");

            return clientHandler.execute(new ClientExecutionParams<GetRouteResponseRequest, GetRouteResponseResponse>()
                    .withOperationName("GetRouteResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRouteResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRouteResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the RouteResponses for a Route.
     * </p>
     *
     * @param getRouteResponsesRequest
     * @return Result of the GetRouteResponses operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRouteResponses
     */
    @Override
    public GetRouteResponsesResponse getRouteResponses(GetRouteResponsesRequest getRouteResponsesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouteResponsesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRouteResponsesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouteResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouteResponses");

            return clientHandler.execute(new ClientExecutionParams<GetRouteResponsesRequest, GetRouteResponsesResponse>()
                    .withOperationName("GetRouteResponses").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRouteResponsesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRouteResponsesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Routes for an API.
     * </p>
     *
     * @param getRoutesRequest
     * @return Result of the GetRoutes operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRoutes
     */
    @Override
    public GetRoutesResponse getRoutes(GetRoutesRequest getRoutesRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRoutesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRoutes");

            return clientHandler.execute(new ClientExecutionParams<GetRoutesRequest, GetRoutesResponse>()
                    .withOperationName("GetRoutes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRoutesRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRoutesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a Stage.
     * </p>
     *
     * @param getStageRequest
     * @return Result of the GetStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetStage
     */
    @Override
    public GetStageResponse getStage(GetStageRequest getStageRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStage");

            return clientHandler.execute(new ClientExecutionParams<GetStageRequest, GetStageResponse>()
                    .withOperationName("GetStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStageRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetStageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Stages for an API.
     * </p>
     *
     * @param getStagesRequest
     * @return Result of the GetStages operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetStages
     */
    @Override
    public GetStagesResponse getStages(GetStagesRequest getStagesRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStages");

            return clientHandler.execute(new ClientExecutionParams<GetStagesRequest, GetStagesResponse>()
                    .withOperationName("GetStages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStagesRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetStagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a collection of Tag resources.
     * </p>
     *
     * @param getTagsRequest
     * @return Result of the GetTags operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetTags
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTags");

            return clientHandler.execute(new ClientExecutionParams<GetTagsRequest, GetTagsResponse>()
                    .withOperationName("GetTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTagsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a VPC link.
     * </p>
     *
     * @param getVpcLinkRequest
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetVpcLink
     */
    @Override
    public GetVpcLinkResponse getVpcLink(GetVpcLinkRequest getVpcLinkRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLink");

            return clientHandler
                    .execute(new ClientExecutionParams<GetVpcLinkRequest, GetVpcLinkResponse>().withOperationName("GetVpcLink")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getVpcLinkRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a collection of VPC links.
     * </p>
     *
     * @param getVpcLinksRequest
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetVpcLinks
     */
    @Override
    public GetVpcLinksResponse getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVpcLinksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVpcLinksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLinks");

            return clientHandler.execute(new ClientExecutionParams<GetVpcLinksRequest, GetVpcLinksResponse>()
                    .withOperationName("GetVpcLinks").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getVpcLinksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVpcLinksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports an API.
     * </p>
     *
     * @param importApiRequest
     * @return Result of the ImportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ImportApi
     */
    @Override
    public ImportApiResponse importApi(ImportApiRequest importApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportApi");

            return clientHandler.execute(new ClientExecutionParams<ImportApiRequest, ImportApiResponse>()
                    .withOperationName("ImportApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importApiRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ImportApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Puts an Api resource.
     * </p>
     *
     * @param reimportApiRequest
     * @return Result of the ReimportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ReimportApi
     */
    @Override
    public ReimportApiResponse reimportApi(ReimportApiRequest reimportApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ReimportApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ReimportApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, reimportApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReimportApi");

            return clientHandler.execute(new ClientExecutionParams<ReimportApiRequest, ReimportApiResponse>()
                    .withOperationName("ReimportApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(reimportApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ReimportApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     * </p>
     *
     * @param resetAuthorizersCacheRequest
     * @return Result of the ResetAuthorizersCache operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ResetAuthorizersCache
     */
    @Override
    public ResetAuthorizersCacheResponse resetAuthorizersCache(ResetAuthorizersCacheRequest resetAuthorizersCacheRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetAuthorizersCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ResetAuthorizersCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetAuthorizersCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetAuthorizersCache");

            return clientHandler.execute(new ClientExecutionParams<ResetAuthorizersCacheRequest, ResetAuthorizersCacheResponse>()
                    .withOperationName("ResetAuthorizersCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resetAuthorizersCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResetAuthorizersCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Tag resource to represent a tag.
     * </p>
     *
     * @param tagResourceRequest
     *        Creates a new Tag resource to represent a tag.
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.TagResource
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Tag.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UntagResource
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Api resource.
     * </p>
     *
     * @param updateApiRequest
     *        Updates an Api.
     * @return Result of the UpdateApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateApi
     */
    @Override
    public UpdateApiResponse updateApi(UpdateApiRequest updateApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApi");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiRequest, UpdateApiResponse>()
                    .withOperationName("UpdateApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateApiRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The API mapping.
     * </p>
     *
     * @param updateApiMappingRequest
     *        Updates an ApiMapping.
     * @return Result of the UpdateApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateApiMapping
     */
    @Override
    public UpdateApiMappingResponse updateApiMapping(UpdateApiMappingRequest updateApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiMappingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiMapping");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiMappingRequest, UpdateApiMappingResponse>()
                    .withOperationName("UpdateApiMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateApiMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApiMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Authorizer.
     * </p>
     *
     * @param updateAuthorizerRequest
     *        Updates an Authorizer.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateAuthorizer
     */
    @Override
    public UpdateAuthorizerResponse updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                    .withOperationName("UpdateAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Deployment.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Updates a Deployment.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateDeployment
     */
    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest updateDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeployment");

            return clientHandler.execute(new ClientExecutionParams<UpdateDeploymentRequest, UpdateDeploymentResponse>()
                    .withOperationName("UpdateDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a domain name.
     * </p>
     *
     * @param updateDomainNameRequest
     *        Updates a DomainName.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateDomainName
     */
    @Override
    public UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainName");

            return clientHandler.execute(new ClientExecutionParams<UpdateDomainNameRequest, UpdateDomainNameResponse>()
                    .withOperationName("UpdateDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Updates an Integration.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateIntegration
     */
    @Override
    public UpdateIntegrationResponse updateIntegration(UpdateIntegrationRequest updateIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegration");

            return clientHandler.execute(new ClientExecutionParams<UpdateIntegrationRequest, UpdateIntegrationResponse>()
                    .withOperationName("UpdateIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an IntegrationResponses.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Updates an IntegrationResponses.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateIntegrationResponse
     */
    @Override
    public UpdateIntegrationResponseResponse updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse>()
                            .withOperationName("UpdateIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Model.
     * </p>
     *
     * @param updateModelRequest
     *        Updates a Model.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateModel
     */
    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModel");

            return clientHandler.execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                    .withOperationName("UpdateModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Route.
     * </p>
     *
     * @param updateRouteRequest
     *        Updates a Route.
     * @return Result of the UpdateRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateRoute
     */
    @Override
    public UpdateRouteResponse updateRoute(UpdateRouteRequest updateRouteRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRouteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRoute");

            return clientHandler.execute(new ClientExecutionParams<UpdateRouteRequest, UpdateRouteResponse>()
                    .withOperationName("UpdateRoute").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateRouteRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a RouteResponse.
     * </p>
     *
     * @param updateRouteResponseRequest
     *        Updates a RouteResponse.
     * @return Result of the UpdateRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateRouteResponse
     */
    @Override
    public UpdateRouteResponseResponse updateRouteResponse(UpdateRouteResponseRequest updateRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRouteResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRouteResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouteResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouteResponse");

            return clientHandler.execute(new ClientExecutionParams<UpdateRouteResponseRequest, UpdateRouteResponseResponse>()
                    .withOperationName("UpdateRouteResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateRouteResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRouteResponseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Stage.
     * </p>
     *
     * @param updateStageRequest
     *        Updates a Stage.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateStage
     */
    @Override
    public UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStage");

            return clientHandler.execute(new ClientExecutionParams<UpdateStageRequest, UpdateStageResponse>()
                    .withOperationName("UpdateStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a VPC link.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates a VPC link.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateVpcLink
     */
    @Override
    public UpdateVpcLinkResponse updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ApiGatewayV2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVpcLink");

            return clientHandler.execute(new ClientExecutionParams<UpdateVpcLinkRequest, UpdateVpcLinkResponse>()
                    .withOperationName("UpdateVpcLink").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateVpcLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ApiGatewayV2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
