/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthorizationType {
    NONE("NONE"),
    AWS_IAM("AWS_IAM"),
    CUSTOM("CUSTOM"),
    JWT("JWT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthorizationType> VALUE_MAP;
    private final String value;

    private AuthorizationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthorizationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthorizationType> knownValues() {
        EnumSet<AuthorizationType> knownValues = EnumSet.allOf(AuthorizationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthorizationType.class, AuthorizationType::toString);
    }
}

