/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.apigatewayv2.model.AccessDeniedException;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Exception;
import software.amazon.awssdk.services.apigatewayv2.model.BadRequestException;
import software.amazon.awssdk.services.apigatewayv2.model.ConflictException;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApisRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApisResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRoutesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetStagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetStagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetTagsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetTagsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ImportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.NotFoundException;
import software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ReimportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigatewayv2.model.TagResourceRequest;
import software.amazon.awssdk.services.apigatewayv2.model.TagResourceResponse;
import software.amazon.awssdk.services.apigatewayv2.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkResponse;

/**
 * Service client for accessing AmazonApiGatewayV2. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon API Gateway V2
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApiGatewayV2Client extends AwsClient {
    String SERVICE_NAME = "apigateway";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "apigateway";

    /**
     * <p>
     * Creates an Api resource.
     * </p>
     *
     * @param createApiRequest
     *        Creates a new Api resource to represent an API.
     * @return Result of the CreateApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateApi
     */
    default CreateApiResponse createApi(CreateApiRequest createApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiRequest#builder()}
     * </p>
     *
     * @param createApiRequest
     *        A {@link Consumer} that will call methods on {@link CreateApiRequest.Builder} to create a request. Creates
     *        a new Api resource to represent an API.
     * @return Result of the CreateApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateApi
     */
    default CreateApiResponse createApi(Consumer<CreateApiRequest.Builder> createApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return createApi(CreateApiRequest.builder().applyMutation(createApiRequest).build());
    }

    /**
     * <p>
     * Creates an API mapping.
     * </p>
     *
     * @param createApiMappingRequest
     *        Creates a new ApiMapping resource to represent an API mapping.
     * @return Result of the CreateApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateApiMapping
     */
    default CreateApiMappingResponse createApiMapping(CreateApiMappingRequest createApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiMappingRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApiMappingRequest#builder()}
     * </p>
     *
     * @param createApiMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateApiMappingRequest.Builder} to create a request.
     *        Creates a new ApiMapping resource to represent an API mapping.
     * @return Result of the CreateApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateApiMapping
     */
    default CreateApiMappingResponse createApiMapping(Consumer<CreateApiMappingRequest.Builder> createApiMappingRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return createApiMapping(CreateApiMappingRequest.builder().applyMutation(createApiMappingRequest).build());
    }

    /**
     * <p>
     * Creates an Authorizer for an API.
     * </p>
     *
     * @param createAuthorizerRequest
     *        Creates a new Authorizer resource to represent an authorizer.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateAuthorizer
     */
    default CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Authorizer for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAuthorizerRequest#builder()}
     * </p>
     *
     * @param createAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link CreateAuthorizerRequest.Builder} to create a request.
     *        Creates a new Authorizer resource to represent an authorizer.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateAuthorizer
     */
    default CreateAuthorizerResponse createAuthorizer(Consumer<CreateAuthorizerRequest.Builder> createAuthorizerRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return createAuthorizer(CreateAuthorizerRequest.builder().applyMutation(createAuthorizerRequest).build());
    }

    /**
     * <p>
     * Creates a Deployment for an API.
     * </p>
     *
     * @param createDeploymentRequest
     *        Creates a new Deployment resource to represent a deployment.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateDeployment
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Deployment for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentRequest.Builder} to create a request.
     *        Creates a new Deployment resource to represent a deployment.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateDeployment
     */
    default CreateDeploymentResponse createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        Creates a new DomainName resource to represent a domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateDomainName
     */
    default CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainNameRequest#builder()}
     * </p>
     *
     * @param createDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainNameRequest.Builder} to create a request.
     *        Creates a new DomainName resource to represent a domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws AccessDeniedException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateDomainName
     */
    default CreateDomainNameResponse createDomainName(Consumer<CreateDomainNameRequest.Builder> createDomainNameRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AccessDeniedException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return createDomainName(CreateDomainNameRequest.builder().applyMutation(createDomainNameRequest).build());
    }

    /**
     * <p>
     * Creates an Integration.
     * </p>
     *
     * @param createIntegrationRequest
     *        Creates a new Integration resource to represent an integration.
     * @return Result of the CreateIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateIntegration
     */
    default CreateIntegrationResponse createIntegration(CreateIntegrationRequest createIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIntegrationRequest#builder()}
     * </p>
     *
     * @param createIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntegrationRequest.Builder} to create a request.
     *        Creates a new Integration resource to represent an integration.
     * @return Result of the CreateIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateIntegration
     */
    default CreateIntegrationResponse createIntegration(Consumer<CreateIntegrationRequest.Builder> createIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return createIntegration(CreateIntegrationRequest.builder().applyMutation(createIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates an IntegrationResponses.
     * </p>
     *
     * @param createIntegrationResponseRequest
     *        Creates a new IntegrationResponse resource to represent an integration response.
     * @return Result of the CreateIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateIntegrationResponse
     */
    default CreateIntegrationResponseResponse createIntegrationResponse(
            CreateIntegrationResponseRequest createIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param createIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntegrationResponseRequest.Builder} to create a
     *        request. Creates a new IntegrationResponse resource to represent an integration response.
     * @return Result of the CreateIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateIntegrationResponse
     */
    default CreateIntegrationResponseResponse createIntegrationResponse(
            Consumer<CreateIntegrationResponseRequest.Builder> createIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return createIntegrationResponse(CreateIntegrationResponseRequest.builder()
                .applyMutation(createIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Creates a Model for an API.
     * </p>
     *
     * @param createModelRequest
     *        Creates a new Model.
     * @return Result of the CreateModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateModel
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Model for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelRequest.Builder} to create a request.
     *        Creates a new Model.
     * @return Result of the CreateModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateModel
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a Route for an API.
     * </p>
     *
     * @param createRouteRequest
     *        Creates a new Route resource to represent a route.
     * @return Result of the CreateRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateRoute
     */
    default CreateRouteResponse createRoute(CreateRouteRequest createRouteRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Route for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRouteRequest#builder()}
     * </p>
     *
     * @param createRouteRequest
     *        A {@link Consumer} that will call methods on {@link CreateRouteRequest.Builder} to create a request.
     *        Creates a new Route resource to represent a route.
     * @return Result of the CreateRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateRoute
     */
    default CreateRouteResponse createRoute(Consumer<CreateRouteRequest.Builder> createRouteRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return createRoute(CreateRouteRequest.builder().applyMutation(createRouteRequest).build());
    }

    /**
     * <p>
     * Creates a RouteResponse for a Route.
     * </p>
     *
     * @param createRouteResponseRequest
     *        Creates a new RouteResponse resource to represent a route response.
     * @return Result of the CreateRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateRouteResponse
     */
    default CreateRouteResponseResponse createRouteResponse(CreateRouteResponseRequest createRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a RouteResponse for a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteResponseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRouteResponseRequest#builder()}
     * </p>
     *
     * @param createRouteResponseRequest
     *        A {@link Consumer} that will call methods on {@link CreateRouteResponseRequest.Builder} to create a
     *        request. Creates a new RouteResponse resource to represent a route response.
     * @return Result of the CreateRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateRouteResponse
     */
    default CreateRouteResponseResponse createRouteResponse(
            Consumer<CreateRouteResponseRequest.Builder> createRouteResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return createRouteResponse(CreateRouteResponseRequest.builder().applyMutation(createRouteResponseRequest).build());
    }

    /**
     * <p>
     * Creates a Stage for an API.
     * </p>
     *
     * @param createStageRequest
     *        Creates a new Stage resource to represent a stage.
     * @return Result of the CreateStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateStage
     */
    default CreateStageResponse createStage(CreateStageRequest createStageRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Stage for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on {@link CreateStageRequest.Builder} to create a request.
     *        Creates a new Stage resource to represent a stage.
     * @return Result of the CreateStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateStage
     */
    default CreateStageResponse createStage(Consumer<CreateStageRequest.Builder> createStageRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Creates a VPC link.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateVpcLink
     */
    default CreateVpcLinkResponse createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVpcLinkRequest#builder()}
     * </p>
     *
     * @param createVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcLinkRequest.Builder} to create a request.
     *        Creates a VPC link
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.CreateVpcLink
     */
    default CreateVpcLinkResponse createVpcLink(Consumer<CreateVpcLinkRequest.Builder> createVpcLinkRequest)
            throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return createVpcLink(CreateVpcLinkRequest.builder().applyMutation(createVpcLinkRequest).build());
    }

    /**
     * <p>
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     * </p>
     *
     * @param deleteAccessLogSettingsRequest
     * @return Result of the DeleteAccessLogSettings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteAccessLogSettings
     */
    default DeleteAccessLogSettingsResponse deleteAccessLogSettings(DeleteAccessLogSettingsRequest deleteAccessLogSettingsRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessLogSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccessLogSettingsRequest#builder()}
     * </p>
     *
     * @param deleteAccessLogSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessLogSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccessLogSettings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteAccessLogSettings
     */
    default DeleteAccessLogSettingsResponse deleteAccessLogSettings(
            Consumer<DeleteAccessLogSettingsRequest.Builder> deleteAccessLogSettingsRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteAccessLogSettings(DeleteAccessLogSettingsRequest.builder().applyMutation(deleteAccessLogSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Api resource.
     * </p>
     *
     * @param deleteApiRequest
     * @return Result of the DeleteApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteApi
     */
    default DeleteApiResponse deleteApi(DeleteApiRequest deleteApiRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiRequest#builder()}
     * </p>
     *
     * @param deleteApiRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApiRequest.Builder} to create a request.
     * @return Result of the DeleteApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteApi
     */
    default DeleteApiResponse deleteApi(Consumer<DeleteApiRequest.Builder> deleteApiRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteApi(DeleteApiRequest.builder().applyMutation(deleteApiRequest).build());
    }

    /**
     * <p>
     * Deletes an API mapping.
     * </p>
     *
     * @param deleteApiMappingRequest
     * @return Result of the DeleteApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteApiMapping
     */
    default DeleteApiMappingResponse deleteApiMapping(DeleteApiMappingRequest deleteApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiMappingRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApiMappingRequest#builder()}
     * </p>
     *
     * @param deleteApiMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApiMappingRequest.Builder} to create a request.
     * @return Result of the DeleteApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteApiMapping
     */
    default DeleteApiMappingResponse deleteApiMapping(Consumer<DeleteApiMappingRequest.Builder> deleteApiMappingRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return deleteApiMapping(DeleteApiMappingRequest.builder().applyMutation(deleteApiMappingRequest).build());
    }

    /**
     * <p>
     * Deletes an Authorizer.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteAuthorizer
     */
    default DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthorizerRequest#builder()}
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAuthorizerRequest.Builder} to create a request.
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteAuthorizer
     */
    default DeleteAuthorizerResponse deleteAuthorizer(Consumer<DeleteAuthorizerRequest.Builder> deleteAuthorizerRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteAuthorizer(DeleteAuthorizerRequest.builder().applyMutation(deleteAuthorizerRequest).build());
    }

    /**
     * <p>
     * Deletes a CORS configuration.
     * </p>
     *
     * @param deleteCorsConfigurationRequest
     * @return Result of the DeleteCorsConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteCorsConfiguration
     */
    default DeleteCorsConfigurationResponse deleteCorsConfiguration(DeleteCorsConfigurationRequest deleteCorsConfigurationRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CORS configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCorsConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCorsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteCorsConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCorsConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCorsConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteCorsConfiguration
     */
    default DeleteCorsConfigurationResponse deleteCorsConfiguration(
            Consumer<DeleteCorsConfigurationRequest.Builder> deleteCorsConfigurationRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteCorsConfiguration(DeleteCorsConfigurationRequest.builder().applyMutation(deleteCorsConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Deployment.
     * </p>
     *
     * @param deleteDeploymentRequest
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteDeployment
     */
    default DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeploymentRequest.Builder} to create a request.
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteDeployment
     */
    default DeleteDeploymentResponse deleteDeployment(Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a domain name.
     * </p>
     *
     * @param deleteDomainNameRequest
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteDomainName
     */
    default DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainNameRequest#builder()}
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainNameRequest.Builder} to create a request.
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteDomainName
     */
    default DeleteDomainNameResponse deleteDomainName(Consumer<DeleteDomainNameRequest.Builder> deleteDomainNameRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteDomainName(DeleteDomainNameRequest.builder().applyMutation(deleteDomainNameRequest).build());
    }

    /**
     * <p>
     * Deletes an Integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteIntegration
     */
    default DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntegrationRequest.Builder} to create a request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteIntegration
     */
    default DeleteIntegrationResponse deleteIntegration(Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes an IntegrationResponses.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteIntegrationResponse
     */
    default DeleteIntegrationResponseResponse deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntegrationResponseRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteIntegrationResponse
     */
    default DeleteIntegrationResponseResponse deleteIntegrationResponse(
            Consumer<DeleteIntegrationResponseRequest.Builder> deleteIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteIntegrationResponse(DeleteIntegrationResponseRequest.builder()
                .applyMutation(deleteIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Deletes a Model.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteModel
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelRequest.Builder} to create a request.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteModel
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a Route.
     * </p>
     *
     * @param deleteRouteRequest
     * @return Result of the DeleteRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRoute
     */
    default DeleteRouteResponse deleteRoute(DeleteRouteRequest deleteRouteRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRouteRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteRequest.Builder} to create a request.
     * @return Result of the DeleteRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRoute
     */
    default DeleteRouteResponse deleteRoute(Consumer<DeleteRouteRequest.Builder> deleteRouteRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteRoute(DeleteRouteRequest.builder().applyMutation(deleteRouteRequest).build());
    }

    /**
     * <p>
     * Deletes a route request parameter.
     * </p>
     *
     * @param deleteRouteRequestParameterRequest
     * @return Result of the DeleteRouteRequestParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteRequestParameter
     */
    default DeleteRouteRequestParameterResponse deleteRouteRequestParameter(
            DeleteRouteRequestParameterRequest deleteRouteRequestParameterRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a route request parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequestParameterRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRouteRequestParameterRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequestParameterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteRequestParameterRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteRouteRequestParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteRequestParameter
     */
    default DeleteRouteRequestParameterResponse deleteRouteRequestParameter(
            Consumer<DeleteRouteRequestParameterRequest.Builder> deleteRouteRequestParameterRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteRouteRequestParameter(DeleteRouteRequestParameterRequest.builder()
                .applyMutation(deleteRouteRequestParameterRequest).build());
    }

    /**
     * <p>
     * Deletes a RouteResponse.
     * </p>
     *
     * @param deleteRouteResponseRequest
     * @return Result of the DeleteRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteResponse
     */
    default DeleteRouteResponseResponse deleteRouteResponse(DeleteRouteResponseRequest deleteRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a RouteResponse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouteResponseRequest#builder()}
     * </p>
     *
     * @param deleteRouteResponseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteResponseRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteResponse
     */
    default DeleteRouteResponseResponse deleteRouteResponse(
            Consumer<DeleteRouteResponseRequest.Builder> deleteRouteResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteRouteResponse(DeleteRouteResponseRequest.builder().applyMutation(deleteRouteResponseRequest).build());
    }

    /**
     * <p>
     * Deletes the RouteSettings for a stage.
     * </p>
     *
     * @param deleteRouteSettingsRequest
     * @return Result of the DeleteRouteSettings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteSettings
     */
    default DeleteRouteSettingsResponse deleteRouteSettings(DeleteRouteSettingsRequest deleteRouteSettingsRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the RouteSettings for a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouteSettingsRequest#builder()}
     * </p>
     *
     * @param deleteRouteSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRouteSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRouteSettings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteRouteSettings
     */
    default DeleteRouteSettingsResponse deleteRouteSettings(
            Consumer<DeleteRouteSettingsRequest.Builder> deleteRouteSettingsRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteRouteSettings(DeleteRouteSettingsRequest.builder().applyMutation(deleteRouteSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes a Stage.
     * </p>
     *
     * @param deleteStageRequest
     * @return Result of the DeleteStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteStage
     */
    default DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStageRequest.Builder} to create a request.
     * @return Result of the DeleteStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteStage
     */
    default DeleteStageResponse deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Deletes a VPC link.
     * </p>
     *
     * @param deleteVpcLinkRequest
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteVpcLink
     */
    default DeleteVpcLinkResponse deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVpcLinkRequest#builder()}
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcLinkRequest.Builder} to create a request.
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.DeleteVpcLink
     */
    default DeleteVpcLinkResponse deleteVpcLink(Consumer<DeleteVpcLinkRequest.Builder> deleteVpcLinkRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return deleteVpcLink(DeleteVpcLinkRequest.builder().applyMutation(deleteVpcLinkRequest).build());
    }

    /**
     * Invokes the ExportApi operation.
     *
     * @param exportApiRequest
     * @return Result of the ExportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ExportApi
     */
    default ExportApiResponse exportApi(ExportApiRequest exportApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ExportApi operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportApiRequest.Builder} avoiding the need to
     * create one manually via {@link ExportApiRequest#builder()}
     * </p>
     *
     * @param exportApiRequest
     *        A {@link Consumer} that will call methods on {@link ExportApiRequest.Builder} to create a request.
     * @return Result of the ExportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ExportApi
     */
    default ExportApiResponse exportApi(Consumer<ExportApiRequest.Builder> exportApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return exportApi(ExportApiRequest.builder().applyMutation(exportApiRequest).build());
    }

    /**
     * <p>
     * Gets an Api resource.
     * </p>
     *
     * @param getApiRequest
     * @return Result of the GetApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApi
     */
    default GetApiResponse getApi(GetApiRequest getApiRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiRequest.Builder} avoiding the need to create
     * one manually via {@link GetApiRequest#builder()}
     * </p>
     *
     * @param getApiRequest
     *        A {@link Consumer} that will call methods on {@link GetApiRequest.Builder} to create a request.
     * @return Result of the GetApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApi
     */
    default GetApiResponse getApi(Consumer<GetApiRequest.Builder> getApiRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getApi(GetApiRequest.builder().applyMutation(getApiRequest).build());
    }

    /**
     * <p>
     * Gets an API mapping.
     * </p>
     *
     * @param getApiMappingRequest
     * @return Result of the GetApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApiMapping
     */
    default GetApiMappingResponse getApiMapping(GetApiMappingRequest getApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiMappingRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiMappingRequest#builder()}
     * </p>
     *
     * @param getApiMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetApiMappingRequest.Builder} to create a request.
     * @return Result of the GetApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApiMapping
     */
    default GetApiMappingResponse getApiMapping(Consumer<GetApiMappingRequest.Builder> getApiMappingRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getApiMapping(GetApiMappingRequest.builder().applyMutation(getApiMappingRequest).build());
    }

    /**
     * <p>
     * Gets API mappings.
     * </p>
     *
     * @param getApiMappingsRequest
     * @return Result of the GetApiMappings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApiMappings
     */
    default GetApiMappingsResponse getApiMappings(GetApiMappingsRequest getApiMappingsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets API mappings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiMappingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiMappingsRequest#builder()}
     * </p>
     *
     * @param getApiMappingsRequest
     *        A {@link Consumer} that will call methods on {@link GetApiMappingsRequest.Builder} to create a request.
     * @return Result of the GetApiMappings operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApiMappings
     */
    default GetApiMappingsResponse getApiMappings(Consumer<GetApiMappingsRequest.Builder> getApiMappingsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getApiMappings(GetApiMappingsRequest.builder().applyMutation(getApiMappingsRequest).build());
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     *
     * @return Result of the GetApis operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApis
     * @see #getApis(GetApisRequest)
     */
    default GetApisResponse getApis() throws NotFoundException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getApis(GetApisRequest.builder().build());
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     *
     * @param getApisRequest
     * @return Result of the GetApis operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApis
     */
    default GetApisResponse getApis(GetApisRequest getApisRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApisRequest.Builder} avoiding the need to create
     * one manually via {@link GetApisRequest#builder()}
     * </p>
     *
     * @param getApisRequest
     *        A {@link Consumer} that will call methods on {@link GetApisRequest.Builder} to create a request.
     * @return Result of the GetApis operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetApis
     */
    default GetApisResponse getApis(Consumer<GetApisRequest.Builder> getApisRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getApis(GetApisRequest.builder().applyMutation(getApisRequest).build());
    }

    /**
     * <p>
     * Gets an Authorizer.
     * </p>
     *
     * @param getAuthorizerRequest
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetAuthorizer
     */
    default GetAuthorizerResponse getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizerRequest#builder()}
     * </p>
     *
     * @param getAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizerRequest.Builder} to create a request.
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetAuthorizer
     */
    default GetAuthorizerResponse getAuthorizer(Consumer<GetAuthorizerRequest.Builder> getAuthorizerRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getAuthorizer(GetAuthorizerRequest.builder().applyMutation(getAuthorizerRequest).build());
    }

    /**
     * <p>
     * Gets the Authorizers for an API.
     * </p>
     *
     * @param getAuthorizersRequest
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetAuthorizers
     */
    default GetAuthorizersResponse getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Authorizers for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizersRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizersRequest#builder()}
     * </p>
     *
     * @param getAuthorizersRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizersRequest.Builder} to create a request.
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetAuthorizers
     */
    default GetAuthorizersResponse getAuthorizers(Consumer<GetAuthorizersRequest.Builder> getAuthorizersRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getAuthorizers(GetAuthorizersRequest.builder().applyMutation(getAuthorizersRequest).build());
    }

    /**
     * <p>
     * Gets a Deployment.
     * </p>
     *
     * @param getDeploymentRequest
     * @return Result of the GetDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDeployment
     */
    default GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentRequest.Builder} to create a request.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDeployment
     */
    default GetDeploymentResponse getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets the Deployments for an API.
     * </p>
     *
     * @param getDeploymentsRequest
     * @return Result of the GetDeployments operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDeployments
     */
    default GetDeploymentsResponse getDeployments(GetDeploymentsRequest getDeploymentsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Deployments for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentsRequest#builder()}
     * </p>
     *
     * @param getDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentsRequest.Builder} to create a request.
     * @return Result of the GetDeployments operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDeployments
     */
    default GetDeploymentsResponse getDeployments(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getDeployments(GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets a domain name.
     * </p>
     *
     * @param getDomainNameRequest
     * @return Result of the GetDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainName
     */
    default GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNameRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNameRequest#builder()}
     * </p>
     *
     * @param getDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainNameRequest.Builder} to create a request.
     * @return Result of the GetDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainName
     */
    default GetDomainNameResponse getDomainName(Consumer<GetDomainNameRequest.Builder> getDomainNameRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getDomainName(GetDomainNameRequest.builder().applyMutation(getDomainNameRequest).build());
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     *
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainNames
     * @see #getDomainNames(GetDomainNamesRequest)
     */
    default GetDomainNamesResponse getDomainNames() throws NotFoundException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getDomainNames(GetDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     *
     * @param getDomainNamesRequest
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainNames
     */
    default GetDomainNamesResponse getDomainNames(GetDomainNamesRequest getDomainNamesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNamesRequest#builder()}
     * </p>
     *
     * @param getDomainNamesRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainNamesRequest.Builder} to create a request.
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetDomainNames
     */
    default GetDomainNamesResponse getDomainNames(Consumer<GetDomainNamesRequest.Builder> getDomainNamesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getDomainNames(GetDomainNamesRequest.builder().applyMutation(getDomainNamesRequest).build());
    }

    /**
     * <p>
     * Gets an Integration.
     * </p>
     *
     * @param getIntegrationRequest
     * @return Result of the GetIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegration
     */
    default GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link GetIntegrationRequest#builder()}
     * </p>
     *
     * @param getIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationRequest.Builder} to create a request.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegration
     */
    default GetIntegrationResponse getIntegration(Consumer<GetIntegrationRequest.Builder> getIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getIntegration(GetIntegrationRequest.builder().applyMutation(getIntegrationRequest).build());
    }

    /**
     * <p>
     * Gets an IntegrationResponses.
     * </p>
     *
     * @param getIntegrationResponseRequest
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrationResponse
     */
    default GetIntegrationResponseResponse getIntegrationResponse(GetIntegrationResponseRequest getIntegrationResponseRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResponseRequest.Builder} avoiding the
     * need to create one manually via {@link GetIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationResponseRequest.Builder} to create a
     *        request.
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrationResponse
     */
    default GetIntegrationResponseResponse getIntegrationResponse(
            Consumer<GetIntegrationResponseRequest.Builder> getIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getIntegrationResponse(GetIntegrationResponseRequest.builder().applyMutation(getIntegrationResponseRequest)
                .build());
    }

    /**
     * <p>
     * Gets the IntegrationResponses for an Integration.
     * </p>
     *
     * @param getIntegrationResponsesRequest
     * @return Result of the GetIntegrationResponses operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrationResponses
     */
    default GetIntegrationResponsesResponse getIntegrationResponses(GetIntegrationResponsesRequest getIntegrationResponsesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IntegrationResponses for an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResponsesRequest.Builder} avoiding
     * the need to create one manually via {@link GetIntegrationResponsesRequest#builder()}
     * </p>
     *
     * @param getIntegrationResponsesRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationResponsesRequest.Builder} to create a
     *        request.
     * @return Result of the GetIntegrationResponses operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrationResponses
     */
    default GetIntegrationResponsesResponse getIntegrationResponses(
            Consumer<GetIntegrationResponsesRequest.Builder> getIntegrationResponsesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getIntegrationResponses(GetIntegrationResponsesRequest.builder().applyMutation(getIntegrationResponsesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the Integrations for an API.
     * </p>
     *
     * @param getIntegrationsRequest
     * @return Result of the GetIntegrations operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrations
     */
    default GetIntegrationsResponse getIntegrations(GetIntegrationsRequest getIntegrationsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Integrations for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationsRequest.Builder} avoiding the need
     * to create one manually via {@link GetIntegrationsRequest#builder()}
     * </p>
     *
     * @param getIntegrationsRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationsRequest.Builder} to create a request.
     * @return Result of the GetIntegrations operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetIntegrations
     */
    default GetIntegrationsResponse getIntegrations(Consumer<GetIntegrationsRequest.Builder> getIntegrationsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getIntegrations(GetIntegrationsRequest.builder().applyMutation(getIntegrationsRequest).build());
    }

    /**
     * <p>
     * Gets a Model.
     * </p>
     *
     * @param getModelRequest
     * @return Result of the GetModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModel
     */
    default GetModelResponse getModel(GetModelRequest getModelRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelRequest#builder()}
     * </p>
     *
     * @param getModelRequest
     *        A {@link Consumer} that will call methods on {@link GetModelRequest.Builder} to create a request.
     * @return Result of the GetModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModel
     */
    default GetModelResponse getModel(Consumer<GetModelRequest.Builder> getModelRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getModel(GetModelRequest.builder().applyMutation(getModelRequest).build());
    }

    /**
     * <p>
     * Gets a model template.
     * </p>
     *
     * @param getModelTemplateRequest
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModelTemplate
     */
    default GetModelTemplateResponse getModelTemplate(GetModelTemplateRequest getModelTemplateRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a model template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelTemplateRequest#builder()}
     * </p>
     *
     * @param getModelTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetModelTemplateRequest.Builder} to create a request.
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModelTemplate
     */
    default GetModelTemplateResponse getModelTemplate(Consumer<GetModelTemplateRequest.Builder> getModelTemplateRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getModelTemplate(GetModelTemplateRequest.builder().applyMutation(getModelTemplateRequest).build());
    }

    /**
     * <p>
     * Gets the Models for an API.
     * </p>
     *
     * @param getModelsRequest
     * @return Result of the GetModels operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModels
     */
    default GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Models for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return Result of the GetModels operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetModels
     */
    default GetModelsResponse getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets a Route.
     * </p>
     *
     * @param getRouteRequest
     * @return Result of the GetRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRoute
     */
    default GetRouteResponse getRoute(GetRouteRequest getRouteRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteRequest.Builder} avoiding the need to
     * create one manually via {@link GetRouteRequest#builder()}
     * </p>
     *
     * @param getRouteRequest
     *        A {@link Consumer} that will call methods on {@link GetRouteRequest.Builder} to create a request.
     * @return Result of the GetRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRoute
     */
    default GetRouteResponse getRoute(Consumer<GetRouteRequest.Builder> getRouteRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getRoute(GetRouteRequest.builder().applyMutation(getRouteRequest).build());
    }

    /**
     * <p>
     * Gets a RouteResponse.
     * </p>
     *
     * @param getRouteResponseRequest
     * @return Result of the GetRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRouteResponse
     */
    default GetRouteResponseResponse getRouteResponse(GetRouteResponseRequest getRouteResponseRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a RouteResponse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteResponseRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouteResponseRequest#builder()}
     * </p>
     *
     * @param getRouteResponseRequest
     *        A {@link Consumer} that will call methods on {@link GetRouteResponseRequest.Builder} to create a request.
     * @return Result of the GetRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRouteResponse
     */
    default GetRouteResponseResponse getRouteResponse(Consumer<GetRouteResponseRequest.Builder> getRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getRouteResponse(GetRouteResponseRequest.builder().applyMutation(getRouteResponseRequest).build());
    }

    /**
     * <p>
     * Gets the RouteResponses for a Route.
     * </p>
     *
     * @param getRouteResponsesRequest
     * @return Result of the GetRouteResponses operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRouteResponses
     */
    default GetRouteResponsesResponse getRouteResponses(GetRouteResponsesRequest getRouteResponsesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the RouteResponses for a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteResponsesRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouteResponsesRequest#builder()}
     * </p>
     *
     * @param getRouteResponsesRequest
     *        A {@link Consumer} that will call methods on {@link GetRouteResponsesRequest.Builder} to create a request.
     * @return Result of the GetRouteResponses operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRouteResponses
     */
    default GetRouteResponsesResponse getRouteResponses(Consumer<GetRouteResponsesRequest.Builder> getRouteResponsesRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getRouteResponses(GetRouteResponsesRequest.builder().applyMutation(getRouteResponsesRequest).build());
    }

    /**
     * <p>
     * Gets the Routes for an API.
     * </p>
     *
     * @param getRoutesRequest
     * @return Result of the GetRoutes operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRoutes
     */
    default GetRoutesResponse getRoutes(GetRoutesRequest getRoutesRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Routes for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRoutesRequest#builder()}
     * </p>
     *
     * @param getRoutesRequest
     *        A {@link Consumer} that will call methods on {@link GetRoutesRequest.Builder} to create a request.
     * @return Result of the GetRoutes operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetRoutes
     */
    default GetRoutesResponse getRoutes(Consumer<GetRoutesRequest.Builder> getRoutesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getRoutes(GetRoutesRequest.builder().applyMutation(getRoutesRequest).build());
    }

    /**
     * <p>
     * Gets a Stage.
     * </p>
     *
     * @param getStageRequest
     * @return Result of the GetStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetStage
     */
    default GetStageResponse getStage(GetStageRequest getStageRequest) throws NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on {@link GetStageRequest.Builder} to create a request.
     * @return Result of the GetStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetStage
     */
    default GetStageResponse getStage(Consumer<GetStageRequest.Builder> getStageRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets the Stages for an API.
     * </p>
     *
     * @param getStagesRequest
     * @return Result of the GetStages operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetStages
     */
    default GetStagesResponse getStages(GetStagesRequest getStagesRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Stages for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStagesRequest.Builder} avoiding the need to
     * create one manually via {@link GetStagesRequest#builder()}
     * </p>
     *
     * @param getStagesRequest
     *        A {@link Consumer} that will call methods on {@link GetStagesRequest.Builder} to create a request.
     * @return Result of the GetStages operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetStages
     */
    default GetStagesResponse getStages(Consumer<GetStagesRequest.Builder> getStagesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getStages(GetStagesRequest.builder().applyMutation(getStagesRequest).build());
    }

    /**
     * <p>
     * Gets a collection of Tag resources.
     * </p>
     *
     * @param getTagsRequest
     * @return Result of the GetTags operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetTags
     */
    default GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of Tag resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on {@link GetTagsRequest.Builder} to create a request.
     * @return Result of the GetTags operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetTags
     */
    default GetTagsResponse getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Gets a VPC link.
     * </p>
     *
     * @param getVpcLinkRequest
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetVpcLink
     */
    default GetVpcLinkResponse getVpcLink(GetVpcLinkRequest getVpcLinkRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinkRequest#builder()}
     * </p>
     *
     * @param getVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcLinkRequest.Builder} to create a request.
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetVpcLink
     */
    default GetVpcLinkResponse getVpcLink(Consumer<GetVpcLinkRequest.Builder> getVpcLinkRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getVpcLink(GetVpcLinkRequest.builder().applyMutation(getVpcLinkRequest).build());
    }

    /**
     * <p>
     * Gets a collection of VPC links.
     * </p>
     *
     * @param getVpcLinksRequest
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetVpcLinks
     */
    default GetVpcLinksResponse getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of VPC links.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinksRequest#builder()}
     * </p>
     *
     * @param getVpcLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcLinksRequest.Builder} to create a request.
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.GetVpcLinks
     */
    default GetVpcLinksResponse getVpcLinks(Consumer<GetVpcLinksRequest.Builder> getVpcLinksRequest) throws BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return getVpcLinks(GetVpcLinksRequest.builder().applyMutation(getVpcLinksRequest).build());
    }

    /**
     * <p>
     * Imports an API.
     * </p>
     *
     * @param importApiRequest
     * @return Result of the ImportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ImportApi
     */
    default ImportApiResponse importApi(ImportApiRequest importApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportApiRequest.Builder} avoiding the need to
     * create one manually via {@link ImportApiRequest#builder()}
     * </p>
     *
     * @param importApiRequest
     *        A {@link Consumer} that will call methods on {@link ImportApiRequest.Builder} to create a request.
     * @return Result of the ImportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ImportApi
     */
    default ImportApiResponse importApi(Consumer<ImportApiRequest.Builder> importApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return importApi(ImportApiRequest.builder().applyMutation(importApiRequest).build());
    }

    /**
     * <p>
     * Puts an Api resource.
     * </p>
     *
     * @param reimportApiRequest
     * @return Result of the ReimportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ReimportApi
     */
    default ReimportApiResponse reimportApi(ReimportApiRequest reimportApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReimportApiRequest.Builder} avoiding the need to
     * create one manually via {@link ReimportApiRequest#builder()}
     * </p>
     *
     * @param reimportApiRequest
     *        A {@link Consumer} that will call methods on {@link ReimportApiRequest.Builder} to create a request.
     * @return Result of the ReimportApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ReimportApi
     */
    default ReimportApiResponse reimportApi(Consumer<ReimportApiRequest.Builder> reimportApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return reimportApi(ReimportApiRequest.builder().applyMutation(reimportApiRequest).build());
    }

    /**
     * <p>
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     * </p>
     *
     * @param resetAuthorizersCacheRequest
     * @return Result of the ResetAuthorizersCache operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ResetAuthorizersCache
     */
    default ResetAuthorizersCacheResponse resetAuthorizersCache(ResetAuthorizersCacheRequest resetAuthorizersCacheRequest)
            throws NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetAuthorizersCacheRequest.Builder} avoiding the
     * need to create one manually via {@link ResetAuthorizersCacheRequest#builder()}
     * </p>
     *
     * @param resetAuthorizersCacheRequest
     *        A {@link Consumer} that will call methods on {@link ResetAuthorizersCacheRequest.Builder} to create a
     *        request.
     * @return Result of the ResetAuthorizersCache operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.ResetAuthorizersCache
     */
    default ResetAuthorizersCacheResponse resetAuthorizersCache(
            Consumer<ResetAuthorizersCacheRequest.Builder> resetAuthorizersCacheRequest) throws NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        return resetAuthorizersCache(ResetAuthorizersCacheRequest.builder().applyMutation(resetAuthorizersCacheRequest).build());
    }

    /**
     * <p>
     * Creates a new Tag resource to represent a tag.
     * </p>
     *
     * @param tagResourceRequest
     *        Creates a new Tag resource to represent a tag.
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.TagResource
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Tag resource to represent a tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     *        Creates a new Tag resource to represent a tag.
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.TagResource
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes a Tag.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UntagResource
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UntagResource
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Api resource.
     * </p>
     *
     * @param updateApiRequest
     *        Updates an Api.
     * @return Result of the UpdateApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateApi
     */
    default UpdateApiResponse updateApi(UpdateApiRequest updateApiRequest) throws NotFoundException, TooManyRequestsException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiRequest#builder()}
     * </p>
     *
     * @param updateApiRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApiRequest.Builder} to create a request. Updates
     *        an Api.
     * @return Result of the UpdateApi operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateApi
     */
    default UpdateApiResponse updateApi(Consumer<UpdateApiRequest.Builder> updateApiRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateApi(UpdateApiRequest.builder().applyMutation(updateApiRequest).build());
    }

    /**
     * <p>
     * The API mapping.
     * </p>
     *
     * @param updateApiMappingRequest
     *        Updates an ApiMapping.
     * @return Result of the UpdateApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateApiMapping
     */
    default UpdateApiMappingResponse updateApiMapping(UpdateApiMappingRequest updateApiMappingRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiMappingRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApiMappingRequest#builder()}
     * </p>
     *
     * @param updateApiMappingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApiMappingRequest.Builder} to create a request.
     *        Updates an ApiMapping.
     * @return Result of the UpdateApiMapping operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateApiMapping
     */
    default UpdateApiMappingResponse updateApiMapping(Consumer<UpdateApiMappingRequest.Builder> updateApiMappingRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return updateApiMapping(UpdateApiMappingRequest.builder().applyMutation(updateApiMappingRequest).build());
    }

    /**
     * <p>
     * Updates an Authorizer.
     * </p>
     *
     * @param updateAuthorizerRequest
     *        Updates an Authorizer.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateAuthorizer
     */
    default UpdateAuthorizerResponse updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAuthorizerRequest#builder()}
     * </p>
     *
     * @param updateAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAuthorizerRequest.Builder} to create a request.
     *        Updates an Authorizer.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateAuthorizer
     */
    default UpdateAuthorizerResponse updateAuthorizer(Consumer<UpdateAuthorizerRequest.Builder> updateAuthorizerRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return updateAuthorizer(UpdateAuthorizerRequest.builder().applyMutation(updateAuthorizerRequest).build());
    }

    /**
     * <p>
     * Updates a Deployment.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Updates a Deployment.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateDeployment
     */
    default UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest updateDeploymentRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDeploymentRequest#builder()}
     * </p>
     *
     * @param updateDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeploymentRequest.Builder} to create a request.
     *        Updates a Deployment.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateDeployment
     */
    default UpdateDeploymentResponse updateDeployment(Consumer<UpdateDeploymentRequest.Builder> updateDeploymentRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return updateDeployment(UpdateDeploymentRequest.builder().applyMutation(updateDeploymentRequest).build());
    }

    /**
     * <p>
     * Updates a domain name.
     * </p>
     *
     * @param updateDomainNameRequest
     *        Updates a DomainName.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateDomainName
     */
    default UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainNameRequest#builder()}
     * </p>
     *
     * @param updateDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainNameRequest.Builder} to create a request.
     *        Updates a DomainName.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateDomainName
     */
    default UpdateDomainNameResponse updateDomainName(Consumer<UpdateDomainNameRequest.Builder> updateDomainNameRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return updateDomainName(UpdateDomainNameRequest.builder().applyMutation(updateDomainNameRequest).build());
    }

    /**
     * <p>
     * Updates an Integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Updates an Integration.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateIntegration
     */
    default UpdateIntegrationResponse updateIntegration(UpdateIntegrationRequest updateIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateIntegrationRequest#builder()}
     * </p>
     *
     * @param updateIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntegrationRequest.Builder} to create a request.
     *        Updates an Integration.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateIntegration
     */
    default UpdateIntegrationResponse updateIntegration(Consumer<UpdateIntegrationRequest.Builder> updateIntegrationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        return updateIntegration(UpdateIntegrationRequest.builder().applyMutation(updateIntegrationRequest).build());
    }

    /**
     * <p>
     * Updates an IntegrationResponses.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Updates an IntegrationResponses.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateIntegrationResponse
     */
    default UpdateIntegrationResponseResponse updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntegrationResponseRequest.Builder} to create a
     *        request. Updates an IntegrationResponses.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateIntegrationResponse
     */
    default UpdateIntegrationResponseResponse updateIntegrationResponse(
            Consumer<UpdateIntegrationResponseRequest.Builder> updateIntegrationResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateIntegrationResponse(UpdateIntegrationResponseRequest.builder()
                .applyMutation(updateIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Updates a Model.
     * </p>
     *
     * @param updateModelRequest
     *        Updates a Model.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateModel
     */
    default UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelRequest.Builder} to create a request.
     *        Updates a Model.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateModel
     */
    default UpdateModelResponse updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a Route.
     * </p>
     *
     * @param updateRouteRequest
     *        Updates a Route.
     * @return Result of the UpdateRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateRoute
     */
    default UpdateRouteResponse updateRoute(UpdateRouteRequest updateRouteRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRouteRequest#builder()}
     * </p>
     *
     * @param updateRouteRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRouteRequest.Builder} to create a request.
     *        Updates a Route.
     * @return Result of the UpdateRoute operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateRoute
     */
    default UpdateRouteResponse updateRoute(Consumer<UpdateRouteRequest.Builder> updateRouteRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateRoute(UpdateRouteRequest.builder().applyMutation(updateRouteRequest).build());
    }

    /**
     * <p>
     * Updates a RouteResponse.
     * </p>
     *
     * @param updateRouteResponseRequest
     *        Updates a RouteResponse.
     * @return Result of the UpdateRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateRouteResponse
     */
    default UpdateRouteResponseResponse updateRouteResponse(UpdateRouteResponseRequest updateRouteResponseRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a RouteResponse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRouteResponseRequest#builder()}
     * </p>
     *
     * @param updateRouteResponseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRouteResponseRequest.Builder} to create a
     *        request. Updates a RouteResponse.
     * @return Result of the UpdateRouteResponse operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateRouteResponse
     */
    default UpdateRouteResponseResponse updateRouteResponse(
            Consumer<UpdateRouteResponseRequest.Builder> updateRouteResponseRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateRouteResponse(UpdateRouteResponseRequest.builder().applyMutation(updateRouteResponseRequest).build());
    }

    /**
     * <p>
     * Updates a Stage.
     * </p>
     *
     * @param updateStageRequest
     *        Updates a Stage.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateStage
     */
    default UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStageRequest.Builder} to create a request.
     *        Updates a Stage.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws ConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateStage
     */
    default UpdateStageResponse updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    /**
     * <p>
     * Updates a VPC link.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates a VPC link.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateVpcLink
     */
    default UpdateVpcLinkResponse updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, ApiGatewayV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVpcLinkRequest#builder()}
     * </p>
     *
     * @param updateVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVpcLinkRequest.Builder} to create a request.
     *        Updates a VPC link.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found.
     * @throws TooManyRequestsException
     *         The client is sending more than the allowed number of requests per unit of time.
     * @throws BadRequestException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayV2Client.UpdateVpcLink
     */
    default UpdateVpcLinkResponse updateVpcLink(Consumer<UpdateVpcLinkRequest.Builder> updateVpcLinkRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayV2Exception {
        return updateVpcLink(UpdateVpcLinkRequest.builder().applyMutation(updateVpcLinkRequest).build());
    }

    /**
     * Create a {@link ApiGatewayV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApiGatewayV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayV2Client}.
     */
    static ApiGatewayV2ClientBuilder builder() {
        return new DefaultApiGatewayV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    ApiGatewayV2ServiceClientConfiguration serviceClientConfiguration();
}
