/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetApisRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetApisResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetModelsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetRoutesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetStagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetStagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetTagsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetTagsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ImportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ReimportApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigatewayv2.model.TagResourceRequest;
import software.amazon.awssdk.services.apigatewayv2.model.TagResourceResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateApiResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkResponse;

/**
 * Service client for accessing AmazonApiGatewayV2 asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon API Gateway V2
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApiGatewayV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "apigateway";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "apigateway";

    /**
     * <p>
     * Creates an Api resource.
     * </p>
     *
     * @param createApiRequest
     *        Creates a new Api resource to represent an API.
     * @return A Java Future containing the result of the CreateApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateApi
     */
    default CompletableFuture<CreateApiResponse> createApi(CreateApiRequest createApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiRequest#builder()}
     * </p>
     *
     * @param createApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateApiRequest.Builder} to create a request.
     *        Creates a new Api resource to represent an API.
     * @return A Java Future containing the result of the CreateApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateApi
     */
    default CompletableFuture<CreateApiResponse> createApi(Consumer<CreateApiRequest.Builder> createApiRequest) {
        return createApi(CreateApiRequest.builder().applyMutation(createApiRequest).build());
    }

    /**
     * <p>
     * Creates an API mapping.
     * </p>
     *
     * @param createApiMappingRequest
     *        Creates a new ApiMapping resource to represent an API mapping.
     * @return A Java Future containing the result of the CreateApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateApiMapping
     */
    default CompletableFuture<CreateApiMappingResponse> createApiMapping(CreateApiMappingRequest createApiMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiMappingRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApiMappingRequest#builder()}
     * </p>
     *
     * @param createApiMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest.Builder} to create a
     *        request. Creates a new ApiMapping resource to represent an API mapping.
     * @return A Java Future containing the result of the CreateApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateApiMapping
     */
    default CompletableFuture<CreateApiMappingResponse> createApiMapping(
            Consumer<CreateApiMappingRequest.Builder> createApiMappingRequest) {
        return createApiMapping(CreateApiMappingRequest.builder().applyMutation(createApiMappingRequest).build());
    }

    /**
     * <p>
     * Creates an Authorizer for an API.
     * </p>
     *
     * @param createAuthorizerRequest
     *        Creates a new Authorizer resource to represent an authorizer.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateAuthorizer
     */
    default CompletableFuture<CreateAuthorizerResponse> createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Authorizer for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAuthorizerRequest#builder()}
     * </p>
     *
     * @param createAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest.Builder} to create a
     *        request. Creates a new Authorizer resource to represent an authorizer.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateAuthorizer
     */
    default CompletableFuture<CreateAuthorizerResponse> createAuthorizer(
            Consumer<CreateAuthorizerRequest.Builder> createAuthorizerRequest) {
        return createAuthorizer(CreateAuthorizerRequest.builder().applyMutation(createAuthorizerRequest).build());
    }

    /**
     * <p>
     * Creates a Deployment for an API.
     * </p>
     *
     * @param createDeploymentRequest
     *        Creates a new Deployment resource to represent a deployment.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateDeployment
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Deployment for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest.Builder} to create a
     *        request. Creates a new Deployment resource to represent a deployment.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateDeployment
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(
            Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        Creates a new DomainName resource to represent a domain name.
     * @return A Java Future containing the result of the CreateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>AccessDeniedException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateDomainName
     */
    default CompletableFuture<CreateDomainNameResponse> createDomainName(CreateDomainNameRequest createDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainNameRequest#builder()}
     * </p>
     *
     * @param createDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest.Builder} to create a
     *        request. Creates a new DomainName resource to represent a domain name.
     * @return A Java Future containing the result of the CreateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>AccessDeniedException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateDomainName
     */
    default CompletableFuture<CreateDomainNameResponse> createDomainName(
            Consumer<CreateDomainNameRequest.Builder> createDomainNameRequest) {
        return createDomainName(CreateDomainNameRequest.builder().applyMutation(createDomainNameRequest).build());
    }

    /**
     * <p>
     * Creates an Integration.
     * </p>
     *
     * @param createIntegrationRequest
     *        Creates a new Integration resource to represent an integration.
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateIntegration
     */
    default CompletableFuture<CreateIntegrationResponse> createIntegration(CreateIntegrationRequest createIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIntegrationRequest#builder()}
     * </p>
     *
     * @param createIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationRequest.Builder} to create a
     *        request. Creates a new Integration resource to represent an integration.
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateIntegration
     */
    default CompletableFuture<CreateIntegrationResponse> createIntegration(
            Consumer<CreateIntegrationRequest.Builder> createIntegrationRequest) {
        return createIntegration(CreateIntegrationRequest.builder().applyMutation(createIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates an IntegrationResponses.
     * </p>
     *
     * @param createIntegrationResponseRequest
     *        Creates a new IntegrationResponse resource to represent an integration response.
     * @return A Java Future containing the result of the CreateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateIntegrationResponse
     */
    default CompletableFuture<CreateIntegrationResponseResponse> createIntegrationResponse(
            CreateIntegrationResponseRequest createIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param createIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest.Builder} to
     *        create a request. Creates a new IntegrationResponse resource to represent an integration response.
     * @return A Java Future containing the result of the CreateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateIntegrationResponse
     */
    default CompletableFuture<CreateIntegrationResponseResponse> createIntegrationResponse(
            Consumer<CreateIntegrationResponseRequest.Builder> createIntegrationResponseRequest) {
        return createIntegrationResponse(CreateIntegrationResponseRequest.builder()
                .applyMutation(createIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Creates a Model for an API.
     * </p>
     *
     * @param createModelRequest
     *        Creates a new Model.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateModel
     */
    default CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Model for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest.Builder} to create a request.
     *        Creates a new Model.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateModel
     */
    default CompletableFuture<CreateModelResponse> createModel(Consumer<CreateModelRequest.Builder> createModelRequest) {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a Route for an API.
     * </p>
     *
     * @param createRouteRequest
     *        Creates a new Route resource to represent a route.
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateRoute
     */
    default CompletableFuture<CreateRouteResponse> createRoute(CreateRouteRequest createRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Route for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRouteRequest#builder()}
     * </p>
     *
     * @param createRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateRouteRequest.Builder} to create a request.
     *        Creates a new Route resource to represent a route.
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateRoute
     */
    default CompletableFuture<CreateRouteResponse> createRoute(Consumer<CreateRouteRequest.Builder> createRouteRequest) {
        return createRoute(CreateRouteRequest.builder().applyMutation(createRouteRequest).build());
    }

    /**
     * <p>
     * Creates a RouteResponse for a Route.
     * </p>
     *
     * @param createRouteResponseRequest
     *        Creates a new RouteResponse resource to represent a route response.
     * @return A Java Future containing the result of the CreateRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateRouteResponse
     */
    default CompletableFuture<CreateRouteResponseResponse> createRouteResponse(
            CreateRouteResponseRequest createRouteResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a RouteResponse for a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteResponseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRouteResponseRequest#builder()}
     * </p>
     *
     * @param createRouteResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest.Builder} to create a
     *        request. Creates a new RouteResponse resource to represent a route response.
     * @return A Java Future containing the result of the CreateRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateRouteResponse
     */
    default CompletableFuture<CreateRouteResponseResponse> createRouteResponse(
            Consumer<CreateRouteResponseRequest.Builder> createRouteResponseRequest) {
        return createRouteResponse(CreateRouteResponseRequest.builder().applyMutation(createRouteResponseRequest).build());
    }

    /**
     * <p>
     * Creates a Stage for an API.
     * </p>
     *
     * @param createStageRequest
     *        Creates a new Stage resource to represent a stage.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateStage
     */
    default CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Stage for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateStageRequest.Builder} to create a request.
     *        Creates a new Stage resource to represent a stage.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateStage
     */
    default CompletableFuture<CreateStageResponse> createStage(Consumer<CreateStageRequest.Builder> createStageRequest) {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Creates a VPC link.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link
     * @return A Java Future containing the result of the CreateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateVpcLink
     */
    default CompletableFuture<CreateVpcLinkResponse> createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVpcLinkRequest#builder()}
     * </p>
     *
     * @param createVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest.Builder} to create a
     *        request. Creates a VPC link
     * @return A Java Future containing the result of the CreateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.CreateVpcLink
     */
    default CompletableFuture<CreateVpcLinkResponse> createVpcLink(Consumer<CreateVpcLinkRequest.Builder> createVpcLinkRequest) {
        return createVpcLink(CreateVpcLinkRequest.builder().applyMutation(createVpcLinkRequest).build());
    }

    /**
     * <p>
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     * </p>
     *
     * @param deleteAccessLogSettingsRequest
     * @return A Java Future containing the result of the DeleteAccessLogSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteAccessLogSettings
     */
    default CompletableFuture<DeleteAccessLogSettingsResponse> deleteAccessLogSettings(
            DeleteAccessLogSettingsRequest deleteAccessLogSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessLogSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccessLogSettingsRequest#builder()}
     * </p>
     *
     * @param deleteAccessLogSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteAccessLogSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccessLogSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteAccessLogSettings
     */
    default CompletableFuture<DeleteAccessLogSettingsResponse> deleteAccessLogSettings(
            Consumer<DeleteAccessLogSettingsRequest.Builder> deleteAccessLogSettingsRequest) {
        return deleteAccessLogSettings(DeleteAccessLogSettingsRequest.builder().applyMutation(deleteAccessLogSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Api resource.
     * </p>
     *
     * @param deleteApiRequest
     * @return A Java Future containing the result of the DeleteApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteApi
     */
    default CompletableFuture<DeleteApiResponse> deleteApi(DeleteApiRequest deleteApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiRequest#builder()}
     * </p>
     *
     * @param deleteApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteApi
     */
    default CompletableFuture<DeleteApiResponse> deleteApi(Consumer<DeleteApiRequest.Builder> deleteApiRequest) {
        return deleteApi(DeleteApiRequest.builder().applyMutation(deleteApiRequest).build());
    }

    /**
     * <p>
     * Deletes an API mapping.
     * </p>
     *
     * @param deleteApiMappingRequest
     * @return A Java Future containing the result of the DeleteApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteApiMapping
     */
    default CompletableFuture<DeleteApiMappingResponse> deleteApiMapping(DeleteApiMappingRequest deleteApiMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiMappingRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApiMappingRequest#builder()}
     * </p>
     *
     * @param deleteApiMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteApiMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteApiMapping
     */
    default CompletableFuture<DeleteApiMappingResponse> deleteApiMapping(
            Consumer<DeleteApiMappingRequest.Builder> deleteApiMappingRequest) {
        return deleteApiMapping(DeleteApiMappingRequest.builder().applyMutation(deleteApiMappingRequest).build());
    }

    /**
     * <p>
     * Deletes an Authorizer.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteAuthorizer
     */
    default CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthorizerRequest#builder()}
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteAuthorizer
     */
    default CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(
            Consumer<DeleteAuthorizerRequest.Builder> deleteAuthorizerRequest) {
        return deleteAuthorizer(DeleteAuthorizerRequest.builder().applyMutation(deleteAuthorizerRequest).build());
    }

    /**
     * <p>
     * Deletes a CORS configuration.
     * </p>
     *
     * @param deleteCorsConfigurationRequest
     * @return A Java Future containing the result of the DeleteCorsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteCorsConfiguration
     */
    default CompletableFuture<DeleteCorsConfigurationResponse> deleteCorsConfiguration(
            DeleteCorsConfigurationRequest deleteCorsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CORS configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCorsConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCorsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteCorsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteCorsConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCorsConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteCorsConfiguration
     */
    default CompletableFuture<DeleteCorsConfigurationResponse> deleteCorsConfiguration(
            Consumer<DeleteCorsConfigurationRequest.Builder> deleteCorsConfigurationRequest) {
        return deleteCorsConfiguration(DeleteCorsConfigurationRequest.builder().applyMutation(deleteCorsConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Deployment.
     * </p>
     *
     * @param deleteDeploymentRequest
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteDeployment
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteDeployment
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(
            Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest) {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a domain name.
     * </p>
     *
     * @param deleteDomainNameRequest
     * @return A Java Future containing the result of the DeleteDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteDomainName
     */
    default CompletableFuture<DeleteDomainNameResponse> deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainNameRequest#builder()}
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteDomainNameRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteDomainName
     */
    default CompletableFuture<DeleteDomainNameResponse> deleteDomainName(
            Consumer<DeleteDomainNameRequest.Builder> deleteDomainNameRequest) {
        return deleteDomainName(DeleteDomainNameRequest.builder().applyMutation(deleteDomainNameRequest).build());
    }

    /**
     * <p>
     * Deletes an Integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteIntegration
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteIntegration
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(
            Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest) {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes an IntegrationResponses.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     * @return A Java Future containing the result of the DeleteIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteIntegrationResponse
     */
    default CompletableFuture<DeleteIntegrationResponseResponse> deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteIntegrationResponseRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteIntegrationResponse
     */
    default CompletableFuture<DeleteIntegrationResponseResponse> deleteIntegrationResponse(
            Consumer<DeleteIntegrationResponseRequest.Builder> deleteIntegrationResponseRequest) {
        return deleteIntegrationResponse(DeleteIntegrationResponseRequest.builder()
                .applyMutation(deleteIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Deletes a Model.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteModel
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteModel
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a Route.
     * </p>
     *
     * @param deleteRouteRequest
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRoute
     */
    default CompletableFuture<DeleteRouteResponse> deleteRoute(DeleteRouteRequest deleteRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRouteRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRoute
     */
    default CompletableFuture<DeleteRouteResponse> deleteRoute(Consumer<DeleteRouteRequest.Builder> deleteRouteRequest) {
        return deleteRoute(DeleteRouteRequest.builder().applyMutation(deleteRouteRequest).build());
    }

    /**
     * <p>
     * Deletes a route request parameter. Supported only for WebSocket APIs.
     * </p>
     *
     * @param deleteRouteRequestParameterRequest
     * @return A Java Future containing the result of the DeleteRouteRequestParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRouteRequestParameter
     */
    default CompletableFuture<DeleteRouteRequestParameterResponse> deleteRouteRequestParameter(
            DeleteRouteRequestParameterRequest deleteRouteRequestParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a route request parameter. Supported only for WebSocket APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequestParameterRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRouteRequestParameterRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequestParameterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRouteRequestParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRouteRequestParameter
     */
    default CompletableFuture<DeleteRouteRequestParameterResponse> deleteRouteRequestParameter(
            Consumer<DeleteRouteRequestParameterRequest.Builder> deleteRouteRequestParameterRequest) {
        return deleteRouteRequestParameter(DeleteRouteRequestParameterRequest.builder()
                .applyMutation(deleteRouteRequestParameterRequest).build());
    }

    /**
     * <p>
     * Deletes a RouteResponse.
     * </p>
     *
     * @param deleteRouteResponseRequest
     * @return A Java Future containing the result of the DeleteRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRouteResponse
     */
    default CompletableFuture<DeleteRouteResponseResponse> deleteRouteResponse(
            DeleteRouteResponseRequest deleteRouteResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a RouteResponse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouteResponseRequest#builder()}
     * </p>
     *
     * @param deleteRouteResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRouteResponse
     */
    default CompletableFuture<DeleteRouteResponseResponse> deleteRouteResponse(
            Consumer<DeleteRouteResponseRequest.Builder> deleteRouteResponseRequest) {
        return deleteRouteResponse(DeleteRouteResponseRequest.builder().applyMutation(deleteRouteResponseRequest).build());
    }

    /**
     * <p>
     * Deletes the RouteSettings for a stage.
     * </p>
     *
     * @param deleteRouteSettingsRequest
     * @return A Java Future containing the result of the DeleteRouteSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRouteSettings
     */
    default CompletableFuture<DeleteRouteSettingsResponse> deleteRouteSettings(
            DeleteRouteSettingsRequest deleteRouteSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the RouteSettings for a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouteSettingsRequest#builder()}
     * </p>
     *
     * @param deleteRouteSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRouteSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteRouteSettings
     */
    default CompletableFuture<DeleteRouteSettingsResponse> deleteRouteSettings(
            Consumer<DeleteRouteSettingsRequest.Builder> deleteRouteSettingsRequest) {
        return deleteRouteSettings(DeleteRouteSettingsRequest.builder().applyMutation(deleteRouteSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes a Stage.
     * </p>
     *
     * @param deleteStageRequest
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteStage
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteStage
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest) {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Deletes a VPC link.
     * </p>
     *
     * @param deleteVpcLinkRequest
     * @return A Java Future containing the result of the DeleteVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteVpcLink
     */
    default CompletableFuture<DeleteVpcLinkResponse> deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVpcLinkRequest#builder()}
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.DeleteVpcLinkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.DeleteVpcLink
     */
    default CompletableFuture<DeleteVpcLinkResponse> deleteVpcLink(Consumer<DeleteVpcLinkRequest.Builder> deleteVpcLinkRequest) {
        return deleteVpcLink(DeleteVpcLinkRequest.builder().applyMutation(deleteVpcLinkRequest).build());
    }

    /**
     * Invokes the ExportApi operation asynchronously.
     *
     * @param exportApiRequest
     * @return A Java Future containing the result of the ExportApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ExportApi
     */
    default CompletableFuture<ExportApiResponse> exportApi(ExportApiRequest exportApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ExportApi operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportApiRequest.Builder} avoiding the need to
     * create one manually via {@link ExportApiRequest#builder()}
     * </p>
     *
     * @param exportApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ExportApi
     */
    default CompletableFuture<ExportApiResponse> exportApi(Consumer<ExportApiRequest.Builder> exportApiRequest) {
        return exportApi(ExportApiRequest.builder().applyMutation(exportApiRequest).build());
    }

    /**
     * <p>
     * Gets an Api resource.
     * </p>
     *
     * @param getApiRequest
     * @return A Java Future containing the result of the GetApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApi
     */
    default CompletableFuture<GetApiResponse> getApi(GetApiRequest getApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiRequest.Builder} avoiding the need to create
     * one manually via {@link GetApiRequest#builder()}
     * </p>
     *
     * @param getApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApi
     */
    default CompletableFuture<GetApiResponse> getApi(Consumer<GetApiRequest.Builder> getApiRequest) {
        return getApi(GetApiRequest.builder().applyMutation(getApiRequest).build());
    }

    /**
     * <p>
     * Gets an API mapping.
     * </p>
     *
     * @param getApiMappingRequest
     * @return A Java Future containing the result of the GetApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApiMapping
     */
    default CompletableFuture<GetApiMappingResponse> getApiMapping(GetApiMappingRequest getApiMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiMappingRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiMappingRequest#builder()}
     * </p>
     *
     * @param getApiMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApiMapping
     */
    default CompletableFuture<GetApiMappingResponse> getApiMapping(Consumer<GetApiMappingRequest.Builder> getApiMappingRequest) {
        return getApiMapping(GetApiMappingRequest.builder().applyMutation(getApiMappingRequest).build());
    }

    /**
     * <p>
     * Gets API mappings.
     * </p>
     *
     * @param getApiMappingsRequest
     * @return A Java Future containing the result of the GetApiMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApiMappings
     */
    default CompletableFuture<GetApiMappingsResponse> getApiMappings(GetApiMappingsRequest getApiMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets API mappings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiMappingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiMappingsRequest#builder()}
     * </p>
     *
     * @param getApiMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApiMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApiMappings
     */
    default CompletableFuture<GetApiMappingsResponse> getApiMappings(Consumer<GetApiMappingsRequest.Builder> getApiMappingsRequest) {
        return getApiMappings(GetApiMappingsRequest.builder().applyMutation(getApiMappingsRequest).build());
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     *
     * @param getApisRequest
     * @return A Java Future containing the result of the GetApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApis
     */
    default CompletableFuture<GetApisResponse> getApis(GetApisRequest getApisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApisRequest.Builder} avoiding the need to create
     * one manually via {@link GetApisRequest#builder()}
     * </p>
     *
     * @param getApisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetApisRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApis
     */
    default CompletableFuture<GetApisResponse> getApis(Consumer<GetApisRequest.Builder> getApisRequest) {
        return getApis(GetApisRequest.builder().applyMutation(getApisRequest).build());
    }

    /**
     * <p>
     * Gets a collection of Api resources.
     * </p>
     *
     * @return A Java Future containing the result of the GetApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetApis
     */
    default CompletableFuture<GetApisResponse> getApis() {
        return getApis(GetApisRequest.builder().build());
    }

    /**
     * <p>
     * Gets an Authorizer.
     * </p>
     *
     * @param getAuthorizerRequest
     * @return A Java Future containing the result of the GetAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetAuthorizer
     */
    default CompletableFuture<GetAuthorizerResponse> getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizerRequest#builder()}
     * </p>
     *
     * @param getAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetAuthorizer
     */
    default CompletableFuture<GetAuthorizerResponse> getAuthorizer(Consumer<GetAuthorizerRequest.Builder> getAuthorizerRequest) {
        return getAuthorizer(GetAuthorizerRequest.builder().applyMutation(getAuthorizerRequest).build());
    }

    /**
     * <p>
     * Gets the Authorizers for an API.
     * </p>
     *
     * @param getAuthorizersRequest
     * @return A Java Future containing the result of the GetAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetAuthorizers
     */
    default CompletableFuture<GetAuthorizersResponse> getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Authorizers for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizersRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizersRequest#builder()}
     * </p>
     *
     * @param getAuthorizersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetAuthorizersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetAuthorizers
     */
    default CompletableFuture<GetAuthorizersResponse> getAuthorizers(Consumer<GetAuthorizersRequest.Builder> getAuthorizersRequest) {
        return getAuthorizers(GetAuthorizersRequest.builder().applyMutation(getAuthorizersRequest).build());
    }

    /**
     * <p>
     * Gets a Deployment.
     * </p>
     *
     * @param getDeploymentRequest
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDeployment
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDeployment
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets the Deployments for an API.
     * </p>
     *
     * @param getDeploymentsRequest
     * @return A Java Future containing the result of the GetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDeployments
     */
    default CompletableFuture<GetDeploymentsResponse> getDeployments(GetDeploymentsRequest getDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Deployments for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentsRequest#builder()}
     * </p>
     *
     * @param getDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDeployments
     */
    default CompletableFuture<GetDeploymentsResponse> getDeployments(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest) {
        return getDeployments(GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets a domain name.
     * </p>
     *
     * @param getDomainNameRequest
     * @return A Java Future containing the result of the GetDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDomainName
     */
    default CompletableFuture<GetDomainNameResponse> getDomainName(GetDomainNameRequest getDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNameRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNameRequest#builder()}
     * </p>
     *
     * @param getDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetDomainNameRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDomainName
     */
    default CompletableFuture<GetDomainNameResponse> getDomainName(Consumer<GetDomainNameRequest.Builder> getDomainNameRequest) {
        return getDomainName(GetDomainNameRequest.builder().applyMutation(getDomainNameRequest).build());
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     *
     * @param getDomainNamesRequest
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDomainNames
     */
    default CompletableFuture<GetDomainNamesResponse> getDomainNames(GetDomainNamesRequest getDomainNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNamesRequest#builder()}
     * </p>
     *
     * @param getDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDomainNames
     */
    default CompletableFuture<GetDomainNamesResponse> getDomainNames(Consumer<GetDomainNamesRequest.Builder> getDomainNamesRequest) {
        return getDomainNames(GetDomainNamesRequest.builder().applyMutation(getDomainNamesRequest).build());
    }

    /**
     * <p>
     * Gets the domain names for an AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetDomainNames
     */
    default CompletableFuture<GetDomainNamesResponse> getDomainNames() {
        return getDomainNames(GetDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Gets an Integration.
     * </p>
     *
     * @param getIntegrationRequest
     * @return A Java Future containing the result of the GetIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegration
     */
    default CompletableFuture<GetIntegrationResponse> getIntegration(GetIntegrationRequest getIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link GetIntegrationRequest#builder()}
     * </p>
     *
     * @param getIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegration
     */
    default CompletableFuture<GetIntegrationResponse> getIntegration(Consumer<GetIntegrationRequest.Builder> getIntegrationRequest) {
        return getIntegration(GetIntegrationRequest.builder().applyMutation(getIntegrationRequest).build());
    }

    /**
     * <p>
     * Gets an IntegrationResponses.
     * </p>
     *
     * @param getIntegrationResponseRequest
     * @return A Java Future containing the result of the GetIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegrationResponse
     */
    default CompletableFuture<GetIntegrationResponseResponse> getIntegrationResponse(
            GetIntegrationResponseRequest getIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResponseRequest.Builder} avoiding the
     * need to create one manually via {@link GetIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegrationResponse
     */
    default CompletableFuture<GetIntegrationResponseResponse> getIntegrationResponse(
            Consumer<GetIntegrationResponseRequest.Builder> getIntegrationResponseRequest) {
        return getIntegrationResponse(GetIntegrationResponseRequest.builder().applyMutation(getIntegrationResponseRequest)
                .build());
    }

    /**
     * <p>
     * Gets the IntegrationResponses for an Integration.
     * </p>
     *
     * @param getIntegrationResponsesRequest
     * @return A Java Future containing the result of the GetIntegrationResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegrationResponses
     */
    default CompletableFuture<GetIntegrationResponsesResponse> getIntegrationResponses(
            GetIntegrationResponsesRequest getIntegrationResponsesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IntegrationResponses for an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResponsesRequest.Builder} avoiding
     * the need to create one manually via {@link GetIntegrationResponsesRequest#builder()}
     * </p>
     *
     * @param getIntegrationResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetIntegrationResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegrationResponses
     */
    default CompletableFuture<GetIntegrationResponsesResponse> getIntegrationResponses(
            Consumer<GetIntegrationResponsesRequest.Builder> getIntegrationResponsesRequest) {
        return getIntegrationResponses(GetIntegrationResponsesRequest.builder().applyMutation(getIntegrationResponsesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the Integrations for an API.
     * </p>
     *
     * @param getIntegrationsRequest
     * @return A Java Future containing the result of the GetIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegrations
     */
    default CompletableFuture<GetIntegrationsResponse> getIntegrations(GetIntegrationsRequest getIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Integrations for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationsRequest.Builder} avoiding the need
     * to create one manually via {@link GetIntegrationsRequest#builder()}
     * </p>
     *
     * @param getIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetIntegrations
     */
    default CompletableFuture<GetIntegrationsResponse> getIntegrations(
            Consumer<GetIntegrationsRequest.Builder> getIntegrationsRequest) {
        return getIntegrations(GetIntegrationsRequest.builder().applyMutation(getIntegrationsRequest).build());
    }

    /**
     * <p>
     * Gets a Model.
     * </p>
     *
     * @param getModelRequest
     * @return A Java Future containing the result of the GetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetModel
     */
    default CompletableFuture<GetModelResponse> getModel(GetModelRequest getModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelRequest#builder()}
     * </p>
     *
     * @param getModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetModel
     */
    default CompletableFuture<GetModelResponse> getModel(Consumer<GetModelRequest.Builder> getModelRequest) {
        return getModel(GetModelRequest.builder().applyMutation(getModelRequest).build());
    }

    /**
     * <p>
     * Gets a model template.
     * </p>
     *
     * @param getModelTemplateRequest
     * @return A Java Future containing the result of the GetModelTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetModelTemplate
     */
    default CompletableFuture<GetModelTemplateResponse> getModelTemplate(GetModelTemplateRequest getModelTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a model template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelTemplateRequest#builder()}
     * </p>
     *
     * @param getModelTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetModelTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetModelTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetModelTemplate
     */
    default CompletableFuture<GetModelTemplateResponse> getModelTemplate(
            Consumer<GetModelTemplateRequest.Builder> getModelTemplateRequest) {
        return getModelTemplate(GetModelTemplateRequest.builder().applyMutation(getModelTemplateRequest).build());
    }

    /**
     * <p>
     * Gets the Models for an API.
     * </p>
     *
     * @param getModelsRequest
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetModels
     */
    default CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Models for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetModels
     */
    default CompletableFuture<GetModelsResponse> getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets a Route.
     * </p>
     *
     * @param getRouteRequest
     * @return A Java Future containing the result of the GetRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRoute
     */
    default CompletableFuture<GetRouteResponse> getRoute(GetRouteRequest getRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteRequest.Builder} avoiding the need to
     * create one manually via {@link GetRouteRequest#builder()}
     * </p>
     *
     * @param getRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetRouteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRoute
     */
    default CompletableFuture<GetRouteResponse> getRoute(Consumer<GetRouteRequest.Builder> getRouteRequest) {
        return getRoute(GetRouteRequest.builder().applyMutation(getRouteRequest).build());
    }

    /**
     * <p>
     * Gets a RouteResponse.
     * </p>
     *
     * @param getRouteResponseRequest
     * @return A Java Future containing the result of the GetRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRouteResponse
     */
    default CompletableFuture<GetRouteResponseResponse> getRouteResponse(GetRouteResponseRequest getRouteResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a RouteResponse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteResponseRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouteResponseRequest#builder()}
     * </p>
     *
     * @param getRouteResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRouteResponse
     */
    default CompletableFuture<GetRouteResponseResponse> getRouteResponse(
            Consumer<GetRouteResponseRequest.Builder> getRouteResponseRequest) {
        return getRouteResponse(GetRouteResponseRequest.builder().applyMutation(getRouteResponseRequest).build());
    }

    /**
     * <p>
     * Gets the RouteResponses for a Route.
     * </p>
     *
     * @param getRouteResponsesRequest
     * @return A Java Future containing the result of the GetRouteResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRouteResponses
     */
    default CompletableFuture<GetRouteResponsesResponse> getRouteResponses(GetRouteResponsesRequest getRouteResponsesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the RouteResponses for a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouteResponsesRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouteResponsesRequest#builder()}
     * </p>
     *
     * @param getRouteResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRouteResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRouteResponses
     */
    default CompletableFuture<GetRouteResponsesResponse> getRouteResponses(
            Consumer<GetRouteResponsesRequest.Builder> getRouteResponsesRequest) {
        return getRouteResponses(GetRouteResponsesRequest.builder().applyMutation(getRouteResponsesRequest).build());
    }

    /**
     * <p>
     * Gets the Routes for an API.
     * </p>
     *
     * @param getRoutesRequest
     * @return A Java Future containing the result of the GetRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRoutes
     */
    default CompletableFuture<GetRoutesResponse> getRoutes(GetRoutesRequest getRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Routes for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRoutesRequest#builder()}
     * </p>
     *
     * @param getRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetRoutes
     */
    default CompletableFuture<GetRoutesResponse> getRoutes(Consumer<GetRoutesRequest.Builder> getRoutesRequest) {
        return getRoutes(GetRoutesRequest.builder().applyMutation(getRoutesRequest).build());
    }

    /**
     * <p>
     * Gets a Stage.
     * </p>
     *
     * @param getStageRequest
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetStage
     */
    default CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetStage
     */
    default CompletableFuture<GetStageResponse> getStage(Consumer<GetStageRequest.Builder> getStageRequest) {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets the Stages for an API.
     * </p>
     *
     * @param getStagesRequest
     * @return A Java Future containing the result of the GetStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetStages
     */
    default CompletableFuture<GetStagesResponse> getStages(GetStagesRequest getStagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Stages for an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStagesRequest.Builder} avoiding the need to
     * create one manually via {@link GetStagesRequest#builder()}
     * </p>
     *
     * @param getStagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetStagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetStages
     */
    default CompletableFuture<GetStagesResponse> getStages(Consumer<GetStagesRequest.Builder> getStagesRequest) {
        return getStages(GetStagesRequest.builder().applyMutation(getStagesRequest).build());
    }

    /**
     * <p>
     * Gets a collection of Tag resources.
     * </p>
     *
     * @param getTagsRequest
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetTags
     */
    default CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of Tag resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetTags
     */
    default CompletableFuture<GetTagsResponse> getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Gets a VPC link.
     * </p>
     *
     * @param getVpcLinkRequest
     * @return A Java Future containing the result of the GetVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetVpcLink
     */
    default CompletableFuture<GetVpcLinkResponse> getVpcLink(GetVpcLinkRequest getVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinkRequest#builder()}
     * </p>
     *
     * @param getVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetVpcLink
     */
    default CompletableFuture<GetVpcLinkResponse> getVpcLink(Consumer<GetVpcLinkRequest.Builder> getVpcLinkRequest) {
        return getVpcLink(GetVpcLinkRequest.builder().applyMutation(getVpcLinkRequest).build());
    }

    /**
     * <p>
     * Gets a collection of VPC links.
     * </p>
     *
     * @param getVpcLinksRequest
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetVpcLinks
     */
    default CompletableFuture<GetVpcLinksResponse> getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of VPC links.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinksRequest#builder()}
     * </p>
     *
     * @param getVpcLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.GetVpcLinks
     */
    default CompletableFuture<GetVpcLinksResponse> getVpcLinks(Consumer<GetVpcLinksRequest.Builder> getVpcLinksRequest) {
        return getVpcLinks(GetVpcLinksRequest.builder().applyMutation(getVpcLinksRequest).build());
    }

    /**
     * <p>
     * Imports an API.
     * </p>
     *
     * @param importApiRequest
     * @return A Java Future containing the result of the ImportApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ImportApi
     */
    default CompletableFuture<ImportApiResponse> importApi(ImportApiRequest importApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports an API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportApiRequest.Builder} avoiding the need to
     * create one manually via {@link ImportApiRequest#builder()}
     * </p>
     *
     * @param importApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ImportApi
     */
    default CompletableFuture<ImportApiResponse> importApi(Consumer<ImportApiRequest.Builder> importApiRequest) {
        return importApi(ImportApiRequest.builder().applyMutation(importApiRequest).build());
    }

    /**
     * <p>
     * Puts an Api resource.
     * </p>
     *
     * @param reimportApiRequest
     * @return A Java Future containing the result of the ReimportApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ReimportApi
     */
    default CompletableFuture<ReimportApiResponse> reimportApi(ReimportApiRequest reimportApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReimportApiRequest.Builder} avoiding the need to
     * create one manually via {@link ReimportApiRequest#builder()}
     * </p>
     *
     * @param reimportApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ReimportApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ReimportApi
     */
    default CompletableFuture<ReimportApiResponse> reimportApi(Consumer<ReimportApiRequest.Builder> reimportApiRequest) {
        return reimportApi(ReimportApiRequest.builder().applyMutation(reimportApiRequest).build());
    }

    /**
     * <p>
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     * </p>
     *
     * @param resetAuthorizersCacheRequest
     * @return A Java Future containing the result of the ResetAuthorizersCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ResetAuthorizersCache
     */
    default CompletableFuture<ResetAuthorizersCacheResponse> resetAuthorizersCache(
            ResetAuthorizersCacheRequest resetAuthorizersCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetAuthorizersCacheRequest.Builder} avoiding the
     * need to create one manually via {@link ResetAuthorizersCacheRequest#builder()}
     * </p>
     *
     * @param resetAuthorizersCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.ResetAuthorizersCacheRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ResetAuthorizersCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.ResetAuthorizersCache
     */
    default CompletableFuture<ResetAuthorizersCacheResponse> resetAuthorizersCache(
            Consumer<ResetAuthorizersCacheRequest.Builder> resetAuthorizersCacheRequest) {
        return resetAuthorizersCache(ResetAuthorizersCacheRequest.builder().applyMutation(resetAuthorizersCacheRequest).build());
    }

    /**
     * <p>
     * Creates a new Tag resource to represent a tag.
     * </p>
     *
     * @param tagResourceRequest
     *        Creates a new Tag resource to represent a tag.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.TagResource
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Tag resource to represent a tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.TagResourceRequest.Builder} to create a request.
     *        Creates a new Tag resource to represent a tag.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.TagResource
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes a Tag.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UntagResource
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UntagResource
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Api resource.
     * </p>
     *
     * @param updateApiRequest
     *        Updates an Api.
     * @return A Java Future containing the result of the UpdateApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateApi
     */
    default CompletableFuture<UpdateApiResponse> updateApi(UpdateApiRequest updateApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Api resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiRequest#builder()}
     * </p>
     *
     * @param updateApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest.Builder} to create a request.
     *        Updates an Api.
     * @return A Java Future containing the result of the UpdateApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateApi
     */
    default CompletableFuture<UpdateApiResponse> updateApi(Consumer<UpdateApiRequest.Builder> updateApiRequest) {
        return updateApi(UpdateApiRequest.builder().applyMutation(updateApiRequest).build());
    }

    /**
     * <p>
     * The API mapping.
     * </p>
     *
     * @param updateApiMappingRequest
     *        Updates an ApiMapping.
     * @return A Java Future containing the result of the UpdateApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateApiMapping
     */
    default CompletableFuture<UpdateApiMappingResponse> updateApiMapping(UpdateApiMappingRequest updateApiMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The API mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiMappingRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApiMappingRequest#builder()}
     * </p>
     *
     * @param updateApiMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest.Builder} to create a
     *        request. Updates an ApiMapping.
     * @return A Java Future containing the result of the UpdateApiMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateApiMapping
     */
    default CompletableFuture<UpdateApiMappingResponse> updateApiMapping(
            Consumer<UpdateApiMappingRequest.Builder> updateApiMappingRequest) {
        return updateApiMapping(UpdateApiMappingRequest.builder().applyMutation(updateApiMappingRequest).build());
    }

    /**
     * <p>
     * Updates an Authorizer.
     * </p>
     *
     * @param updateAuthorizerRequest
     *        Updates an Authorizer.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateAuthorizer
     */
    default CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAuthorizerRequest#builder()}
     * </p>
     *
     * @param updateAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateAuthorizerRequest.Builder} to create a
     *        request. Updates an Authorizer.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateAuthorizer
     */
    default CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(
            Consumer<UpdateAuthorizerRequest.Builder> updateAuthorizerRequest) {
        return updateAuthorizer(UpdateAuthorizerRequest.builder().applyMutation(updateAuthorizerRequest).build());
    }

    /**
     * <p>
     * Updates a Deployment.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Updates a Deployment.
     * @return A Java Future containing the result of the UpdateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateDeployment
     */
    default CompletableFuture<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest updateDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDeploymentRequest#builder()}
     * </p>
     *
     * @param updateDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest.Builder} to create a
     *        request. Updates a Deployment.
     * @return A Java Future containing the result of the UpdateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateDeployment
     */
    default CompletableFuture<UpdateDeploymentResponse> updateDeployment(
            Consumer<UpdateDeploymentRequest.Builder> updateDeploymentRequest) {
        return updateDeployment(UpdateDeploymentRequest.builder().applyMutation(updateDeploymentRequest).build());
    }

    /**
     * <p>
     * Updates a domain name.
     * </p>
     *
     * @param updateDomainNameRequest
     *        Updates a DomainName.
     * @return A Java Future containing the result of the UpdateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateDomainName
     */
    default CompletableFuture<UpdateDomainNameResponse> updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainNameRequest#builder()}
     * </p>
     *
     * @param updateDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest.Builder} to create a
     *        request. Updates a DomainName.
     * @return A Java Future containing the result of the UpdateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateDomainName
     */
    default CompletableFuture<UpdateDomainNameResponse> updateDomainName(
            Consumer<UpdateDomainNameRequest.Builder> updateDomainNameRequest) {
        return updateDomainName(UpdateDomainNameRequest.builder().applyMutation(updateDomainNameRequest).build());
    }

    /**
     * <p>
     * Updates an Integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Updates an Integration.
     * @return A Java Future containing the result of the UpdateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateIntegration
     */
    default CompletableFuture<UpdateIntegrationResponse> updateIntegration(UpdateIntegrationRequest updateIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateIntegrationRequest#builder()}
     * </p>
     *
     * @param updateIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationRequest.Builder} to create a
     *        request. Updates an Integration.
     * @return A Java Future containing the result of the UpdateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateIntegration
     */
    default CompletableFuture<UpdateIntegrationResponse> updateIntegration(
            Consumer<UpdateIntegrationRequest.Builder> updateIntegrationRequest) {
        return updateIntegration(UpdateIntegrationRequest.builder().applyMutation(updateIntegrationRequest).build());
    }

    /**
     * <p>
     * Updates an IntegrationResponses.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Updates an IntegrationResponses.
     * @return A Java Future containing the result of the UpdateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateIntegrationResponse
     */
    default CompletableFuture<UpdateIntegrationResponseResponse> updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IntegrationResponses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest.Builder} to
     *        create a request. Updates an IntegrationResponses.
     * @return A Java Future containing the result of the UpdateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateIntegrationResponse
     */
    default CompletableFuture<UpdateIntegrationResponseResponse> updateIntegrationResponse(
            Consumer<UpdateIntegrationResponseRequest.Builder> updateIntegrationResponseRequest) {
        return updateIntegrationResponse(UpdateIntegrationResponseRequest.builder()
                .applyMutation(updateIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Updates a Model.
     * </p>
     *
     * @param updateModelRequest
     *        Updates a Model.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateModel
     */
    default CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateModelRequest.Builder} to create a request.
     *        Updates a Model.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateModel
     */
    default CompletableFuture<UpdateModelResponse> updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest) {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a Route.
     * </p>
     *
     * @param updateRouteRequest
     *        Updates a Route.
     * @return A Java Future containing the result of the UpdateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateRoute
     */
    default CompletableFuture<UpdateRouteResponse> updateRoute(UpdateRouteRequest updateRouteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Route.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRouteRequest#builder()}
     * </p>
     *
     * @param updateRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest.Builder} to create a request.
     *        Updates a Route.
     * @return A Java Future containing the result of the UpdateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateRoute
     */
    default CompletableFuture<UpdateRouteResponse> updateRoute(Consumer<UpdateRouteRequest.Builder> updateRouteRequest) {
        return updateRoute(UpdateRouteRequest.builder().applyMutation(updateRouteRequest).build());
    }

    /**
     * <p>
     * Updates a RouteResponse.
     * </p>
     *
     * @param updateRouteResponseRequest
     *        Updates a RouteResponse.
     * @return A Java Future containing the result of the UpdateRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateRouteResponse
     */
    default CompletableFuture<UpdateRouteResponseResponse> updateRouteResponse(
            UpdateRouteResponseRequest updateRouteResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a RouteResponse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouteResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRouteResponseRequest#builder()}
     * </p>
     *
     * @param updateRouteResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest.Builder} to create a
     *        request. Updates a RouteResponse.
     * @return A Java Future containing the result of the UpdateRouteResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateRouteResponse
     */
    default CompletableFuture<UpdateRouteResponseResponse> updateRouteResponse(
            Consumer<UpdateRouteResponseRequest.Builder> updateRouteResponseRequest) {
        return updateRouteResponse(UpdateRouteResponseRequest.builder().applyMutation(updateRouteResponseRequest).build());
    }

    /**
     * <p>
     * Updates a Stage.
     * </p>
     *
     * @param updateStageRequest
     *        Updates a Stage.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateStage
     */
    default CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest.Builder} to create a request.
     *        Updates a Stage.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>ConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateStage
     */
    default CompletableFuture<UpdateStageResponse> updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest) {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    /**
     * <p>
     * Updates a VPC link.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates a VPC link.
     * @return A Java Future containing the result of the UpdateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateVpcLink
     */
    default CompletableFuture<UpdateVpcLinkResponse> updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a VPC link.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVpcLinkRequest#builder()}
     * </p>
     *
     * @param updateVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest.Builder} to create a
     *        request. Updates a VPC link.
     * @return A Java Future containing the result of the UpdateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource specified in the request was not found.</li>
     *         <li>TooManyRequestsException The client is sending more than the allowed number of requests per unit of
     *         time.</li>
     *         <li>BadRequestException One of the parameters in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayV2AsyncClient.UpdateVpcLink
     */
    default CompletableFuture<UpdateVpcLinkResponse> updateVpcLink(Consumer<UpdateVpcLinkRequest.Builder> updateVpcLinkRequest) {
        return updateVpcLink(UpdateVpcLinkRequest.builder().applyMutation(updateVpcLinkRequest).build());
    }

    @Override
    default ApiGatewayV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ApiGatewayV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApiGatewayV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayV2AsyncClient}.
     */
    static ApiGatewayV2AsyncClientBuilder builder() {
        return new DefaultApiGatewayV2AsyncClientBuilder();
    }
}
