/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntegrationResponseResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetIntegrationResponseResponse.Builder, GetIntegrationResponseResponse> {
    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentHandlingStrategy")
            .getter(getter(GetIntegrationResponseResponse::contentHandlingStrategyAsString))
            .setter(setter(Builder::contentHandlingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build())
            .build();

    private static final SdkField<String> INTEGRATION_RESPONSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationResponseId").getter(getter(GetIntegrationResponseResponse::integrationResponseId))
            .setter(setter(Builder::integrationResponseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseId").build())
            .build();

    private static final SdkField<String> INTEGRATION_RESPONSE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationResponseKey").getter(getter(GetIntegrationResponseResponse::integrationResponseKey))
            .setter(setter(Builder::integrationResponseKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseKey").build())
            .build();

    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ResponseParameters")
            .getter(getter(GetIntegrationResponseResponse::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ResponseTemplates")
            .getter(getter(GetIntegrationResponseResponse::responseTemplates))
            .setter(setter(Builder::responseTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TemplateSelectionExpression")
            .getter(getter(GetIntegrationResponseResponse::templateSelectionExpression))
            .setter(setter(Builder::templateSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTENT_HANDLING_STRATEGY_FIELD, INTEGRATION_RESPONSE_ID_FIELD, INTEGRATION_RESPONSE_KEY_FIELD,
            RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD));

    private final String contentHandlingStrategy;

    private final String integrationResponseId;

    private final String integrationResponseKey;

    private final Map<String, String> responseParameters;

    private final Map<String, String> responseTemplates;

    private final String templateSelectionExpression;

    private GetIntegrationResponseResponse(BuilderImpl builder) {
        super(builder);
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.integrationResponseId = builder.integrationResponseId;
        this.integrationResponseKey = builder.integrationResponseKey;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.templateSelectionExpression = builder.templateSelectionExpression;
    }

    /**
     * <p>
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported
     * values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
     *         Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public final ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(contentHandlingStrategy);
    }

    /**
     * <p>
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported
     * values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
     *         Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public final String contentHandlingStrategyAsString() {
        return contentHandlingStrategy;
    }

    /**
     * <p>
     * The integration response ID.
     * </p>
     * 
     * @return The integration response ID.
     */
    public final String integrationResponseId() {
        return integrationResponseId;
    }

    /**
     * <p>
     * The integration response key.
     * </p>
     * 
     * @return The integration response key.
     */
    public final String integrationResponseKey() {
        return integrationResponseKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map specifying response parameters that are passed to the method response from the backend. The key
     * is a method response header parameter name and the mapped value is an integration response header value, a static
     * value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The
     * mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header
     * name. The mapped non-static value must match the pattern of integration.response.header.{name} or
     * integration.response.body.{JSON-expression}, where name is a valid and unique response header name and
     * JSON-expression is a valid JSON expression without the $ prefix.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseParameters} method.
     * </p>
     * 
     * @return A key-value map specifying response parameters that are passed to the method response from the backend.
     *         The key is a method response header parameter name and the mapped value is an integration response header
     *         value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration
     *         response body. The mapping key must match the pattern of method.response.header.{name}, where name is a
     *         valid and unique header name. The mapped non-static value must match the pattern of
     *         integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid
     *         and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
     */
    public final Map<String, String> responseParameters() {
        return responseParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseTemplates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseTemplates() {
        return responseTemplates != null && !(responseTemplates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs.
     * Response templates are represented as a key/value map, with a content-type as the key and a template as the
     * value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseTemplates} method.
     * </p>
     * 
     * @return The collection of response templates for the integration response as a string-to-string map of key-value
     *         pairs. Response templates are represented as a key/value map, with a content-type as the key and a
     *         template as the value.
     */
    public final Map<String, String> responseTemplates() {
        return responseTemplates;
    }

    /**
     * <p>
     * The template selection expressions for the integration response.
     * </p>
     * 
     * @return The template selection expressions for the integration response.
     */
    public final String templateSelectionExpression() {
        return templateSelectionExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationResponseKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTemplates() ? responseTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateSelectionExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationResponseResponse)) {
            return false;
        }
        GetIntegrationResponseResponse other = (GetIntegrationResponseResponse) obj;
        return Objects.equals(contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString())
                && Objects.equals(integrationResponseId(), other.integrationResponseId())
                && Objects.equals(integrationResponseKey(), other.integrationResponseKey())
                && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && hasResponseTemplates() == other.hasResponseTemplates()
                && Objects.equals(responseTemplates(), other.responseTemplates())
                && Objects.equals(templateSelectionExpression(), other.templateSelectionExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIntegrationResponseResponse")
                .add("ContentHandlingStrategy", contentHandlingStrategyAsString())
                .add("IntegrationResponseId", integrationResponseId()).add("IntegrationResponseKey", integrationResponseKey())
                .add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("ResponseTemplates", hasResponseTemplates() ? responseTemplates() : null)
                .add("TemplateSelectionExpression", templateSelectionExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentHandlingStrategy":
            return Optional.ofNullable(clazz.cast(contentHandlingStrategyAsString()));
        case "IntegrationResponseId":
            return Optional.ofNullable(clazz.cast(integrationResponseId()));
        case "IntegrationResponseKey":
            return Optional.ofNullable(clazz.cast(integrationResponseKey()));
        case "ResponseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "ResponseTemplates":
            return Optional.ofNullable(clazz.cast(responseTemplates()));
        case "TemplateSelectionExpression":
            return Optional.ofNullable(clazz.cast(templateSelectionExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntegrationResponseResponse, T> g) {
        return obj -> g.apply((GetIntegrationResponseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIntegrationResponseResponse> {
        /**
         * <p>
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         * Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         *        Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(String contentHandlingStrategy);

        /**
         * <p>
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         * Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         *        Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy);

        /**
         * <p>
         * The integration response ID.
         * </p>
         * 
         * @param integrationResponseId
         *        The integration response ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationResponseId(String integrationResponseId);

        /**
         * <p>
         * The integration response key.
         * </p>
         * 
         * @param integrationResponseKey
         *        The integration response key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationResponseKey(String integrationResponseKey);

        /**
         * <p>
         * A key-value map specifying response parameters that are passed to the method response from the backend. The
         * key is a method response header parameter name and the mapped value is an integration response header value,
         * a static value enclosed within a pair of single quotes, or a JSON expression from the integration response
         * body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and
         * unique header name. The mapped non-static value must match the pattern of integration.response.header.{name}
         * or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and
         * JSON-expression is a valid JSON expression without the $ prefix.
         * </p>
         * 
         * @param responseParameters
         *        A key-value map specifying response parameters that are passed to the method response from the
         *        backend. The key is a method response header parameter name and the mapped value is an integration
         *        response header value, a static value enclosed within a pair of single quotes, or a JSON expression
         *        from the integration response body. The mapping key must match the pattern of
         *        method.response.header.{name}, where name is a valid and unique header name. The mapped non-static
         *        value must match the pattern of integration.response.header.{name} or
         *        integration.response.body.{JSON-expression}, where name is a valid and unique response header name and
         *        JSON-expression is a valid JSON expression without the $ prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, String> responseParameters);

        /**
         * <p>
         * The collection of response templates for the integration response as a string-to-string map of key-value
         * pairs. Response templates are represented as a key/value map, with a content-type as the key and a template
         * as the value.
         * </p>
         * 
         * @param responseTemplates
         *        The collection of response templates for the integration response as a string-to-string map of
         *        key-value pairs. Response templates are represented as a key/value map, with a content-type as the key
         *        and a template as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTemplates(Map<String, String> responseTemplates);

        /**
         * <p>
         * The template selection expressions for the integration response.
         * </p>
         * 
         * @param templateSelectionExpression
         *        The template selection expressions for the integration response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSelectionExpression(String templateSelectionExpression);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String contentHandlingStrategy;

        private String integrationResponseId;

        private String integrationResponseKey;

        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private String templateSelectionExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationResponseResponse model) {
            super(model);
            contentHandlingStrategy(model.contentHandlingStrategy);
            integrationResponseId(model.integrationResponseId);
            integrationResponseKey(model.integrationResponseKey);
            responseParameters(model.responseParameters);
            responseTemplates(model.responseTemplates);
            templateSelectionExpression(model.templateSelectionExpression);
        }

        public final String getContentHandlingStrategy() {
            return contentHandlingStrategy;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy == null ? null : contentHandlingStrategy.toString());
            return this;
        }

        public final String getIntegrationResponseId() {
            return integrationResponseId;
        }

        public final void setIntegrationResponseId(String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
        }

        @Override
        public final Builder integrationResponseId(String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
            return this;
        }

        public final String getIntegrationResponseKey() {
            return integrationResponseKey;
        }

        public final void setIntegrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
        }

        @Override
        public final Builder integrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
            return this;
        }

        public final Map<String, String> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseTemplates() {
            if (responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseTemplates;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
            return this;
        }

        public final String getTemplateSelectionExpression() {
            return templateSelectionExpression;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        @Override
        public GetIntegrationResponseResponse build() {
            return new GetIntegrationResponseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
