/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates an Api.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateApiRequest.Builder, UpdateApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(UpdateApiRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeySelectionExpression").getter(getter(UpdateApiRequest::apiKeySelectionExpression))
            .setter(setter(Builder::apiKeySelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build())
            .build();

    private static final SdkField<Cors> CORS_CONFIGURATION_FIELD = SdkField.<Cors> builder(MarshallingType.SDK_POJO)
            .memberName("CorsConfiguration").getter(getter(UpdateApiRequest::corsConfiguration))
            .setter(setter(Builder::corsConfiguration)).constructor(Cors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("corsConfiguration").build()).build();

    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialsArn").getter(getter(UpdateApiRequest::credentialsArn))
            .setter(setter(Builder::credentialsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApiRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableSchemaValidation").getter(getter(UpdateApiRequest::disableSchemaValidation))
            .setter(setter(Builder::disableSchemaValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build())
            .build();

    private static final SdkField<Boolean> DISABLE_EXECUTE_API_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DisableExecuteApiEndpoint")
            .getter(getter(UpdateApiRequest::disableExecuteApiEndpoint)).setter(setter(Builder::disableExecuteApiEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableExecuteApiEndpoint").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteKey").getter(getter(UpdateApiRequest::routeKey)).setter(setter(Builder::routeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()).build();

    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteSelectionExpression").getter(getter(UpdateApiRequest::routeSelectionExpression))
            .setter(setter(Builder::routeSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build())
            .build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(UpdateApiRequest::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(UpdateApiRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            API_KEY_SELECTION_EXPRESSION_FIELD, CORS_CONFIGURATION_FIELD, CREDENTIALS_ARN_FIELD, DESCRIPTION_FIELD,
            DISABLE_SCHEMA_VALIDATION_FIELD, DISABLE_EXECUTE_API_ENDPOINT_FIELD, NAME_FIELD, ROUTE_KEY_FIELD,
            ROUTE_SELECTION_EXPRESSION_FIELD, TARGET_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("apiId", API_ID_FIELD);
                    put("apiKeySelectionExpression", API_KEY_SELECTION_EXPRESSION_FIELD);
                    put("corsConfiguration", CORS_CONFIGURATION_FIELD);
                    put("credentialsArn", CREDENTIALS_ARN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("disableSchemaValidation", DISABLE_SCHEMA_VALIDATION_FIELD);
                    put("disableExecuteApiEndpoint", DISABLE_EXECUTE_API_ENDPOINT_FIELD);
                    put("name", NAME_FIELD);
                    put("routeKey", ROUTE_KEY_FIELD);
                    put("routeSelectionExpression", ROUTE_SELECTION_EXPRESSION_FIELD);
                    put("target", TARGET_FIELD);
                    put("version", VERSION_FIELD);
                }
            });

    private final String apiId;

    private final String apiKeySelectionExpression;

    private final Cors corsConfiguration;

    private final String credentialsArn;

    private final String description;

    private final Boolean disableSchemaValidation;

    private final Boolean disableExecuteApiEndpoint;

    private final String name;

    private final String routeKey;

    private final String routeSelectionExpression;

    private final String target;

    private final String version;

    private UpdateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.corsConfiguration = builder.corsConfiguration;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
        this.name = builder.name;
        this.routeKey = builder.routeKey;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.target = builder.target;
        this.version = builder.version;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * An API key selection expression. Supported only for WebSocket APIs. See <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     * >API Key Selection Expressions</a>.
     * </p>
     * 
     * @return An API key selection expression. Supported only for WebSocket APIs. See <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     *         >API Key Selection Expressions</a>.
     */
    public final String apiKeySelectionExpression() {
        return apiKeySelectionExpression;
    }

    /**
     * <p>
     * A CORS configuration. Supported only for HTTP APIs.
     * </p>
     * 
     * @return A CORS configuration. Supported only for HTTP APIs.
     */
    public final Cors corsConfiguration() {
        return corsConfiguration;
    }

    /**
     * <p>
     * This property is part of quick create. It specifies the credentials required for the integration, if any. For a
     * Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's
     * Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify
     * arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter.
     * Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials
     * associated with the quick create integration. Supported only for HTTP APIs.
     * </p>
     * 
     * @return This property is part of quick create. It specifies the credentials required for the integration, if any.
     *         For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume,
     *         use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from
     *         the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services,
     *         don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided,
     *         this value replaces the credentials associated with the quick create integration. Supported only for HTTP
     *         APIs.
     */
    public final String credentialsArn() {
        return credentialsArn;
    }

    /**
     * <p>
     * The description of the API.
     * </p>
     * 
     * @return The description of the API.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     */
    public final Boolean disableSchemaValidation() {
        return disableSchemaValidation;
    }

    /**
     * <p>
     * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can
     * invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that
     * clients use a custom domain name to invoke your API, disable the default endpoint.
     * </p>
     * 
     * @return Specifies whether clients can invoke your API by using the default execute-api endpoint. By default,
     *         clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
     *         endpoint. To require that clients use a custom domain name to invoke your API, disable the default
     *         endpoint.
     */
    public final Boolean disableExecuteApiEndpoint() {
        return disableExecuteApiEndpoint;
    }

    /**
     * <p>
     * The name of the API.
     * </p>
     * 
     * @return The name of the API.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise,
     * this value replaces the route key of the quick create route. Additional routes may still be added after the API
     * is updated. Supported only for HTTP APIs.
     * </p>
     * 
     * @return This property is part of quick create. If not specified, the route created using quick create is kept.
     *         Otherwise, this value replaces the route key of the quick create route. Additional routes may still be
     *         added after the API is updated. Supported only for HTTP APIs.
     */
    public final String routeKey() {
        return routeKey;
    }

    /**
     * <p>
     * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method}
     * ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket
     * APIs.
     * </p>
     * 
     * @return The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be
     *         ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property
     *         is required for WebSocket APIs.
     */
    public final String routeSelectionExpression() {
        return routeSelectionExpression;
    }

    /**
     * <p>
     * This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda
     * integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively.
     * The value provided updates the integration URI and integration type. You can update a quick-created target, but
     * you can't remove it from an API. Supported only for HTTP APIs.
     * </p>
     * 
     * @return This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda
     *         integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY,
     *         respectively. The value provided updates the integration URI and integration type. You can update a
     *         quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(disableExecuteApiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiRequest)) {
            return false;
        }
        UpdateApiRequest other = (UpdateApiRequest) obj;
        return Objects.equals(apiId(), other.apiId())
                && Objects.equals(apiKeySelectionExpression(), other.apiKeySelectionExpression())
                && Objects.equals(corsConfiguration(), other.corsConfiguration())
                && Objects.equals(credentialsArn(), other.credentialsArn()) && Objects.equals(description(), other.description())
                && Objects.equals(disableSchemaValidation(), other.disableSchemaValidation())
                && Objects.equals(disableExecuteApiEndpoint(), other.disableExecuteApiEndpoint())
                && Objects.equals(name(), other.name()) && Objects.equals(routeKey(), other.routeKey())
                && Objects.equals(routeSelectionExpression(), other.routeSelectionExpression())
                && Objects.equals(target(), other.target()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApiRequest").add("ApiId", apiId())
                .add("ApiKeySelectionExpression", apiKeySelectionExpression()).add("CorsConfiguration", corsConfiguration())
                .add("CredentialsArn", credentialsArn()).add("Description", description())
                .add("DisableSchemaValidation", disableSchemaValidation())
                .add("DisableExecuteApiEndpoint", disableExecuteApiEndpoint()).add("Name", name()).add("RouteKey", routeKey())
                .add("RouteSelectionExpression", routeSelectionExpression()).add("Target", target()).add("Version", version())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiKeySelectionExpression":
            return Optional.ofNullable(clazz.cast(apiKeySelectionExpression()));
        case "CorsConfiguration":
            return Optional.ofNullable(clazz.cast(corsConfiguration()));
        case "CredentialsArn":
            return Optional.ofNullable(clazz.cast(credentialsArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisableSchemaValidation":
            return Optional.ofNullable(clazz.cast(disableSchemaValidation()));
        case "DisableExecuteApiEndpoint":
            return Optional.ofNullable(clazz.cast(disableExecuteApiEndpoint()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RouteKey":
            return Optional.ofNullable(clazz.cast(routeKey()));
        case "RouteSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeSelectionExpression()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiRequest, T> g) {
        return obj -> g.apply((UpdateApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * An API key selection expression. Supported only for WebSocket APIs. See <a href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         * >API Key Selection Expressions</a>.
         * </p>
         * 
         * @param apiKeySelectionExpression
         *        An API key selection expression. Supported only for WebSocket APIs. See <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         *        >API Key Selection Expressions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySelectionExpression(String apiKeySelectionExpression);

        /**
         * <p>
         * A CORS configuration. Supported only for HTTP APIs.
         * </p>
         * 
         * @param corsConfiguration
         *        A CORS configuration. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsConfiguration(Cors corsConfiguration);

        /**
         * <p>
         * A CORS configuration. Supported only for HTTP APIs.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cors.Builder} avoiding the need to create
         * one manually via {@link Cors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cors.Builder#build()} is called immediately and its result is
         * passed to {@link #corsConfiguration(Cors)}.
         * 
         * @param corsConfiguration
         *        a consumer that will call methods on {@link Cors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsConfiguration(Cors)
         */
        default Builder corsConfiguration(Consumer<Cors.Builder> corsConfiguration) {
            return corsConfiguration(Cors.builder().applyMutation(corsConfiguration).build());
        }

        /**
         * <p>
         * This property is part of quick create. It specifies the credentials required for the integration, if any. For
         * a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the
         * role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request,
         * specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify
         * this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces
         * the credentials associated with the quick create integration. Supported only for HTTP APIs.
         * </p>
         * 
         * @param credentialsArn
         *        This property is part of quick create. It specifies the credentials required for the integration, if
         *        any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to
         *        assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed
         *        through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on
         *        supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP
         *        integrations. If provided, this value replaces the credentials associated with the quick create
         *        integration. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsArn(String credentialsArn);

        /**
         * <p>
         * The description of the API.
         * </p>
         * 
         * @param description
         *        The description of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param disableSchemaValidation
         *        Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSchemaValidation(Boolean disableSchemaValidation);

        /**
         * <p>
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients
         * can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require
         * that clients use a custom domain name to invoke your API, disable the default endpoint.
         * </p>
         * 
         * @param disableExecuteApiEndpoint
         *        Specifies whether clients can invoke your API by using the default execute-api endpoint. By default,
         *        clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
         *        endpoint. To require that clients use a custom domain name to invoke your API, disable the default
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint);

        /**
         * <p>
         * The name of the API.
         * </p>
         * 
         * @param name
         *        The name of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This property is part of quick create. If not specified, the route created using quick create is kept.
         * Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added
         * after the API is updated. Supported only for HTTP APIs.
         * </p>
         * 
         * @param routeKey
         *        This property is part of quick create. If not specified, the route created using quick create is kept.
         *        Otherwise, this value replaces the route key of the quick create route. Additional routes may still be
         *        added after the API is updated. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeKey(String routeKey);

        /**
         * <p>
         * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be
         * ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is
         * required for WebSocket APIs.
         * </p>
         * 
         * @param routeSelectionExpression
         *        The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be
         *        ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This
         *        property is required for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSelectionExpression(String routeSelectionExpression);

        /**
         * <p>
         * This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda
         * integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY,
         * respectively. The value provided updates the integration URI and integration type. You can update a
         * quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.
         * </p>
         * 
         * @param target
         *        This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For
         *        Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or
         *        AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can
         *        update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String apiKeySelectionExpression;

        private Cors corsConfiguration;

        private String credentialsArn;

        private String description;

        private Boolean disableSchemaValidation;

        private Boolean disableExecuteApiEndpoint;

        private String name;

        private String routeKey;

        private String routeSelectionExpression;

        private String target;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiRequest model) {
            super(model);
            apiId(model.apiId);
            apiKeySelectionExpression(model.apiKeySelectionExpression);
            corsConfiguration(model.corsConfiguration);
            credentialsArn(model.credentialsArn);
            description(model.description);
            disableSchemaValidation(model.disableSchemaValidation);
            disableExecuteApiEndpoint(model.disableExecuteApiEndpoint);
            name(model.name);
            routeKey(model.routeKey);
            routeSelectionExpression(model.routeSelectionExpression);
            target(model.target);
            version(model.version);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getApiKeySelectionExpression() {
            return apiKeySelectionExpression;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final Cors.Builder getCorsConfiguration() {
            return corsConfiguration != null ? corsConfiguration.toBuilder() : null;
        }

        public final void setCorsConfiguration(Cors.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        @Override
        public final Builder corsConfiguration(Cors corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final String getCredentialsArn() {
            return credentialsArn;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDisableSchemaValidation() {
            return disableSchemaValidation;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final Boolean getDisableExecuteApiEndpoint() {
            return disableExecuteApiEndpoint;
        }

        public final void setDisableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
        }

        @Override
        public final Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRouteKey() {
            return routeKey;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final String getRouteSelectionExpression() {
            return routeSelectionExpression;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiRequest build() {
            return new UpdateApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
