/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportApiRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<ExportApiRequest.Builder, ExportApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(ExportApiRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> EXPORT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportVersion").getter(getter(ExportApiRequest::exportVersion)).setter(setter(Builder::exportVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("exportVersion").build()).build();

    private static final SdkField<Boolean> INCLUDE_EXTENSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeExtensions").getter(getter(ExportApiRequest::includeExtensions))
            .setter(setter(Builder::includeExtensions))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeExtensions").build())
            .build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(ExportApiRequest::outputType)).setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("outputType").build()).build();

    private static final SdkField<String> SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Specification").getter(getter(ExportApiRequest::specification)).setter(setter(Builder::specification))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("specification").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(ExportApiRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("stageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            EXPORT_VERSION_FIELD, INCLUDE_EXTENSIONS_FIELD, OUTPUT_TYPE_FIELD, SPECIFICATION_FIELD, STAGE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiId;

    private final String exportVersion;

    private final Boolean includeExtensions;

    private final String outputType;

    private final String specification;

    private final String stageName;

    private ExportApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.exportVersion = builder.exportVersion;
        this.includeExtensions = builder.includeExtensions;
        this.outputType = builder.outputType;
        this.specification = builder.specification;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the
     * only supported version is 1.0.
     * </p>
     * 
     * @return The version of the API Gateway export algorithm. API Gateway uses the latest version by default.
     *         Currently, the only supported version is 1.0.
     */
    public final String exportVersion() {
        return exportVersion;
    }

    /**
     * <p>
     * Specifies whether to include <a
     * href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API
     * Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.
     * </p>
     * 
     * @return Specifies whether to include <a
     *         href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html"
     *         >API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by
     *         default.
     */
    public final Boolean includeExtensions() {
        return includeExtensions;
    }

    /**
     * <p>
     * The output type of the exported definition file. Valid values are JSON and YAML.
     * </p>
     * 
     * @return The output type of the exported definition file. Valid values are JSON and YAML.
     */
    public final String outputType() {
        return outputType;
    }

    /**
     * <p>
     * The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
     * </p>
     * 
     * @return The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
     */
    public final String specification() {
        return specification;
    }

    /**
     * <p>
     * The name of the API stage to export. If you don't specify this property, a representation of the latest API
     * configuration is exported.
     * </p>
     * 
     * @return The name of the API stage to export. If you don't specify this property, a representation of the latest
     *         API configuration is exported.
     */
    public final String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(exportVersion());
        hashCode = 31 * hashCode + Objects.hashCode(includeExtensions());
        hashCode = 31 * hashCode + Objects.hashCode(outputType());
        hashCode = 31 * hashCode + Objects.hashCode(specification());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportApiRequest)) {
            return false;
        }
        ExportApiRequest other = (ExportApiRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(exportVersion(), other.exportVersion())
                && Objects.equals(includeExtensions(), other.includeExtensions())
                && Objects.equals(outputType(), other.outputType()) && Objects.equals(specification(), other.specification())
                && Objects.equals(stageName(), other.stageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportApiRequest").add("ApiId", apiId()).add("ExportVersion", exportVersion())
                .add("IncludeExtensions", includeExtensions()).add("OutputType", outputType())
                .add("Specification", specification()).add("StageName", stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ExportVersion":
            return Optional.ofNullable(clazz.cast(exportVersion()));
        case "IncludeExtensions":
            return Optional.ofNullable(clazz.cast(includeExtensions()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputType()));
        case "Specification":
            return Optional.ofNullable(clazz.cast(specification()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("exportVersion", EXPORT_VERSION_FIELD);
        map.put("includeExtensions", INCLUDE_EXTENSIONS_FIELD);
        map.put("outputType", OUTPUT_TYPE_FIELD);
        map.put("specification", SPECIFICATION_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportApiRequest, T> g) {
        return obj -> g.apply((ExportApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ExportApiRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently,
         * the only supported version is 1.0.
         * </p>
         * 
         * @param exportVersion
         *        The version of the API Gateway export algorithm. API Gateway uses the latest version by default.
         *        Currently, the only supported version is 1.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportVersion(String exportVersion);

        /**
         * <p>
         * Specifies whether to include <a
         * href="https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html">API
         * Gateway extensions</a> in the exported API definition. API Gateway extensions are included by default.
         * </p>
         * 
         * @param includeExtensions
         *        Specifies whether to include <a href=
         *        "https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html"
         *        >API Gateway extensions</a> in the exported API definition. API Gateway extensions are included by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeExtensions(Boolean includeExtensions);

        /**
         * <p>
         * The output type of the exported definition file. Valid values are JSON and YAML.
         * </p>
         * 
         * @param outputType
         *        The output type of the exported definition file. Valid values are JSON and YAML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
         * </p>
         * 
         * @param specification
         *        The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specification(String specification);

        /**
         * <p>
         * The name of the API stage to export. If you don't specify this property, a representation of the latest API
         * configuration is exported.
         * </p>
         * 
         * @param stageName
         *        The name of the API stage to export. If you don't specify this property, a representation of the
         *        latest API configuration is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String exportVersion;

        private Boolean includeExtensions;

        private String outputType;

        private String specification;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportApiRequest model) {
            super(model);
            apiId(model.apiId);
            exportVersion(model.exportVersion);
            includeExtensions(model.includeExtensions);
            outputType(model.outputType);
            specification(model.specification);
            stageName(model.stageName);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getExportVersion() {
            return exportVersion;
        }

        public final void setExportVersion(String exportVersion) {
            this.exportVersion = exportVersion;
        }

        @Override
        public final Builder exportVersion(String exportVersion) {
            this.exportVersion = exportVersion;
            return this;
        }

        public final Boolean getIncludeExtensions() {
            return includeExtensions;
        }

        public final void setIncludeExtensions(Boolean includeExtensions) {
            this.includeExtensions = includeExtensions;
        }

        @Override
        public final Builder includeExtensions(Boolean includeExtensions) {
            this.includeExtensions = includeExtensions;
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public final String getSpecification() {
            return specification;
        }

        public final void setSpecification(String specification) {
            this.specification = specification;
        }

        @Override
        public final Builder specification(String specification) {
            this.specification = specification;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportApiRequest build() {
            return new ExportApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
