/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVpcLinkResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetVpcLinkResponse.Builder, GetVpcLinkResponse> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(GetVpcLinkResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetVpcLinkResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(GetVpcLinkResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(GetVpcLinkResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetVpcLinkResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcLinkId").getter(getter(GetVpcLinkResponse::vpcLinkId)).setter(setter(Builder::vpcLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkId").build()).build();

    private static final SdkField<String> VPC_LINK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcLinkStatus").getter(getter(GetVpcLinkResponse::vpcLinkStatusAsString))
            .setter(setter(Builder::vpcLinkStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkStatus").build()).build();

    private static final SdkField<String> VPC_LINK_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcLinkStatusMessage").getter(getter(GetVpcLinkResponse::vpcLinkStatusMessage))
            .setter(setter(Builder::vpcLinkStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkStatusMessage").build())
            .build();

    private static final SdkField<String> VPC_LINK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcLinkVersion").getter(getter(GetVpcLinkResponse::vpcLinkVersionAsString))
            .setter(setter(Builder::vpcLinkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLinkVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD,
            NAME_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, VPC_LINK_ID_FIELD, VPC_LINK_STATUS_FIELD,
            VPC_LINK_STATUS_MESSAGE_FIELD, VPC_LINK_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdDate;

    private final String name;

    private final List<String> securityGroupIds;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final String vpcLinkId;

    private final String vpcLinkStatus;

    private final String vpcLinkStatusMessage;

    private final String vpcLinkVersion;

    private GetVpcLinkResponse(BuilderImpl builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcLinkId = builder.vpcLinkId;
        this.vpcLinkStatus = builder.vpcLinkStatus;
        this.vpcLinkStatusMessage = builder.vpcLinkStatusMessage;
        this.vpcLinkVersion = builder.vpcLinkVersion;
    }

    /**
     * <p>
     * The timestamp when the VPC link was created.
     * </p>
     * 
     * @return The timestamp when the VPC link was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The name of the VPC link.
     * </p>
     * 
     * @return The name of the VPC link.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group IDs for the VPC link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of security group IDs for the VPC link.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs to include in the VPC link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of subnet IDs to include in the VPC link.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the VPC link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the VPC link.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC link.
     * </p>
     * 
     * @return The ID of the VPC link.
     */
    public final String vpcLinkId() {
        return vpcLinkId;
    }

    /**
     * <p>
     * The status of the VPC link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcLinkStatus}
     * will return {@link VpcLinkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcLinkStatusAsString}.
     * </p>
     * 
     * @return The status of the VPC link.
     * @see VpcLinkStatus
     */
    public final VpcLinkStatus vpcLinkStatus() {
        return VpcLinkStatus.fromValue(vpcLinkStatus);
    }

    /**
     * <p>
     * The status of the VPC link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcLinkStatus}
     * will return {@link VpcLinkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcLinkStatusAsString}.
     * </p>
     * 
     * @return The status of the VPC link.
     * @see VpcLinkStatus
     */
    public final String vpcLinkStatusAsString() {
        return vpcLinkStatus;
    }

    /**
     * <p>
     * A message summarizing the cause of the status of the VPC link.
     * </p>
     * 
     * @return A message summarizing the cause of the status of the VPC link.
     */
    public final String vpcLinkStatusMessage() {
        return vpcLinkStatusMessage;
    }

    /**
     * <p>
     * The version of the VPC link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcLinkVersion}
     * will return {@link VpcLinkVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcLinkVersionAsString}.
     * </p>
     * 
     * @return The version of the VPC link.
     * @see VpcLinkVersion
     */
    public final VpcLinkVersion vpcLinkVersion() {
        return VpcLinkVersion.fromValue(vpcLinkVersion);
    }

    /**
     * <p>
     * The version of the VPC link.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcLinkVersion}
     * will return {@link VpcLinkVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcLinkVersionAsString}.
     * </p>
     * 
     * @return The version of the VPC link.
     * @see VpcLinkVersion
     */
    public final String vpcLinkVersionAsString() {
        return vpcLinkVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkVersionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpcLinkResponse)) {
            return false;
        }
        GetVpcLinkResponse other = (GetVpcLinkResponse) obj;
        return Objects.equals(createdDate(), other.createdDate()) && Objects.equals(name(), other.name())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcLinkId(), other.vpcLinkId())
                && Objects.equals(vpcLinkStatusAsString(), other.vpcLinkStatusAsString())
                && Objects.equals(vpcLinkStatusMessage(), other.vpcLinkStatusMessage())
                && Objects.equals(vpcLinkVersionAsString(), other.vpcLinkVersionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVpcLinkResponse").add("CreatedDate", createdDate()).add("Name", name())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("VpcLinkId", vpcLinkId()).add("VpcLinkStatus", vpcLinkStatusAsString())
                .add("VpcLinkStatusMessage", vpcLinkStatusMessage()).add("VpcLinkVersion", vpcLinkVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcLinkId":
            return Optional.ofNullable(clazz.cast(vpcLinkId()));
        case "VpcLinkStatus":
            return Optional.ofNullable(clazz.cast(vpcLinkStatusAsString()));
        case "VpcLinkStatusMessage":
            return Optional.ofNullable(clazz.cast(vpcLinkStatusMessage()));
        case "VpcLinkVersion":
            return Optional.ofNullable(clazz.cast(vpcLinkVersionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpcLinkId", VPC_LINK_ID_FIELD);
        map.put("vpcLinkStatus", VPC_LINK_STATUS_FIELD);
        map.put("vpcLinkStatusMessage", VPC_LINK_STATUS_MESSAGE_FIELD);
        map.put("vpcLinkVersion", VPC_LINK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVpcLinkResponse, T> g) {
        return obj -> g.apply((GetVpcLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetVpcLinkResponse> {
        /**
         * <p>
         * The timestamp when the VPC link was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the VPC link was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The name of the VPC link.
         * </p>
         * 
         * @param name
         *        The name of the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of security group IDs for the VPC link.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group IDs for the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security group IDs for the VPC link.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group IDs for the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * A list of subnet IDs to include in the VPC link.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs to include in the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs to include in the VPC link.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs to include in the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Tags for the VPC link.
         * </p>
         * 
         * @param tags
         *        Tags for the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the VPC link.
         * </p>
         * 
         * @param vpcLinkId
         *        The ID of the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLinkId(String vpcLinkId);

        /**
         * <p>
         * The status of the VPC link.
         * </p>
         * 
         * @param vpcLinkStatus
         *        The status of the VPC link.
         * @see VpcLinkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcLinkStatus
         */
        Builder vpcLinkStatus(String vpcLinkStatus);

        /**
         * <p>
         * The status of the VPC link.
         * </p>
         * 
         * @param vpcLinkStatus
         *        The status of the VPC link.
         * @see VpcLinkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcLinkStatus
         */
        Builder vpcLinkStatus(VpcLinkStatus vpcLinkStatus);

        /**
         * <p>
         * A message summarizing the cause of the status of the VPC link.
         * </p>
         * 
         * @param vpcLinkStatusMessage
         *        A message summarizing the cause of the status of the VPC link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLinkStatusMessage(String vpcLinkStatusMessage);

        /**
         * <p>
         * The version of the VPC link.
         * </p>
         * 
         * @param vpcLinkVersion
         *        The version of the VPC link.
         * @see VpcLinkVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcLinkVersion
         */
        Builder vpcLinkVersion(String vpcLinkVersion);

        /**
         * <p>
         * The version of the VPC link.
         * </p>
         * 
         * @param vpcLinkVersion
         *        The version of the VPC link.
         * @see VpcLinkVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcLinkVersion
         */
        Builder vpcLinkVersion(VpcLinkVersion vpcLinkVersion);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private Instant createdDate;

        private String name;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vpcLinkId;

        private String vpcLinkStatus;

        private String vpcLinkStatusMessage;

        private String vpcLinkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpcLinkResponse model) {
            super(model);
            createdDate(model.createdDate);
            name(model.name);
            securityGroupIds(model.securityGroupIds);
            subnetIds(model.subnetIds);
            tags(model.tags);
            vpcLinkId(model.vpcLinkId);
            vpcLinkStatus(model.vpcLinkStatus);
            vpcLinkStatusMessage(model.vpcLinkStatusMessage);
            vpcLinkVersion(model.vpcLinkVersion);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getVpcLinkId() {
            return vpcLinkId;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public final String getVpcLinkStatus() {
            return vpcLinkStatus;
        }

        public final void setVpcLinkStatus(String vpcLinkStatus) {
            this.vpcLinkStatus = vpcLinkStatus;
        }

        @Override
        public final Builder vpcLinkStatus(String vpcLinkStatus) {
            this.vpcLinkStatus = vpcLinkStatus;
            return this;
        }

        @Override
        public final Builder vpcLinkStatus(VpcLinkStatus vpcLinkStatus) {
            this.vpcLinkStatus(vpcLinkStatus == null ? null : vpcLinkStatus.toString());
            return this;
        }

        public final String getVpcLinkStatusMessage() {
            return vpcLinkStatusMessage;
        }

        public final void setVpcLinkStatusMessage(String vpcLinkStatusMessage) {
            this.vpcLinkStatusMessage = vpcLinkStatusMessage;
        }

        @Override
        public final Builder vpcLinkStatusMessage(String vpcLinkStatusMessage) {
            this.vpcLinkStatusMessage = vpcLinkStatusMessage;
            return this;
        }

        public final String getVpcLinkVersion() {
            return vpcLinkVersion;
        }

        public final void setVpcLinkVersion(String vpcLinkVersion) {
            this.vpcLinkVersion = vpcLinkVersion;
        }

        @Override
        public final Builder vpcLinkVersion(String vpcLinkVersion) {
            this.vpcLinkVersion = vpcLinkVersion;
            return this;
        }

        @Override
        public final Builder vpcLinkVersion(VpcLinkVersion vpcLinkVersion) {
            this.vpcLinkVersion(vpcLinkVersion == null ? null : vpcLinkVersion.toString());
            return this;
        }

        @Override
        public GetVpcLinkResponse build() {
            return new GetVpcLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
