/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of route settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSettings implements SdkPojo, Serializable, ToCopyableBuilder<RouteSettings.Builder, RouteSettings> {
    private static final SdkField<Boolean> DATA_TRACE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataTraceEnabled").getter(getter(RouteSettings::dataTraceEnabled))
            .setter(setter(Builder::dataTraceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTraceEnabled").build()).build();

    private static final SdkField<Boolean> DETAILED_METRICS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DetailedMetricsEnabled").getter(getter(RouteSettings::detailedMetricsEnabled))
            .setter(setter(Builder::detailedMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailedMetricsEnabled").build())
            .build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingLevel").getter(getter(RouteSettings::loggingLevelAsString)).setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingLevel").build()).build();

    private static final SdkField<Integer> THROTTLING_BURST_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThrottlingBurstLimit").getter(getter(RouteSettings::throttlingBurstLimit))
            .setter(setter(Builder::throttlingBurstLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttlingBurstLimit").build())
            .build();

    private static final SdkField<Double> THROTTLING_RATE_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThrottlingRateLimit").getter(getter(RouteSettings::throttlingRateLimit))
            .setter(setter(Builder::throttlingRateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttlingRateLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TRACE_ENABLED_FIELD,
            DETAILED_METRICS_ENABLED_FIELD, LOGGING_LEVEL_FIELD, THROTTLING_BURST_LIMIT_FIELD, THROTTLING_RATE_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean dataTraceEnabled;

    private final Boolean detailedMetricsEnabled;

    private final String loggingLevel;

    private final Integer throttlingBurstLimit;

    private final Double throttlingRateLimit;

    private RouteSettings(BuilderImpl builder) {
        this.dataTraceEnabled = builder.dataTraceEnabled;
        this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
        this.loggingLevel = builder.loggingLevel;
        this.throttlingBurstLimit = builder.throttlingBurstLimit;
        this.throttlingRateLimit = builder.throttlingRateLimit;
    }

    /**
     * <p>
     * Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects the
     * log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return Specifies whether (true) or not (false) data trace logging is enabled for this route. This property
     *         affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
     */
    public final Boolean dataTraceEnabled() {
        return dataTraceEnabled;
    }

    /**
     * <p>
     * Specifies whether detailed metrics are enabled.
     * </p>
     * 
     * @return Specifies whether detailed metrics are enabled.
     */
    public final Boolean detailedMetricsEnabled() {
        return detailedMetricsEnabled;
    }

    /**
     * <p>
     * Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to
     * Amazon CloudWatch Logs. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loggingLevel} will
     * return {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #loggingLevelAsString}.
     * </p>
     * 
     * @return Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries
     *         pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
     * @see LoggingLevel
     */
    public final LoggingLevel loggingLevel() {
        return LoggingLevel.fromValue(loggingLevel);
    }

    /**
     * <p>
     * Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed to
     * Amazon CloudWatch Logs. Supported only for WebSocket APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loggingLevel} will
     * return {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #loggingLevelAsString}.
     * </p>
     * 
     * @return Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries
     *         pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
     * @see LoggingLevel
     */
    public final String loggingLevelAsString() {
        return loggingLevel;
    }

    /**
     * <p>
     * Specifies the throttling burst limit.
     * </p>
     * 
     * @return Specifies the throttling burst limit.
     */
    public final Integer throttlingBurstLimit() {
        return throttlingBurstLimit;
    }

    /**
     * <p>
     * Specifies the throttling rate limit.
     * </p>
     * 
     * @return Specifies the throttling rate limit.
     */
    public final Double throttlingRateLimit() {
        return throttlingRateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTraceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(detailedMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingBurstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingRateLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSettings)) {
            return false;
        }
        RouteSettings other = (RouteSettings) obj;
        return Objects.equals(dataTraceEnabled(), other.dataTraceEnabled())
                && Objects.equals(detailedMetricsEnabled(), other.detailedMetricsEnabled())
                && Objects.equals(loggingLevelAsString(), other.loggingLevelAsString())
                && Objects.equals(throttlingBurstLimit(), other.throttlingBurstLimit())
                && Objects.equals(throttlingRateLimit(), other.throttlingRateLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSettings").add("DataTraceEnabled", dataTraceEnabled())
                .add("DetailedMetricsEnabled", detailedMetricsEnabled()).add("LoggingLevel", loggingLevelAsString())
                .add("ThrottlingBurstLimit", throttlingBurstLimit()).add("ThrottlingRateLimit", throttlingRateLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTraceEnabled":
            return Optional.ofNullable(clazz.cast(dataTraceEnabled()));
        case "DetailedMetricsEnabled":
            return Optional.ofNullable(clazz.cast(detailedMetricsEnabled()));
        case "LoggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevelAsString()));
        case "ThrottlingBurstLimit":
            return Optional.ofNullable(clazz.cast(throttlingBurstLimit()));
        case "ThrottlingRateLimit":
            return Optional.ofNullable(clazz.cast(throttlingRateLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataTraceEnabled", DATA_TRACE_ENABLED_FIELD);
        map.put("detailedMetricsEnabled", DETAILED_METRICS_ENABLED_FIELD);
        map.put("loggingLevel", LOGGING_LEVEL_FIELD);
        map.put("throttlingBurstLimit", THROTTLING_BURST_LIMIT_FIELD);
        map.put("throttlingRateLimit", THROTTLING_RATE_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteSettings, T> g) {
        return obj -> g.apply((RouteSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSettings> {
        /**
         * <p>
         * Specifies whether (true) or not (false) data trace logging is enabled for this route. This property affects
         * the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param dataTraceEnabled
         *        Specifies whether (true) or not (false) data trace logging is enabled for this route. This property
         *        affects the log entries pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTraceEnabled(Boolean dataTraceEnabled);

        /**
         * <p>
         * Specifies whether detailed metrics are enabled.
         * </p>
         * 
         * @param detailedMetricsEnabled
         *        Specifies whether detailed metrics are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedMetricsEnabled(Boolean detailedMetricsEnabled);

        /**
         * <p>
         * Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed
         * to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param loggingLevel
         *        Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries
         *        pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder loggingLevel(String loggingLevel);

        /**
         * <p>
         * Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries pushed
         * to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param loggingLevel
         *        Specifies the logging level for this route: INFO, ERROR, or OFF. This property affects the log entries
         *        pushed to Amazon CloudWatch Logs. Supported only for WebSocket APIs.
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder loggingLevel(LoggingLevel loggingLevel);

        /**
         * <p>
         * Specifies the throttling burst limit.
         * </p>
         * 
         * @param throttlingBurstLimit
         *        Specifies the throttling burst limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingBurstLimit(Integer throttlingBurstLimit);

        /**
         * <p>
         * Specifies the throttling rate limit.
         * </p>
         * 
         * @param throttlingRateLimit
         *        Specifies the throttling rate limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingRateLimit(Double throttlingRateLimit);
    }

    static final class BuilderImpl implements Builder {
        private Boolean dataTraceEnabled;

        private Boolean detailedMetricsEnabled;

        private String loggingLevel;

        private Integer throttlingBurstLimit;

        private Double throttlingRateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSettings model) {
            dataTraceEnabled(model.dataTraceEnabled);
            detailedMetricsEnabled(model.detailedMetricsEnabled);
            loggingLevel(model.loggingLevel);
            throttlingBurstLimit(model.throttlingBurstLimit);
            throttlingRateLimit(model.throttlingRateLimit);
        }

        public final Boolean getDataTraceEnabled() {
            return dataTraceEnabled;
        }

        public final void setDataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
        }

        @Override
        public final Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public final Boolean getDetailedMetricsEnabled() {
            return detailedMetricsEnabled;
        }

        public final void setDetailedMetricsEnabled(Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
        }

        @Override
        public final Builder detailedMetricsEnabled(Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
            return this;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @Override
        public final Builder loggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel(loggingLevel == null ? null : loggingLevel.toString());
            return this;
        }

        public final Integer getThrottlingBurstLimit() {
            return throttlingBurstLimit;
        }

        public final void setThrottlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
        }

        @Override
        public final Builder throttlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public final Double getThrottlingRateLimit() {
            return throttlingRateLimit;
        }

        public final void setThrottlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
        }

        @Override
        public final Builder throttlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        @Override
        public RouteSettings build() {
            return new RouteSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
