/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for logging access in a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLogSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessLogSettings.Builder, AccessLogSettings> {
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessLogSettings::destinationArn)).setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessLogSettings::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ARN_FIELD,
            FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationArn;

    private final String format;

    private AccessLogSettings(BuilderImpl builder) {
        this.destinationArn = builder.destinationArn;
        this.format = builder.format;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs log group to receive access logs.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs log group to receive access logs.
     */
    public String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * A single line format of the access logs of data, as specified by selected $context variables. The format must
     * include at least $context.requestId.
     * </p>
     * 
     * @return A single line format of the access logs of data, as specified by selected $context variables. The format
     *         must include at least $context.requestId.
     */
    public String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLogSettings)) {
            return false;
        }
        AccessLogSettings other = (AccessLogSettings) obj;
        return Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(format(), other.format());
    }

    @Override
    public String toString() {
        return ToString.builder("AccessLogSettings").add("DestinationArn", destinationArn()).add("Format", format()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessLogSettings, T> g) {
        return obj -> g.apply((AccessLogSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessLogSettings> {
        /**
         * <p>
         * The ARN of the CloudWatch Logs log group to receive access logs.
         * </p>
         * 
         * @param destinationArn
         *        The ARN of the CloudWatch Logs log group to receive access logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * A single line format of the access logs of data, as specified by selected $context variables. The format must
         * include at least $context.requestId.
         * </p>
         * 
         * @param format
         *        A single line format of the access logs of data, as specified by selected $context variables. The
         *        format must include at least $context.requestId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl implements Builder {
        private String destinationArn;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLogSettings model) {
            destinationArn(model.destinationArn);
            format(model.format);
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public AccessLogSettings build() {
            return new AccessLogSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
