/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an authorizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Authorizer implements SdkPojo, Serializable, ToCopyableBuilder<Authorizer.Builder, Authorizer> {
    private static final SdkField<String> AUTHORIZER_CREDENTIALS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Authorizer::authorizerCredentialsArn)).setter(setter(Builder::authorizerCredentialsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerCredentialsArn").build())
            .build();

    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Authorizer::authorizerId)).setter(setter(Builder::authorizerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()).build();

    private static final SdkField<Integer> AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Authorizer::authorizerResultTtlInSeconds))
            .setter(setter(Builder::authorizerResultTtlInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerResultTtlInSeconds")
                    .build()).build();

    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Authorizer::authorizerTypeAsString)).setter(setter(Builder::authorizerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()).build();

    private static final SdkField<String> AUTHORIZER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Authorizer::authorizerUri)).setter(setter(Builder::authorizerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerUri").build()).build();

    private static final SdkField<List<String>> IDENTITY_SOURCE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Authorizer::identitySource))
            .setter(setter(Builder::identitySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDENTITY_VALIDATION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Authorizer::identityValidationExpression))
            .setter(setter(Builder::identityValidationExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityValidationExpression")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Authorizer::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> PROVIDER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Authorizer::providerArns))
            .setter(setter(Builder::providerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZER_CREDENTIALS_ARN_FIELD, AUTHORIZER_ID_FIELD, AUTHORIZER_RESULT_TTL_IN_SECONDS_FIELD, AUTHORIZER_TYPE_FIELD,
            AUTHORIZER_URI_FIELD, IDENTITY_SOURCE_FIELD, IDENTITY_VALIDATION_EXPRESSION_FIELD, NAME_FIELD, PROVIDER_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authorizerCredentialsArn;

    private final String authorizerId;

    private final Integer authorizerResultTtlInSeconds;

    private final String authorizerType;

    private final String authorizerUri;

    private final List<String> identitySource;

    private final String identityValidationExpression;

    private final String name;

    private final List<String> providerArns;

    private Authorizer(BuilderImpl builder) {
        this.authorizerCredentialsArn = builder.authorizerCredentialsArn;
        this.authorizerId = builder.authorizerId;
        this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
        this.authorizerType = builder.authorizerType;
        this.authorizerUri = builder.authorizerUri;
        this.identitySource = builder.identitySource;
        this.identityValidationExpression = builder.identityValidationExpression;
        this.name = builder.name;
        this.providerArns = builder.providerArns;
    }

    /**
     * <p>
     * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM
     * role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on
     * the Lambda function, specify null.
     * </p>
     * 
     * @return Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an
     *         IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based
     *         permissions on the Lambda function, specify null.
     */
    public String authorizerCredentialsArn() {
        return authorizerCredentialsArn;
    }

    /**
     * <p>
     * The authorizer identifier.
     * </p>
     * 
     * @return The authorizer identifier.
     */
    public String authorizerId() {
        return authorizerId;
    }

    /**
     * <p>
     * The time to live (TTL), in seconds, of cached authorizer results. If it equals 0, authorization caching is
     * disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the
     * default value is 300. The maximum value is 3600, or 1 hour.
     * </p>
     * 
     * @return The time to live (TTL), in seconds, of cached authorizer results. If it equals 0, authorization caching
     *         is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not
     *         set, the default value is 300. The maximum value is 3600, or 1 hour.
     */
    public Integer authorizerResultTtlInSeconds() {
        return authorizerResultTtlInSeconds;
    }

    /**
     * <p>
     * The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming request
     * parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming
     *         request parameters.
     * @see AuthorizerType
     */
    public AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(authorizerType);
    }

    /**
     * <p>
     * The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming request
     * parameters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming
     *         request parameters.
     * @see AuthorizerType
     */
    public String authorizerTypeAsString() {
        return authorizerType;
    }

    /**
     * <p>
     * The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed Lambda
     * function URI, for example,
     * arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:
     * {account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form:
     * arn:aws:apigateway:{region}:lambda:path/{service_api} , where {region} is the same as the region hosting the
     * Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the
     * resource, including the initial /. For Lambda functions, this is usually of the form
     * /2015-03-31/functions/[FunctionARN]/invocations.
     * </p>
     * 
     * @return The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed
     *         Lambda function URI, for example,
     *         arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda
     *         :us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form:
     *         arn:aws:apigateway:{region}:lambda:path/{service_api} , where {region} is the same as the region hosting
     *         the Lambda function, path indicates that the remaining substring in the URI should be treated as the path
     *         to the resource, including the initial /. For Lambda functions, this is usually of the form
     *         /2015-03-31/functions/[FunctionARN]/invocations.
     */
    public String authorizerUri() {
        return authorizerUri;
    }

    /**
     * <p>
     * The identity source for which authorization is requested.
     * </p>
     * <p>
     * For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a
     * comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an
     * Auth header and a Name query string parameters are defined as identity sources, this value is
     * method.request.header.Auth, method.request.querystring.Name. These parameters will be used to derive the
     * authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the
     * identity-related request parameters are present, not null, and non-empty. Only when this is true does the
     * authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without
     * calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified
     * request parameters. When the authorization caching is not enabled, this property is optional.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The identity source for which authorization is requested.</p>
     *         <p>
     *         For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a
     *         comma-separated string of one or more mapping expressions of the specified request parameters. For
     *         example, if an Auth header and a Name query string parameters are defined as identity sources, this value
     *         is method.request.header.Auth, method.request.querystring.Name. These parameters will be used to derive
     *         the authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying
     *         all of the identity-related request parameters are present, not null, and non-empty. Only when this is
     *         true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized
     *         response without calling the Lambda function. The valid value is a string of comma-separated mapping
     *         expressions of the specified request parameters. When the authorization caching is not enabled, this
     *         property is optional.
     */
    public List<String> identitySource() {
        return identitySource;
    }

    /**
     * <p>
     * The validation expression does not apply to the REQUEST authorizer.
     * </p>
     * 
     * @return The validation expression does not apply to the REQUEST authorizer.
     */
    public String identityValidationExpression() {
        return identityValidationExpression;
    }

    /**
     * <p>
     * The name of the authorizer.
     * </p>
     * 
     * @return The name of the authorizer.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * For REQUEST authorizer, this is not defined.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For REQUEST authorizer, this is not defined.
     */
    public List<String> providerArns() {
        return providerArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerCredentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerResultTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerUri());
        hashCode = 31 * hashCode + Objects.hashCode(identitySource());
        hashCode = 31 * hashCode + Objects.hashCode(identityValidationExpression());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(providerArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Authorizer)) {
            return false;
        }
        Authorizer other = (Authorizer) obj;
        return Objects.equals(authorizerCredentialsArn(), other.authorizerCredentialsArn())
                && Objects.equals(authorizerId(), other.authorizerId())
                && Objects.equals(authorizerResultTtlInSeconds(), other.authorizerResultTtlInSeconds())
                && Objects.equals(authorizerTypeAsString(), other.authorizerTypeAsString())
                && Objects.equals(authorizerUri(), other.authorizerUri())
                && Objects.equals(identitySource(), other.identitySource())
                && Objects.equals(identityValidationExpression(), other.identityValidationExpression())
                && Objects.equals(name(), other.name()) && Objects.equals(providerArns(), other.providerArns());
    }

    @Override
    public String toString() {
        return ToString.builder("Authorizer").add("AuthorizerCredentialsArn", authorizerCredentialsArn())
                .add("AuthorizerId", authorizerId()).add("AuthorizerResultTtlInSeconds", authorizerResultTtlInSeconds())
                .add("AuthorizerType", authorizerTypeAsString()).add("AuthorizerUri", authorizerUri())
                .add("IdentitySource", identitySource()).add("IdentityValidationExpression", identityValidationExpression())
                .add("Name", name()).add("ProviderArns", providerArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizerCredentialsArn":
            return Optional.ofNullable(clazz.cast(authorizerCredentialsArn()));
        case "AuthorizerId":
            return Optional.ofNullable(clazz.cast(authorizerId()));
        case "AuthorizerResultTtlInSeconds":
            return Optional.ofNullable(clazz.cast(authorizerResultTtlInSeconds()));
        case "AuthorizerType":
            return Optional.ofNullable(clazz.cast(authorizerTypeAsString()));
        case "AuthorizerUri":
            return Optional.ofNullable(clazz.cast(authorizerUri()));
        case "IdentitySource":
            return Optional.ofNullable(clazz.cast(identitySource()));
        case "IdentityValidationExpression":
            return Optional.ofNullable(clazz.cast(identityValidationExpression()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProviderArns":
            return Optional.ofNullable(clazz.cast(providerArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Authorizer, T> g) {
        return obj -> g.apply((Authorizer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Authorizer> {
        /**
         * <p>
         * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM
         * role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions
         * on the Lambda function, specify null.
         * </p>
         * 
         * @param authorizerCredentialsArn
         *        Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify
         *        an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use
         *        resource-based permissions on the Lambda function, specify null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerCredentialsArn(String authorizerCredentialsArn);

        /**
         * <p>
         * The authorizer identifier.
         * </p>
         * 
         * @param authorizerId
         *        The authorizer identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerId(String authorizerId);

        /**
         * <p>
         * The time to live (TTL), in seconds, of cached authorizer results. If it equals 0, authorization caching is
         * disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the
         * default value is 300. The maximum value is 3600, or 1 hour.
         * </p>
         * 
         * @param authorizerResultTtlInSeconds
         *        The time to live (TTL), in seconds, of cached authorizer results. If it equals 0, authorization
         *        caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this
         *        field is not set, the default value is 300. The maximum value is 3600, or 1 hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds);

        /**
         * <p>
         * The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming request
         * parameters.
         * </p>
         * 
         * @param authorizerType
         *        The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming
         *        request parameters.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(String authorizerType);

        /**
         * <p>
         * The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming request
         * parameters.
         * </p>
         * 
         * @param authorizerType
         *        The authorizer type. Currently the only valid value is REQUEST, for a Lambda function using incoming
         *        request parameters.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(AuthorizerType authorizerType);

        /**
         * <p>
         * The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed Lambda
         * function URI, for example,
         * arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west
         * -2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form:
         * arn:aws:apigateway:{region}:lambda:path/{service_api} , where {region} is the same as the region hosting the
         * Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the
         * resource, including the initial /. For Lambda functions, this is usually of the form
         * /2015-03-31/functions/[FunctionARN]/invocations.
         * </p>
         * 
         * @param authorizerUri
         *        The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers, this must be a well-formed
         *        Lambda function URI, for example,
         *        arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws
         *        :lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has
         *        this form: arn:aws:apigateway:{region}:lambda:path/{service_api} , where {region} is the same as the
         *        region hosting the Lambda function, path indicates that the remaining substring in the URI should be
         *        treated as the path to the resource, including the initial /. For Lambda functions, this is usually of
         *        the form /2015-03-31/functions/[FunctionARN]/invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerUri(String authorizerUri);

        /**
         * <p>
         * The identity source for which authorization is requested.
         * </p>
         * <p>
         * For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a
         * comma-separated string of one or more mapping expressions of the specified request parameters. For example,
         * if an Auth header and a Name query string parameters are defined as identity sources, this value is
         * method.request.header.Auth, method.request.querystring.Name. These parameters will be used to derive the
         * authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the
         * identity-related request parameters are present, not null, and non-empty. Only when this is true does the
         * authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without
         * calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the
         * specified request parameters. When the authorization caching is not enabled, this property is optional.
         * </p>
         * 
         * @param identitySource
         *        The identity source for which authorization is requested.</p>
         *        <p>
         *        For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a
         *        comma-separated string of one or more mapping expressions of the specified request parameters. For
         *        example, if an Auth header and a Name query string parameters are defined as identity sources, this
         *        value is method.request.header.Auth, method.request.querystring.Name. These parameters will be used to
         *        derive the authorization caching key and to perform runtime validation of the REQUEST authorizer by
         *        verifying all of the identity-related request parameters are present, not null, and non-empty. Only
         *        when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a
         *        401 Unauthorized response without calling the Lambda function. The valid value is a string of
         *        comma-separated mapping expressions of the specified request parameters. When the authorization
         *        caching is not enabled, this property is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySource(Collection<String> identitySource);

        /**
         * <p>
         * The identity source for which authorization is requested.
         * </p>
         * <p>
         * For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a
         * comma-separated string of one or more mapping expressions of the specified request parameters. For example,
         * if an Auth header and a Name query string parameters are defined as identity sources, this value is
         * method.request.header.Auth, method.request.querystring.Name. These parameters will be used to derive the
         * authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the
         * identity-related request parameters are present, not null, and non-empty. Only when this is true does the
         * authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without
         * calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the
         * specified request parameters. When the authorization caching is not enabled, this property is optional.
         * </p>
         * 
         * @param identitySource
         *        The identity source for which authorization is requested.</p>
         *        <p>
         *        For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a
         *        comma-separated string of one or more mapping expressions of the specified request parameters. For
         *        example, if an Auth header and a Name query string parameters are defined as identity sources, this
         *        value is method.request.header.Auth, method.request.querystring.Name. These parameters will be used to
         *        derive the authorization caching key and to perform runtime validation of the REQUEST authorizer by
         *        verifying all of the identity-related request parameters are present, not null, and non-empty. Only
         *        when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a
         *        401 Unauthorized response without calling the Lambda function. The valid value is a string of
         *        comma-separated mapping expressions of the specified request parameters. When the authorization
         *        caching is not enabled, this property is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySource(String... identitySource);

        /**
         * <p>
         * The validation expression does not apply to the REQUEST authorizer.
         * </p>
         * 
         * @param identityValidationExpression
         *        The validation expression does not apply to the REQUEST authorizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityValidationExpression(String identityValidationExpression);

        /**
         * <p>
         * The name of the authorizer.
         * </p>
         * 
         * @param name
         *        The name of the authorizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * For REQUEST authorizer, this is not defined.
         * </p>
         * 
         * @param providerArns
         *        For REQUEST authorizer, this is not defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerArns(Collection<String> providerArns);

        /**
         * <p>
         * For REQUEST authorizer, this is not defined.
         * </p>
         * 
         * @param providerArns
         *        For REQUEST authorizer, this is not defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerArns(String... providerArns);
    }

    static final class BuilderImpl implements Builder {
        private String authorizerCredentialsArn;

        private String authorizerId;

        private Integer authorizerResultTtlInSeconds;

        private String authorizerType;

        private String authorizerUri;

        private List<String> identitySource = DefaultSdkAutoConstructList.getInstance();

        private String identityValidationExpression;

        private String name;

        private List<String> providerArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Authorizer model) {
            authorizerCredentialsArn(model.authorizerCredentialsArn);
            authorizerId(model.authorizerId);
            authorizerResultTtlInSeconds(model.authorizerResultTtlInSeconds);
            authorizerType(model.authorizerType);
            authorizerUri(model.authorizerUri);
            identitySource(model.identitySource);
            identityValidationExpression(model.identityValidationExpression);
            name(model.name);
            providerArns(model.providerArns);
        }

        public final String getAuthorizerCredentialsArn() {
            return authorizerCredentialsArn;
        }

        @Override
        public final Builder authorizerCredentialsArn(String authorizerCredentialsArn) {
            this.authorizerCredentialsArn = authorizerCredentialsArn;
            return this;
        }

        public final void setAuthorizerCredentialsArn(String authorizerCredentialsArn) {
            this.authorizerCredentialsArn = authorizerCredentialsArn;
        }

        public final String getAuthorizerId() {
            return authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Integer getAuthorizerResultTtlInSeconds() {
            return authorizerResultTtlInSeconds;
        }

        @Override
        public final Builder authorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        public final void setAuthorizerResultTtlInSeconds(Integer authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
        }

        public final String getAuthorizerTypeAsString() {
            return authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType.toString());
            return this;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        public final String getAuthorizerUri() {
            return authorizerUri;
        }

        @Override
        public final Builder authorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        public final void setAuthorizerUri(String authorizerUri) {
            this.authorizerUri = authorizerUri;
        }

        public final Collection<String> getIdentitySource() {
            return identitySource;
        }

        @Override
        public final Builder identitySource(Collection<String> identitySource) {
            this.identitySource = IdentitySourceListCopier.copy(identitySource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identitySource(String... identitySource) {
            identitySource(Arrays.asList(identitySource));
            return this;
        }

        public final void setIdentitySource(Collection<String> identitySource) {
            this.identitySource = IdentitySourceListCopier.copy(identitySource);
        }

        public final String getIdentityValidationExpression() {
            return identityValidationExpression;
        }

        @Override
        public final Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        public final void setIdentityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getProviderArns() {
            return providerArns;
        }

        @Override
        public final Builder providerArns(Collection<String> providerArns) {
            this.providerArns = ProviderArnListCopier.copy(providerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerArns(String... providerArns) {
            providerArns(Arrays.asList(providerArns));
            return this;
        }

        public final void setProviderArns(Collection<String> providerArns) {
            this.providerArns = ProviderArnListCopier.copy(providerArns);
        }

        @Override
        public Authorizer build() {
            return new Authorizer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
