/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntegrationRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<CreateIntegrationRequest.Builder, CreateIntegrationRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::connectionTypeAsString)).setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();

    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::contentHandlingStrategyAsString))
            .setter(setter(Builder::contentHandlingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build())
            .build();

    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::credentialsArn)).setter(setter(Builder::credentialsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INTEGRATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::integrationMethod)).setter(setter(Builder::integrationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationMethod").build()).build();

    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::integrationTypeAsString)).setter(setter(Builder::integrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()).build();

    private static final SdkField<String> INTEGRATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::integrationUri)).setter(setter(Builder::integrationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationUri").build()).build();

    private static final SdkField<String> PASSTHROUGH_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::passthroughBehaviorAsString)).setter(setter(Builder::passthroughBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughBehavior").build())
            .build();

    private static final SdkField<Map<String, String>> REQUEST_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateIntegrationRequest::requestParameters))
            .setter(setter(Builder::requestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REQUEST_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateIntegrationRequest::requestTemplates))
            .setter(setter(Builder::requestTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateIntegrationRequest::templateSelectionExpression))
            .setter(setter(Builder::templateSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression")
                    .build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateIntegrationRequest::timeoutInMillis)).setter(setter(Builder::timeoutInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            CONNECTION_ID_FIELD, CONNECTION_TYPE_FIELD, CONTENT_HANDLING_STRATEGY_FIELD, CREDENTIALS_ARN_FIELD,
            DESCRIPTION_FIELD, INTEGRATION_METHOD_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_URI_FIELD,
            PASSTHROUGH_BEHAVIOR_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_TEMPLATES_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD,
            TIMEOUT_IN_MILLIS_FIELD));

    private final String apiId;

    private final String connectionId;

    private final String connectionType;

    private final String contentHandlingStrategy;

    private final String credentialsArn;

    private final String description;

    private final String integrationMethod;

    private final String integrationType;

    private final String integrationUri;

    private final String passthroughBehavior;

    private final Map<String, String> requestParameters;

    private final Map<String, String> requestTemplates;

    private final String templateSelectionExpression;

    private final Integer timeoutInMillis;

    private CreateIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.connectionId = builder.connectionId;
        this.connectionType = builder.connectionType;
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.integrationMethod = builder.integrationMethod;
        this.integrationType = builder.integrationType;
        this.integrationUri = builder.integrationUri;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.templateSelectionExpression = builder.templateSelectionExpression;
        this.timeoutInMillis = builder.timeoutInMillis;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The identifier of the VpcLink used for the integration when the connectionType is VPC_LINK; otherwise undefined.
     * </p>
     * 
     * @return The identifier of the VpcLink used for the integration when the connectionType is VPC_LINK; otherwise
     *         undefined.
     */
    public String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections
     * through the public routable internet or VPC_LINK for private connections between API Gateway and a network load
     * balancer in a VPC. The default value is INTERNET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the network connection to the integration endpoint. The valid value is INTERNET for
     *         connections through the public routable internet or VPC_LINK for private connections between API Gateway
     *         and a network load balancer in a VPC. The default value is INTERNET.
     * @see ConnectionType
     */
    public ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections
     * through the public routable internet or VPC_LINK for private connections between API Gateway and a network load
     * balancer in a VPC. The default value is INTERNET.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the network connection to the integration endpoint. The valid value is INTERNET for
     *         connections through the public routable internet or VPC_LINK for private connections between API Gateway
     *         and a network load balancer in a VPC. The default value is INTERNET.
     * @see ConnectionType
     */
    public String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and
     * CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY
     *         and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(contentHandlingStrategy);
    }

    /**
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and
     * CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY
     *         and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public String contentHandlingStrategyAsString() {
        return contentHandlingStrategy;
    }

    /**
     * <p>
     * Specifies the credentials required for the integration, if any. For AWS integrations, three options are
     * available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To
     * require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*.
     * To use resource-based permissions on supported AWS services, specify null.
     * </p>
     * 
     * @return Specifies the credentials required for the integration, if any. For AWS integrations, three options are
     *         available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN).
     *         To require that the caller's identity be passed through from the request, specify the string
     *         arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.
     */
    public String credentialsArn() {
        return credentialsArn;
    }

    /**
     * <p>
     * The description of the integration.
     * </p>
     * 
     * @return The description of the integration.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the integration's HTTP method type.
     * </p>
     * 
     * @return Specifies the integration's HTTP method type.
     */
    public String integrationMethod() {
        return integrationMethod;
    }

    /**
     * <p>
     * The integration type of an integration. One of the following:
     * </p>
     * <p>
     * AWS: for integrating the route or method request with an AWS service action, including the Lambda
     * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
     * integration. With any other AWS service action, this is known as AWS integration.
     * </p>
     * <p>
     * AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client
     * request passed through as-is. This integration is also referred to as Lambda proxy integration.
     * </p>
     * <p>
     * HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP endpoint within
     * a VPC. This integration is also referred to as the HTTP custom integration.
     * </p>
     * <p>
     * HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP endpoint
     * within a VPC, with the client request passed through as-is. This is also referred to as HTTP proxy integration.
     * </p>
     * <p>
     * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any
     * backend.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The integration type of an integration. One of the following:</p>
     *         <p>
     *         AWS: for integrating the route or method request with an AWS service action, including the Lambda
     *         function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
     *         custom integration. With any other AWS service action, this is known as AWS integration.
     *         </p>
     *         <p>
     *         AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the
     *         client request passed through as-is. This integration is also referred to as Lambda proxy integration.
     *         </p>
     *         <p>
     *         HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP
     *         endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
     *         </p>
     *         <p>
     *         HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP
     *         endpoint within a VPC, with the client request passed through as-is. This is also referred to as HTTP
     *         proxy integration.
     *         </p>
     *         <p>
     *         MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
     *         invoking any backend.
     * @see IntegrationType
     */
    public IntegrationType integrationType() {
        return IntegrationType.fromValue(integrationType);
    }

    /**
     * <p>
     * The integration type of an integration. One of the following:
     * </p>
     * <p>
     * AWS: for integrating the route or method request with an AWS service action, including the Lambda
     * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
     * integration. With any other AWS service action, this is known as AWS integration.
     * </p>
     * <p>
     * AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the client
     * request passed through as-is. This integration is also referred to as Lambda proxy integration.
     * </p>
     * <p>
     * HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP endpoint within
     * a VPC. This integration is also referred to as the HTTP custom integration.
     * </p>
     * <p>
     * HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP endpoint
     * within a VPC, with the client request passed through as-is. This is also referred to as HTTP proxy integration.
     * </p>
     * <p>
     * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any
     * backend.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationType}
     * will return {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationTypeAsString}.
     * </p>
     * 
     * @return The integration type of an integration. One of the following:</p>
     *         <p>
     *         AWS: for integrating the route or method request with an AWS service action, including the Lambda
     *         function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
     *         custom integration. With any other AWS service action, this is known as AWS integration.
     *         </p>
     *         <p>
     *         AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the
     *         client request passed through as-is. This integration is also referred to as Lambda proxy integration.
     *         </p>
     *         <p>
     *         HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP
     *         endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
     *         </p>
     *         <p>
     *         HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP
     *         endpoint within a VPC, with the client request passed through as-is. This is also referred to as HTTP
     *         proxy integration.
     *         </p>
     *         <p>
     *         MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
     *         invoking any backend.
     * @see IntegrationType
     */
    public String integrationTypeAsString() {
        return integrationType;
    }

    /**
     * <p>
     * Specifies the Uniform Resource Identifier (URI) of the integration endpoint.
     * </p>
     * <p>
     * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a
     * href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard
     * integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For
     * a private HTTP integration, the URI is not used for routing.
     * </p>
     * <p>
     * For AWS or AWS_PROXY integrations, the URI is of the form
     * arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API
     * Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain}
     * is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an
     * AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api}
     * refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an
     * AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the
     * region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject,
     * the URI can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or
     * arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
     * </p>
     * 
     * @return Specifies the Uniform Resource Identifier (URI) of the integration endpoint.</p>
     *         <p>
     *         For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the
     *         <a href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for
     *         either standard integration, where connectionType is not VPC_LINK, or private integration, where
     *         connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
     *         </p>
     *         <p>
     *         For AWS or AWS_PROXY integrations, the URI is of the form
     *         arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the
     *         API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and
     *         {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action
     *         can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query
     *         string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters.
     *         Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the
     *         path to an AWS service resource, including the region of the integrated AWS service, if applicable. For
     *         example, for integration with the S3 API of GetObject, the URI can be either
     *         arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or
     *         arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
     */
    public String integrationUri() {
        return integrationUri;
    }

    /**
     * <p>
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and
     * the available mapping templates specified as the requestTemplates property on the Integration resource. There are
     * three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
     * </p>
     * <p>
     * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
     * transformation.
     * </p>
     * <p>
     * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     * </p>
     * <p>
     * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if
     * there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
     * Unsupported Media Type response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #passthroughBehavior} will return {@link PassthroughBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #passthroughBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
     *         request, and the available mapping templates specified as the requestTemplates property on the
     *         Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.</p>
     *         <p>
     *         WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
     *         without transformation.
     *         </p>
     *         <p>
     *         NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     *         </p>
     *         <p>
     *         WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
     *         However, if there is at least one content type defined, unmapped content types will be rejected with the
     *         same HTTP 415 Unsupported Media Type response.
     * @see PassthroughBehavior
     */
    public PassthroughBehavior passthroughBehavior() {
        return PassthroughBehavior.fromValue(passthroughBehavior);
    }

    /**
     * <p>
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and
     * the available mapping templates specified as the requestTemplates property on the Integration resource. There are
     * three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
     * </p>
     * <p>
     * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
     * transformation.
     * </p>
     * <p>
     * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     * </p>
     * <p>
     * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if
     * there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
     * Unsupported Media Type response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #passthroughBehavior} will return {@link PassthroughBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #passthroughBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
     *         request, and the available mapping templates specified as the requestTemplates property on the
     *         Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.</p>
     *         <p>
     *         WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
     *         without transformation.
     *         </p>
     *         <p>
     *         NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     *         </p>
     *         <p>
     *         WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
     *         However, if there is at least one content type defined, unmapped content types will be rejected with the
     *         same HTTP 415 Unsupported Media Type response.
     * @see PassthroughBehavior
     */
    public String passthroughBehaviorAsString() {
        return passthroughBehavior;
    }

    /**
     * <p>
     * A key-value map specifying request parameters that are passed from the method request to the backend. The key is
     * an integration request parameter name and the associated value is a method request parameter value or static
     * value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request
     * parameter value must match the pattern of method.request.{location}.{name} , where {location} is querystring,
     * path, or header; and {name} must be a valid and unique method request parameter name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A key-value map specifying request parameters that are passed from the method request to the backend. The
     *         key is an integration request parameter name and the associated value is a method request parameter value
     *         or static value that must be enclosed within single quotes and pre-encoded as required by the backend.
     *         The method request parameter value must match the pattern of method.request.{location}.{name} , where
     *         {location} is querystring, path, or header; and {name} must be a valid and unique method request
     *         parameter name.
     */
    public Map<String, String> requestParameters() {
        return requestParameters;
    }

    /**
     * <p>
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the
     * Content-Type header sent by the client. The content type value is the key in this map, and the template (as a
     * String) is the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents a map of Velocity templates that are applied on the request payload based on the value of the
     *         Content-Type header sent by the client. The content type value is the key in this map, and the template
     *         (as a String) is the value.
     */
    public Map<String, String> requestTemplates() {
        return requestTemplates;
    }

    /**
     * <p>
     * The template selection expression for the integration.
     * </p>
     * 
     * @return The template selection expression for the integration.
     */
    public String templateSelectionExpression() {
        return templateSelectionExpression;
    }

    /**
     * <p>
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
     * </p>
     * 
     * @return Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29
     *         seconds.
     */
    public Integer timeoutInMillis() {
        return timeoutInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(integrationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationUri());
        hashCode = 31 * hashCode + Objects.hashCode(passthroughBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(requestTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(templateSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMillis());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationRequest)) {
            return false;
        }
        CreateIntegrationRequest other = (CreateIntegrationRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString())
                && Objects.equals(credentialsArn(), other.credentialsArn()) && Objects.equals(description(), other.description())
                && Objects.equals(integrationMethod(), other.integrationMethod())
                && Objects.equals(integrationTypeAsString(), other.integrationTypeAsString())
                && Objects.equals(integrationUri(), other.integrationUri())
                && Objects.equals(passthroughBehaviorAsString(), other.passthroughBehaviorAsString())
                && Objects.equals(requestParameters(), other.requestParameters())
                && Objects.equals(requestTemplates(), other.requestTemplates())
                && Objects.equals(templateSelectionExpression(), other.templateSelectionExpression())
                && Objects.equals(timeoutInMillis(), other.timeoutInMillis());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateIntegrationRequest").add("ApiId", apiId()).add("ConnectionId", connectionId())
                .add("ConnectionType", connectionTypeAsString())
                .add("ContentHandlingStrategy", contentHandlingStrategyAsString()).add("CredentialsArn", credentialsArn())
                .add("Description", description()).add("IntegrationMethod", integrationMethod())
                .add("IntegrationType", integrationTypeAsString()).add("IntegrationUri", integrationUri())
                .add("PassthroughBehavior", passthroughBehaviorAsString()).add("RequestParameters", requestParameters())
                .add("RequestTemplates", requestTemplates()).add("TemplateSelectionExpression", templateSelectionExpression())
                .add("TimeoutInMillis", timeoutInMillis()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "ContentHandlingStrategy":
            return Optional.ofNullable(clazz.cast(contentHandlingStrategyAsString()));
        case "CredentialsArn":
            return Optional.ofNullable(clazz.cast(credentialsArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IntegrationMethod":
            return Optional.ofNullable(clazz.cast(integrationMethod()));
        case "IntegrationType":
            return Optional.ofNullable(clazz.cast(integrationTypeAsString()));
        case "IntegrationUri":
            return Optional.ofNullable(clazz.cast(integrationUri()));
        case "PassthroughBehavior":
            return Optional.ofNullable(clazz.cast(passthroughBehaviorAsString()));
        case "RequestParameters":
            return Optional.ofNullable(clazz.cast(requestParameters()));
        case "RequestTemplates":
            return Optional.ofNullable(clazz.cast(requestTemplates()));
        case "TemplateSelectionExpression":
            return Optional.ofNullable(clazz.cast(templateSelectionExpression()));
        case "TimeoutInMillis":
            return Optional.ofNullable(clazz.cast(timeoutInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateIntegrationRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The identifier of the VpcLink used for the integration when the connectionType is VPC_LINK; otherwise
         * undefined.
         * </p>
         * 
         * @param connectionId
         *        The identifier of the VpcLink used for the integration when the connectionType is VPC_LINK; otherwise
         *        undefined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections
         * through the public routable internet or VPC_LINK for private connections between API Gateway and a network
         * load balancer in a VPC. The default value is INTERNET.
         * </p>
         * 
         * @param connectionType
         *        The type of the network connection to the integration endpoint. The valid value is INTERNET for
         *        connections through the public routable internet or VPC_LINK for private connections between API
         *        Gateway and a network load balancer in a VPC. The default value is INTERNET.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections
         * through the public routable internet or VPC_LINK for private connections between API Gateway and a network
         * load balancer in a VPC. The default value is INTERNET.
         * </p>
         * 
         * @param connectionType
         *        The type of the network connection to the integration endpoint. The valid value is INTERNET for
         *        connections through the public routable internet or VPC_LINK for private connections between API
         *        Gateway and a network load balancer in a VPC. The default value is INTERNET.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and
         * CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Specifies how to handle response payload content type conversions. Supported values are
         *        CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(String contentHandlingStrategy);

        /**
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and
         * CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Specifies how to handle response payload content type conversions. Supported values are
         *        CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy);

        /**
         * <p>
         * Specifies the credentials required for the integration, if any. For AWS integrations, three options are
         * available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To
         * require that the caller's identity be passed through from the request, specify the string
         * arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.
         * </p>
         * 
         * @param credentialsArn
         *        Specifies the credentials required for the integration, if any. For AWS integrations, three options
         *        are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name
         *        (ARN). To require that the caller's identity be passed through from the request, specify the string
         *        arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsArn(String credentialsArn);

        /**
         * <p>
         * The description of the integration.
         * </p>
         * 
         * @param description
         *        The description of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the integration's HTTP method type.
         * </p>
         * 
         * @param integrationMethod
         *        Specifies the integration's HTTP method type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationMethod(String integrationMethod);

        /**
         * <p>
         * The integration type of an integration. One of the following:
         * </p>
         * <p>
         * AWS: for integrating the route or method request with an AWS service action, including the Lambda
         * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
         * integration. With any other AWS service action, this is known as AWS integration.
         * </p>
         * <p>
         * AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the
         * client request passed through as-is. This integration is also referred to as Lambda proxy integration.
         * </p>
         * <p>
         * HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP endpoint
         * within a VPC. This integration is also referred to as the HTTP custom integration.
         * </p>
         * <p>
         * HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP endpoint
         * within a VPC, with the client request passed through as-is. This is also referred to as HTTP proxy
         * integration.
         * </p>
         * <p>
         * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking
         * any backend.
         * </p>
         * 
         * @param integrationType
         *        The integration type of an integration. One of the following:</p>
         *        <p>
         *        AWS: for integrating the route or method request with an AWS service action, including the Lambda
         *        function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
         *        custom integration. With any other AWS service action, this is known as AWS integration.
         *        </p>
         *        <p>
         *        AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with
         *        the client request passed through as-is. This integration is also referred to as Lambda proxy
         *        integration.
         *        </p>
         *        <p>
         *        HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP
         *        endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
         *        </p>
         *        <p>
         *        HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP
         *        endpoint within a VPC, with the client request passed through as-is. This is also referred to as HTTP
         *        proxy integration.
         *        </p>
         *        <p>
         *        MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
         *        invoking any backend.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(String integrationType);

        /**
         * <p>
         * The integration type of an integration. One of the following:
         * </p>
         * <p>
         * AWS: for integrating the route or method request with an AWS service action, including the Lambda
         * function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom
         * integration. With any other AWS service action, this is known as AWS integration.
         * </p>
         * <p>
         * AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with the
         * client request passed through as-is. This integration is also referred to as Lambda proxy integration.
         * </p>
         * <p>
         * HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP endpoint
         * within a VPC. This integration is also referred to as the HTTP custom integration.
         * </p>
         * <p>
         * HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP endpoint
         * within a VPC, with the client request passed through as-is. This is also referred to as HTTP proxy
         * integration.
         * </p>
         * <p>
         * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking
         * any backend.
         * </p>
         * 
         * @param integrationType
         *        The integration type of an integration. One of the following:</p>
         *        <p>
         *        AWS: for integrating the route or method request with an AWS service action, including the Lambda
         *        function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda
         *        custom integration. With any other AWS service action, this is known as AWS integration.
         *        </p>
         *        <p>
         *        AWS_PROXY: for integrating the route or method request with the Lambda function-invoking action with
         *        the client request passed through as-is. This integration is also referred to as Lambda proxy
         *        integration.
         *        </p>
         *        <p>
         *        HTTP: for integrating the route or method request with an HTTP endpoint, including a private HTTP
         *        endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
         *        </p>
         *        <p>
         *        HTTP_PROXY: for integrating route or method request with an HTTP endpoint, including a private HTTP
         *        endpoint within a VPC, with the client request passed through as-is. This is also referred to as HTTP
         *        proxy integration.
         *        </p>
         *        <p>
         *        MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without
         *        invoking any backend.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder integrationType(IntegrationType integrationType);

        /**
         * <p>
         * Specifies the Uniform Resource Identifier (URI) of the integration endpoint.
         * </p>
         * <p>
         * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a
         * href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either
         * standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is
         * VPC_LINK. For a private HTTP integration, the URI is not used for routing.
         * </p>
         * <p>
         * For AWS or AWS_PROXY integrations, the URI is of the form
         * arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API
         * Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and
         * {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can
         * be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The
         * ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively,
         * path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS
         * service resource, including the region of the integrated AWS service, if applicable. For example, for
         * integration with the S3 API of GetObject, the URI can be either
         * arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or
         * arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
         * </p>
         * 
         * @param integrationUri
         *        Specifies the Uniform Resource Identifier (URI) of the integration endpoint.</p>
         *        <p>
         *        For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to
         *        the <a href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>,
         *        for either standard integration, where connectionType is not VPC_LINK, or private integration, where
         *        connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
         *        </p>
         *        <p>
         *        For AWS or AWS_PROXY integrations, the URI is of the form
         *        arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is
         *        the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g.,
         *        s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name
         *        lookup. action can be used for an AWS service action-based API, using an
         *        Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported
         *        action {name} plus any required input parameters. Alternatively, path can be used for an AWS service
         *        path-based API. The ensuing service_api refers to the path to an AWS service resource, including the
         *        region of the integrated AWS service, if applicable. For example, for integration with the S3 API of
         *        GetObject, the URI can be either
         *        arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or
         *        arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationUri(String integrationUri);

        /**
         * <p>
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request,
         * and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         * </p>
         * <p>
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
         * transformation.
         * </p>
         * <p>
         * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         * </p>
         * <p>
         * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However,
         * if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
         * Unsupported Media Type response.
         * </p>
         * 
         * @param passthroughBehavior
         *        Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
         *        request, and the available mapping templates specified as the requestTemplates property on the
         *        Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.</p>
         *        <p>
         *        WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
         *        without transformation.
         *        </p>
         *        <p>
         *        NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         *        </p>
         *        <p>
         *        WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
         *        However, if there is at least one content type defined, unmapped content types will be rejected with
         *        the same HTTP 415 Unsupported Media Type response.
         * @see PassthroughBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PassthroughBehavior
         */
        Builder passthroughBehavior(String passthroughBehavior);

        /**
         * <p>
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request,
         * and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         * </p>
         * <p>
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without
         * transformation.
         * </p>
         * <p>
         * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         * </p>
         * <p>
         * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However,
         * if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415
         * Unsupported Media Type response.
         * </p>
         * 
         * @param passthroughBehavior
         *        Specifies the pass-through behavior for incoming requests based on the Content-Type header in the
         *        request, and the available mapping templates specified as the requestTemplates property on the
         *        Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.</p>
         *        <p>
         *        WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend
         *        without transformation.
         *        </p>
         *        <p>
         *        NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         *        </p>
         *        <p>
         *        WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates.
         *        However, if there is at least one content type defined, unmapped content types will be rejected with
         *        the same HTTP 415 Unsupported Media Type response.
         * @see PassthroughBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PassthroughBehavior
         */
        Builder passthroughBehavior(PassthroughBehavior passthroughBehavior);

        /**
         * <p>
         * A key-value map specifying request parameters that are passed from the method request to the backend. The key
         * is an integration request parameter name and the associated value is a method request parameter value or
         * static value that must be enclosed within single quotes and pre-encoded as required by the backend. The
         * method request parameter value must match the pattern of method.request.{location}.{name} , where {location}
         * is querystring, path, or header; and {name} must be a valid and unique method request parameter name.
         * </p>
         * 
         * @param requestParameters
         *        A key-value map specifying request parameters that are passed from the method request to the backend.
         *        The key is an integration request parameter name and the associated value is a method request
         *        parameter value or static value that must be enclosed within single quotes and pre-encoded as required
         *        by the backend. The method request parameter value must match the pattern of
         *        method.request.{location}.{name} , where {location} is querystring, path, or header; and {name} must
         *        be a valid and unique method request parameter name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestParameters(Map<String, String> requestParameters);

        /**
         * <p>
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the
         * Content-Type header sent by the client. The content type value is the key in this map, and the template (as a
         * String) is the value.
         * </p>
         * 
         * @param requestTemplates
         *        Represents a map of Velocity templates that are applied on the request payload based on the value of
         *        the Content-Type header sent by the client. The content type value is the key in this map, and the
         *        template (as a String) is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTemplates(Map<String, String> requestTemplates);

        /**
         * <p>
         * The template selection expression for the integration.
         * </p>
         * 
         * @param templateSelectionExpression
         *        The template selection expression for the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSelectionExpression(String templateSelectionExpression);

        /**
         * <p>
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         * </p>
         * 
         * @param timeoutInMillis
         *        Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMillis(Integer timeoutInMillis);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String connectionId;

        private String connectionType;

        private String contentHandlingStrategy;

        private String credentialsArn;

        private String description;

        private String integrationMethod;

        private String integrationType;

        private String integrationUri;

        private String passthroughBehavior;

        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();

        private String templateSelectionExpression;

        private Integer timeoutInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationRequest model) {
            super(model);
            apiId(model.apiId);
            connectionId(model.connectionId);
            connectionType(model.connectionType);
            contentHandlingStrategy(model.contentHandlingStrategy);
            credentialsArn(model.credentialsArn);
            description(model.description);
            integrationMethod(model.integrationMethod);
            integrationType(model.integrationType);
            integrationUri(model.integrationUri);
            passthroughBehavior(model.passthroughBehavior);
            requestParameters(model.requestParameters);
            requestTemplates(model.requestTemplates);
            templateSelectionExpression(model.templateSelectionExpression);
            timeoutInMillis(model.timeoutInMillis);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getConnectionTypeAsString() {
            return connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final String getContentHandlingStrategyAsString() {
            return contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy.toString());
            return this;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        public final String getCredentialsArn() {
            return credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIntegrationMethod() {
            return integrationMethod;
        }

        @Override
        public final Builder integrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
            return this;
        }

        public final void setIntegrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
        }

        public final String getIntegrationTypeAsString() {
            return integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType.toString());
            return this;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        public final String getIntegrationUri() {
            return integrationUri;
        }

        @Override
        public final Builder integrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        public final void setIntegrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
        }

        public final String getPassthroughBehaviorAsString() {
            return passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        @Override
        public final Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior(passthroughBehavior.toString());
            return this;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        public final Map<String, String> getRequestParameters() {
            return requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestTemplates() {
            return requestTemplates;
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
            return this;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
        }

        public final String getTemplateSelectionExpression() {
            return templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        public final Integer getTimeoutInMillis() {
            return timeoutInMillis;
        }

        @Override
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationRequest build() {
            return new CreateIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
