/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiMappingRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<GetApiMappingRequest.Builder, GetApiMappingRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApiMappingRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("apiId").build()).build();

    private static final SdkField<String> API_MAPPING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApiMappingRequest::apiMappingId)).setter(setter(Builder::apiMappingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiMappingId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetApiMappingRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            API_MAPPING_ID_FIELD, DOMAIN_NAME_FIELD));

    private final String apiId;

    private final String apiMappingId;

    private final String domainName;

    private GetApiMappingRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiMappingId = builder.apiMappingId;
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * The identifier of the API.
     * </p>
     * 
     * @return The identifier of the API.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The API mapping identifier.
     * </p>
     * 
     * @return The API mapping identifier.
     */
    public String apiMappingId() {
        return apiMappingId;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiMappingId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiMappingRequest)) {
            return false;
        }
        GetApiMappingRequest other = (GetApiMappingRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(apiMappingId(), other.apiMappingId())
                && Objects.equals(domainName(), other.domainName());
    }

    @Override
    public String toString() {
        return ToString.builder("GetApiMappingRequest").add("ApiId", apiId()).add("ApiMappingId", apiMappingId())
                .add("DomainName", domainName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiMappingId":
            return Optional.ofNullable(clazz.cast(apiMappingId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiMappingRequest, T> g) {
        return obj -> g.apply((GetApiMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetApiMappingRequest> {
        /**
         * <p>
         * The identifier of the API.
         * </p>
         * 
         * @param apiId
         *        The identifier of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The API mapping identifier.
         * </p>
         * 
         * @param apiMappingId
         *        The API mapping identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiMappingId(String apiMappingId);

        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String apiMappingId;

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiMappingRequest model) {
            super(model);
            apiId(model.apiId);
            apiMappingId(model.apiMappingId);
            domainName(model.domainName);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiMappingId() {
            return apiMappingId;
        }

        @Override
        public final Builder apiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
            return this;
        }

        public final void setApiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiMappingRequest build() {
            return new GetApiMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
