/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouteResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetRouteResponse.Builder, GetRouteResponse> {
    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetRouteResponse::apiKeyRequired)).setter(setter(Builder::apiKeyRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()).build();

    private static final SdkField<List<String>> AUTHORIZATION_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetRouteResponse::authorizationScopes))
            .setter(setter(Builder::authorizationScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::authorizationTypeAsString)).setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()).build();

    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::authorizerId)).setter(setter(Builder::authorizerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()).build();

    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::modelSelectionExpression)).setter(setter(Builder::modelSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build())
            .build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::operationName)).setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()).build();

    private static final SdkField<Map<String, String>> REQUEST_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetRouteResponse::requestModels))
            .setter(setter(Builder::requestModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ParameterConstraints>> REQUEST_PARAMETERS_FIELD = SdkField
            .<Map<String, ParameterConstraints>> builder(MarshallingType.MAP)
            .getter(getter(GetRouteResponse::requestParameters))
            .setter(setter(Builder::requestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ParameterConstraints> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterConstraints::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::routeId)).setter(setter(Builder::routeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeId").build()).build();

    private static final SdkField<String> ROUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::routeKey)).setter(setter(Builder::routeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeKey").build()).build();

    private static final SdkField<String> ROUTE_RESPONSE_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::routeResponseSelectionExpression))
            .setter(setter(Builder::routeResponseSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseSelectionExpression")
                    .build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRouteResponse::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_REQUIRED_FIELD,
            AUTHORIZATION_SCOPES_FIELD, AUTHORIZATION_TYPE_FIELD, AUTHORIZER_ID_FIELD, MODEL_SELECTION_EXPRESSION_FIELD,
            OPERATION_NAME_FIELD, REQUEST_MODELS_FIELD, REQUEST_PARAMETERS_FIELD, ROUTE_ID_FIELD, ROUTE_KEY_FIELD,
            ROUTE_RESPONSE_SELECTION_EXPRESSION_FIELD, TARGET_FIELD));

    private final Boolean apiKeyRequired;

    private final List<String> authorizationScopes;

    private final String authorizationType;

    private final String authorizerId;

    private final String modelSelectionExpression;

    private final String operationName;

    private final Map<String, String> requestModels;

    private final Map<String, ParameterConstraints> requestParameters;

    private final String routeId;

    private final String routeKey;

    private final String routeResponseSelectionExpression;

    private final String target;

    private GetRouteResponse(BuilderImpl builder) {
        super(builder);
        this.apiKeyRequired = builder.apiKeyRequired;
        this.authorizationScopes = builder.authorizationScopes;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.operationName = builder.operationName;
        this.requestModels = builder.requestModels;
        this.requestParameters = builder.requestParameters;
        this.routeId = builder.routeId;
        this.routeKey = builder.routeKey;
        this.routeResponseSelectionExpression = builder.routeResponseSelectionExpression;
        this.target = builder.target;
    }

    /**
     * <p>
     * Specifies whether an API key is required for this route.
     * </p>
     * 
     * @return Specifies whether an API key is required for this route.
     */
    public Boolean apiKeyRequired() {
        return apiKeyRequired;
    }

    /**
     * <p>
     * The authorization scopes supported by this route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The authorization scopes supported by this route.
     */
    public List<String> authorizationScopes() {
        return authorizationScopes;
    }

    /**
     * <p>
     * The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
     * permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link AuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
     *         permissions.
     * @see AuthorizationType
     */
    public AuthorizationType authorizationType() {
        return AuthorizationType.fromValue(authorizationType);
    }

    /**
     * <p>
     * The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
     * permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link AuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
     *         permissions.
     * @see AuthorizationType
     */
    public String authorizationTypeAsString() {
        return authorizationType;
    }

    /**
     * <p>
     * The identifier of the Authorizer resource to be associated with this route.
     * </p>
     * 
     * @return The identifier of the Authorizer resource to be associated with this route.
     */
    public String authorizerId() {
        return authorizerId;
    }

    /**
     * <p>
     * The model selection expression for the route.
     * </p>
     * 
     * @return The model selection expression for the route.
     */
    public String modelSelectionExpression() {
        return modelSelectionExpression;
    }

    /**
     * <p>
     * The operation name for the route.
     * </p>
     * 
     * @return The operation name for the route.
     */
    public String operationName() {
        return operationName;
    }

    /**
     * <p>
     * The request models for the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The request models for the route.
     */
    public Map<String, String> requestModels() {
        return requestModels;
    }

    /**
     * <p>
     * The request parameters for the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The request parameters for the route.
     */
    public Map<String, ParameterConstraints> requestParameters() {
        return requestParameters;
    }

    /**
     * <p>
     * The route ID.
     * </p>
     * 
     * @return The route ID.
     */
    public String routeId() {
        return routeId;
    }

    /**
     * <p>
     * The route key for the route.
     * </p>
     * 
     * @return The route key for the route.
     */
    public String routeKey() {
        return routeKey;
    }

    /**
     * <p>
     * The route response selection expression for the route.
     * </p>
     * 
     * @return The route response selection expression for the route.
     */
    public String routeResponseSelectionExpression() {
        return routeResponseSelectionExpression;
    }

    /**
     * <p>
     * The target for the route.
     * </p>
     * 
     * @return The target for the route.
     */
    public String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationScopes());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(requestModels());
        hashCode = 31 * hashCode + Objects.hashCode(requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(routeId());
        hashCode = 31 * hashCode + Objects.hashCode(routeKey());
        hashCode = 31 * hashCode + Objects.hashCode(routeResponseSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteResponse)) {
            return false;
        }
        GetRouteResponse other = (GetRouteResponse) obj;
        return Objects.equals(apiKeyRequired(), other.apiKeyRequired())
                && Objects.equals(authorizationScopes(), other.authorizationScopes())
                && Objects.equals(authorizationTypeAsString(), other.authorizationTypeAsString())
                && Objects.equals(authorizerId(), other.authorizerId())
                && Objects.equals(modelSelectionExpression(), other.modelSelectionExpression())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(requestModels(), other.requestModels())
                && Objects.equals(requestParameters(), other.requestParameters()) && Objects.equals(routeId(), other.routeId())
                && Objects.equals(routeKey(), other.routeKey())
                && Objects.equals(routeResponseSelectionExpression(), other.routeResponseSelectionExpression())
                && Objects.equals(target(), other.target());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRouteResponse").add("ApiKeyRequired", apiKeyRequired())
                .add("AuthorizationScopes", authorizationScopes()).add("AuthorizationType", authorizationTypeAsString())
                .add("AuthorizerId", authorizerId()).add("ModelSelectionExpression", modelSelectionExpression())
                .add("OperationName", operationName()).add("RequestModels", requestModels())
                .add("RequestParameters", requestParameters()).add("RouteId", routeId()).add("RouteKey", routeKey())
                .add("RouteResponseSelectionExpression", routeResponseSelectionExpression()).add("Target", target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiKeyRequired":
            return Optional.ofNullable(clazz.cast(apiKeyRequired()));
        case "AuthorizationScopes":
            return Optional.ofNullable(clazz.cast(authorizationScopes()));
        case "AuthorizationType":
            return Optional.ofNullable(clazz.cast(authorizationTypeAsString()));
        case "AuthorizerId":
            return Optional.ofNullable(clazz.cast(authorizerId()));
        case "ModelSelectionExpression":
            return Optional.ofNullable(clazz.cast(modelSelectionExpression()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "RequestModels":
            return Optional.ofNullable(clazz.cast(requestModels()));
        case "RequestParameters":
            return Optional.ofNullable(clazz.cast(requestParameters()));
        case "RouteId":
            return Optional.ofNullable(clazz.cast(routeId()));
        case "RouteKey":
            return Optional.ofNullable(clazz.cast(routeKey()));
        case "RouteResponseSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeResponseSelectionExpression()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRouteResponse, T> g) {
        return obj -> g.apply((GetRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetRouteResponse> {
        /**
         * <p>
         * Specifies whether an API key is required for this route.
         * </p>
         * 
         * @param apiKeyRequired
         *        Specifies whether an API key is required for this route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyRequired(Boolean apiKeyRequired);

        /**
         * <p>
         * The authorization scopes supported by this route.
         * </p>
         * 
         * @param authorizationScopes
         *        The authorization scopes supported by this route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationScopes(Collection<String> authorizationScopes);

        /**
         * <p>
         * The authorization scopes supported by this route.
         * </p>
         * 
         * @param authorizationScopes
         *        The authorization scopes supported by this route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationScopes(String... authorizationScopes);

        /**
         * <p>
         * The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
         * permissions.
         * </p>
         * 
         * @param authorizationType
         *        The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
         *        permissions.
         * @see AuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationType
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
         * permissions.
         * </p>
         * 
         * @param authorizationType
         *        The authorization type for the route. Valid values are NONE for open access, AWS_IAM for using AWS IAM
         *        permissions.
         * @see AuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationType
         */
        Builder authorizationType(AuthorizationType authorizationType);

        /**
         * <p>
         * The identifier of the Authorizer resource to be associated with this route.
         * </p>
         * 
         * @param authorizerId
         *        The identifier of the Authorizer resource to be associated with this route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerId(String authorizerId);

        /**
         * <p>
         * The model selection expression for the route.
         * </p>
         * 
         * @param modelSelectionExpression
         *        The model selection expression for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSelectionExpression(String modelSelectionExpression);

        /**
         * <p>
         * The operation name for the route.
         * </p>
         * 
         * @param operationName
         *        The operation name for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * The request models for the route.
         * </p>
         * 
         * @param requestModels
         *        The request models for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestModels(Map<String, String> requestModels);

        /**
         * <p>
         * The request parameters for the route.
         * </p>
         * 
         * @param requestParameters
         *        The request parameters for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestParameters(Map<String, ParameterConstraints> requestParameters);

        /**
         * <p>
         * The route ID.
         * </p>
         * 
         * @param routeId
         *        The route ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeId(String routeId);

        /**
         * <p>
         * The route key for the route.
         * </p>
         * 
         * @param routeKey
         *        The route key for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeKey(String routeKey);

        /**
         * <p>
         * The route response selection expression for the route.
         * </p>
         * 
         * @param routeResponseSelectionExpression
         *        The route response selection expression for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeResponseSelectionExpression(String routeResponseSelectionExpression);

        /**
         * <p>
         * The target for the route.
         * </p>
         * 
         * @param target
         *        The target for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private Boolean apiKeyRequired;

        private List<String> authorizationScopes = DefaultSdkAutoConstructList.getInstance();

        private String authorizationType;

        private String authorizerId;

        private String modelSelectionExpression;

        private String operationName;

        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ParameterConstraints> requestParameters = DefaultSdkAutoConstructMap.getInstance();

        private String routeId;

        private String routeKey;

        private String routeResponseSelectionExpression;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteResponse model) {
            super(model);
            apiKeyRequired(model.apiKeyRequired);
            authorizationScopes(model.authorizationScopes);
            authorizationType(model.authorizationType);
            authorizerId(model.authorizerId);
            modelSelectionExpression(model.modelSelectionExpression);
            operationName(model.operationName);
            requestModels(model.requestModels);
            requestParameters(model.requestParameters);
            routeId(model.routeId);
            routeKey(model.routeKey);
            routeResponseSelectionExpression(model.routeResponseSelectionExpression);
            target(model.target);
        }

        public final Boolean getApiKeyRequired() {
            return apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public final Collection<String> getAuthorizationScopes() {
            return authorizationScopes;
        }

        @Override
        public final Builder authorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = AuthorizationScopesCopier.copy(authorizationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationScopes(String... authorizationScopes) {
            authorizationScopes(Arrays.asList(authorizationScopes));
            return this;
        }

        public final void setAuthorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = AuthorizationScopesCopier.copy(authorizationScopes);
        }

        public final String getAuthorizationTypeAsString() {
            return authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType(authorizationType.toString());
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final String getAuthorizerId() {
            return authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final String getModelSelectionExpression() {
            return modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        public final String getOperationName() {
            return operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final Map<String, String> getRequestModels() {
            return requestModels;
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = RouteModelsCopier.copy(requestModels);
            return this;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = RouteModelsCopier.copy(requestModels);
        }

        public final Map<String, ParameterConstraints.Builder> getRequestParameters() {
            return requestParameters != null ? CollectionUtils.mapValues(requestParameters, ParameterConstraints::toBuilder)
                    : null;
        }

        @Override
        public final Builder requestParameters(Map<String, ParameterConstraints> requestParameters) {
            this.requestParameters = RouteParametersCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, ParameterConstraints.BuilderImpl> requestParameters) {
            this.requestParameters = RouteParametersCopier.copyFromBuilder(requestParameters);
        }

        public final String getRouteId() {
            return routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public final String getRouteKey() {
            return routeKey;
        }

        @Override
        public final Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public final void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        public final String getRouteResponseSelectionExpression() {
            return routeResponseSelectionExpression;
        }

        @Override
        public final Builder routeResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
            return this;
        }

        public final void setRouteResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public GetRouteResponse build() {
            return new GetRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
