/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStageRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateStageRequest.Builder, UpdateStageRequest> {
    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField
            .<AccessLogSettings> builder(MarshallingType.SDK_POJO).getter(getter(UpdateStageRequest::accessLogSettings))
            .setter(setter(Builder::accessLogSettings)).constructor(AccessLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStageRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStageRequest::clientCertificateId)).setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField
            .<RouteSettings> builder(MarshallingType.SDK_POJO).getter(getter(UpdateStageRequest::defaultRouteSettings))
            .setter(setter(Builder::defaultRouteSettings)).constructor(RouteSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRouteSettings").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStageRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, RouteSettings>> ROUTE_SETTINGS_FIELD = SdkField
            .<Map<String, RouteSettings>> builder(MarshallingType.MAP)
            .getter(getter(UpdateStageRequest::routeSettings))
            .setter(setter(Builder::routeSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RouteSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStageRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stageName").build()).build();

    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UpdateStageRequest::stageVariables))
            .setter(setter(Builder::stageVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_SETTINGS_FIELD,
            API_ID_FIELD, CLIENT_CERTIFICATE_ID_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD, DESCRIPTION_FIELD,
            ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD));

    private final AccessLogSettings accessLogSettings;

    private final String apiId;

    private final String clientCertificateId;

    private final RouteSettings defaultRouteSettings;

    private final String deploymentId;

    private final String description;

    private final Map<String, RouteSettings> routeSettings;

    private final String stageName;

    private final Map<String, String> stageVariables;

    private UpdateStageRequest(BuilderImpl builder) {
        super(builder);
        this.accessLogSettings = builder.accessLogSettings;
        this.apiId = builder.apiId;
        this.clientCertificateId = builder.clientCertificateId;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
    }

    /**
     * <p>
     * Settings for logging access in this stage.
     * </p>
     * 
     * @return Settings for logging access in this stage.
     */
    public AccessLogSettings accessLogSettings() {
        return accessLogSettings;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The identifier of a client certificate for a Stage.
     * </p>
     * 
     * @return The identifier of a client certificate for a Stage.
     */
    public String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The default route settings for the stage.
     * </p>
     * 
     * @return The default route settings for the stage.
     */
    public RouteSettings defaultRouteSettings() {
        return defaultRouteSettings;
    }

    /**
     * <p>
     * The deployment identifier for the API stage.
     * </p>
     * 
     * @return The deployment identifier for the API stage.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The description for the API stage.
     * </p>
     * 
     * @return The description for the API stage.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Route settings for the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Route settings for the stage.
     */
    public Map<String, RouteSettings> routeSettings() {
        return routeSettings;
    }

    /**
     * <p>
     * The stage name.
     * </p>
     * 
     * @return The stage name.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
     * characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
     *         characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+.
     */
    public Map<String, String> stageVariables() {
        return stageVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(stageVariables());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageRequest)) {
            return false;
        }
        UpdateStageRequest other = (UpdateStageRequest) obj;
        return Objects.equals(accessLogSettings(), other.accessLogSettings()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(defaultRouteSettings(), other.defaultRouteSettings())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(description(), other.description())
                && Objects.equals(routeSettings(), other.routeSettings()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(stageVariables(), other.stageVariables());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateStageRequest").add("AccessLogSettings", accessLogSettings()).add("ApiId", apiId())
                .add("ClientCertificateId", clientCertificateId()).add("DefaultRouteSettings", defaultRouteSettings())
                .add("DeploymentId", deploymentId()).add("Description", description()).add("RouteSettings", routeSettings())
                .add("StageName", stageName()).add("StageVariables", stageVariables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessLogSettings":
            return Optional.ofNullable(clazz.cast(accessLogSettings()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ClientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "DefaultRouteSettings":
            return Optional.ofNullable(clazz.cast(defaultRouteSettings()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RouteSettings":
            return Optional.ofNullable(clazz.cast(routeSettings()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "StageVariables":
            return Optional.ofNullable(clazz.cast(stageVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStageRequest, T> g) {
        return obj -> g.apply((UpdateStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStageRequest> {
        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * 
         * @param accessLogSettings
         *        Settings for logging access in this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogSettings(AccessLogSettings accessLogSettings);

        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessLogSettings.Builder} avoiding the need to
         * create one manually via {@link AccessLogSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLogSettings(AccessLogSettings)}.
         * 
         * @param accessLogSettings
         *        a consumer that will call methods on {@link AccessLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogSettings(AccessLogSettings)
         */
        default Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return accessLogSettings(AccessLogSettings.builder().applyMutation(accessLogSettings).build());
        }

        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The identifier of a client certificate for a Stage.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of a client certificate for a Stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The default route settings for the stage.
         * </p>
         * 
         * @param defaultRouteSettings
         *        The default route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRouteSettings(RouteSettings defaultRouteSettings);

        /**
         * <p>
         * The default route settings for the stage.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteSettings.Builder} avoiding the need to
         * create one manually via {@link RouteSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultRouteSettings(RouteSettings)}.
         * 
         * @param defaultRouteSettings
         *        a consumer that will call methods on {@link RouteSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRouteSettings(RouteSettings)
         */
        default Builder defaultRouteSettings(Consumer<RouteSettings.Builder> defaultRouteSettings) {
            return defaultRouteSettings(RouteSettings.builder().applyMutation(defaultRouteSettings).build());
        }

        /**
         * <p>
         * The deployment identifier for the API stage.
         * </p>
         * 
         * @param deploymentId
         *        The deployment identifier for the API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The description for the API stage.
         * </p>
         * 
         * @param description
         *        The description for the API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Route settings for the stage.
         * </p>
         * 
         * @param routeSettings
         *        Route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSettings(Map<String, RouteSettings> routeSettings);

        /**
         * <p>
         * The stage name.
         * </p>
         * 
         * @param stageName
         *        The stage name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
         * characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+.
         * </p>
         * 
         * @param stageVariables
         *        A map that defines the stage variables for a Stage. Variable names can have alphanumeric and
         *        underscore characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageVariables(Map<String, String> stageVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private AccessLogSettings accessLogSettings;

        private String apiId;

        private String clientCertificateId;

        private RouteSettings defaultRouteSettings;

        private String deploymentId;

        private String description;

        private Map<String, RouteSettings> routeSettings = DefaultSdkAutoConstructMap.getInstance();

        private String stageName;

        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStageRequest model) {
            super(model);
            accessLogSettings(model.accessLogSettings);
            apiId(model.apiId);
            clientCertificateId(model.clientCertificateId);
            defaultRouteSettings(model.defaultRouteSettings);
            deploymentId(model.deploymentId);
            description(model.description);
            routeSettings(model.routeSettings);
            stageName(model.stageName);
            stageVariables(model.stageVariables);
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return accessLogSettings != null ? accessLogSettings.toBuilder() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final RouteSettings.Builder getDefaultRouteSettings() {
            return defaultRouteSettings != null ? defaultRouteSettings.toBuilder() : null;
        }

        @Override
        public final Builder defaultRouteSettings(RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final void setDefaultRouteSettings(RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, RouteSettings.Builder> getRouteSettings() {
            return routeSettings != null ? CollectionUtils.mapValues(routeSettings, RouteSettings::toBuilder) : null;
        }

        @Override
        public final Builder routeSettings(Map<String, RouteSettings> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copy(routeSettings);
            return this;
        }

        public final void setRouteSettings(Map<String, RouteSettings.BuilderImpl> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copyFromBuilder(routeSettings);
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final Map<String, String> getStageVariables() {
            return stageVariables;
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
            return this;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStageRequest build() {
            return new UpdateStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
