/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RoutingMode {
    API_MAPPING_ONLY("API_MAPPING_ONLY"),
    ROUTING_RULE_ONLY("ROUTING_RULE_ONLY"),
    ROUTING_RULE_THEN_API_MAPPING("ROUTING_RULE_THEN_API_MAPPING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RoutingMode> VALUE_MAP;
    private final String value;

    private RoutingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoutingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoutingMode> knownValues() {
        EnumSet<RoutingMode> knownValues = EnumSet.allOf(RoutingMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RoutingMode.class, RoutingMode::toString);
    }
}

