/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainNameResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<CreateDomainNameResponse.Builder, CreateDomainNameResponse> {
    private static final SdkField<String> API_MAPPING_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApiMappingSelectionExpression")
            .getter(getter(CreateDomainNameResponse::apiMappingSelectionExpression))
            .setter(setter(Builder::apiMappingSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingSelectionExpression")
                    .build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateDomainNameResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> DOMAIN_NAME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainNameArn").getter(getter(CreateDomainNameResponse::domainNameArn))
            .setter(setter(Builder::domainNameArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameArn").build()).build();

    private static final SdkField<List<DomainNameConfiguration>> DOMAIN_NAME_CONFIGURATIONS_FIELD = SdkField
            .<List<DomainNameConfiguration>> builder(MarshallingType.LIST)
            .memberName("DomainNameConfigurations")
            .getter(getter(CreateDomainNameResponse::domainNameConfigurations))
            .setter(setter(Builder::domainNameConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainNameConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainNameConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MutualTlsAuthentication> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField
            .<MutualTlsAuthentication> builder(MarshallingType.SDK_POJO).memberName("MutualTlsAuthentication")
            .getter(getter(CreateDomainNameResponse::mutualTlsAuthentication)).setter(setter(Builder::mutualTlsAuthentication))
            .constructor(MutualTlsAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build())
            .build();

    private static final SdkField<String> ROUTING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingMode").getter(getter(CreateDomainNameResponse::routingModeAsString))
            .setter(setter(Builder::routingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingMode").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDomainNameResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            API_MAPPING_SELECTION_EXPRESSION_FIELD, DOMAIN_NAME_FIELD, DOMAIN_NAME_ARN_FIELD, DOMAIN_NAME_CONFIGURATIONS_FIELD,
            MUTUAL_TLS_AUTHENTICATION_FIELD, ROUTING_MODE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String apiMappingSelectionExpression;

    private final String domainName;

    private final String domainNameArn;

    private final List<DomainNameConfiguration> domainNameConfigurations;

    private final MutualTlsAuthentication mutualTlsAuthentication;

    private final String routingMode;

    private final Map<String, String> tags;

    private CreateDomainNameResponse(BuilderImpl builder) {
        super(builder);
        this.apiMappingSelectionExpression = builder.apiMappingSelectionExpression;
        this.domainName = builder.domainName;
        this.domainNameArn = builder.domainNameArn;
        this.domainNameConfigurations = builder.domainNameConfigurations;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
        this.routingMode = builder.routingMode;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The API mapping selection expression.
     * </p>
     * 
     * @return The API mapping selection expression.
     */
    public final String apiMappingSelectionExpression() {
        return apiMappingSelectionExpression;
    }

    /**
     * <p>
     * The name of the DomainName resource.
     * </p>
     * 
     * @return The name of the DomainName resource.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * Returns the value of the DomainNameArn property for this object.
     * 
     * @return The value of the DomainNameArn property for this object.
     */
    public final String domainNameArn() {
        return domainNameArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainNameConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainNameConfigurations() {
        return domainNameConfigurations != null && !(domainNameConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domain name configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainNameConfigurations} method.
     * </p>
     * 
     * @return The domain name configurations.
     */
    public final List<DomainNameConfiguration> domainNameConfigurations() {
        return domainNameConfigurations;
    }

    /**
     * <p>
     * The mutual TLS authentication configuration for a custom domain name.
     * </p>
     * 
     * @return The mutual TLS authentication configuration for a custom domain name.
     */
    public final MutualTlsAuthentication mutualTlsAuthentication() {
        return mutualTlsAuthentication;
    }

    /**
     * <p>
     * The routing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingMode} will
     * return {@link RoutingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingModeAsString}.
     * </p>
     * 
     * @return The routing mode.
     * @see RoutingMode
     */
    public final RoutingMode routingMode() {
        return RoutingMode.fromValue(routingMode);
    }

    /**
     * <p>
     * The routing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingMode} will
     * return {@link RoutingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingModeAsString}.
     * </p>
     * 
     * @return The routing mode.
     * @see RoutingMode
     */
    public final String routingModeAsString() {
        return routingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags associated with a domain name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The collection of tags associated with a domain name.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiMappingSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainNameConfigurations() ? domainNameConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mutualTlsAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(routingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameResponse)) {
            return false;
        }
        CreateDomainNameResponse other = (CreateDomainNameResponse) obj;
        return Objects.equals(apiMappingSelectionExpression(), other.apiMappingSelectionExpression())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(domainNameArn(), other.domainNameArn())
                && hasDomainNameConfigurations() == other.hasDomainNameConfigurations()
                && Objects.equals(domainNameConfigurations(), other.domainNameConfigurations())
                && Objects.equals(mutualTlsAuthentication(), other.mutualTlsAuthentication())
                && Objects.equals(routingModeAsString(), other.routingModeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDomainNameResponse").add("ApiMappingSelectionExpression", apiMappingSelectionExpression())
                .add("DomainName", domainName()).add("DomainNameArn", domainNameArn())
                .add("DomainNameConfigurations", hasDomainNameConfigurations() ? domainNameConfigurations() : null)
                .add("MutualTlsAuthentication", mutualTlsAuthentication()).add("RoutingMode", routingModeAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiMappingSelectionExpression":
            return Optional.ofNullable(clazz.cast(apiMappingSelectionExpression()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainNameArn":
            return Optional.ofNullable(clazz.cast(domainNameArn()));
        case "DomainNameConfigurations":
            return Optional.ofNullable(clazz.cast(domainNameConfigurations()));
        case "MutualTlsAuthentication":
            return Optional.ofNullable(clazz.cast(mutualTlsAuthentication()));
        case "RoutingMode":
            return Optional.ofNullable(clazz.cast(routingModeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiMappingSelectionExpression", API_MAPPING_SELECTION_EXPRESSION_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainNameArn", DOMAIN_NAME_ARN_FIELD);
        map.put("domainNameConfigurations", DOMAIN_NAME_CONFIGURATIONS_FIELD);
        map.put("mutualTlsAuthentication", MUTUAL_TLS_AUTHENTICATION_FIELD);
        map.put("routingMode", ROUTING_MODE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameResponse, T> g) {
        return obj -> g.apply((CreateDomainNameResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainNameResponse> {
        /**
         * <p>
         * The API mapping selection expression.
         * </p>
         * 
         * @param apiMappingSelectionExpression
         *        The API mapping selection expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiMappingSelectionExpression(String apiMappingSelectionExpression);

        /**
         * <p>
         * The name of the DomainName resource.
         * </p>
         * 
         * @param domainName
         *        The name of the DomainName resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * Sets the value of the DomainNameArn property for this object.
         *
         * @param domainNameArn
         *        The new value for the DomainNameArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameArn(String domainNameArn);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #domainNameConfigurations(List<DomainNameConfiguration>)}.
         * 
         * @param domainNameConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainNameConfigurations(java.util.Collection<DomainNameConfiguration>)
         */
        Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * 
         * @param mutualTlsAuthentication
         *        The mutual TLS authentication configuration for a custom domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualTlsAuthentication(MutualTlsAuthentication mutualTlsAuthentication);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * This is a convenience method that creates an instance of the {@link MutualTlsAuthentication.Builder} avoiding
         * the need to create one manually via {@link MutualTlsAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MutualTlsAuthentication.Builder#build()} is called immediately
         * and its result is passed to {@link #mutualTlsAuthentication(MutualTlsAuthentication)}.
         * 
         * @param mutualTlsAuthentication
         *        a consumer that will call methods on {@link MutualTlsAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualTlsAuthentication(MutualTlsAuthentication)
         */
        default Builder mutualTlsAuthentication(Consumer<MutualTlsAuthentication.Builder> mutualTlsAuthentication) {
            return mutualTlsAuthentication(MutualTlsAuthentication.builder().applyMutation(mutualTlsAuthentication).build());
        }

        /**
         * <p>
         * The routing mode.
         * </p>
         * 
         * @param routingMode
         *        The routing mode.
         * @see RoutingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingMode
         */
        Builder routingMode(String routingMode);

        /**
         * <p>
         * The routing mode.
         * </p>
         * 
         * @param routingMode
         *        The routing mode.
         * @see RoutingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingMode
         */
        Builder routingMode(RoutingMode routingMode);

        /**
         * <p>
         * The collection of tags associated with a domain name.
         * </p>
         * 
         * @param tags
         *        The collection of tags associated with a domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String apiMappingSelectionExpression;

        private String domainName;

        private String domainNameArn;

        private List<DomainNameConfiguration> domainNameConfigurations = DefaultSdkAutoConstructList.getInstance();

        private MutualTlsAuthentication mutualTlsAuthentication;

        private String routingMode;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameResponse model) {
            super(model);
            apiMappingSelectionExpression(model.apiMappingSelectionExpression);
            domainName(model.domainName);
            domainNameArn(model.domainNameArn);
            domainNameConfigurations(model.domainNameConfigurations);
            mutualTlsAuthentication(model.mutualTlsAuthentication);
            routingMode(model.routingMode);
            tags(model.tags);
        }

        public final String getApiMappingSelectionExpression() {
            return apiMappingSelectionExpression;
        }

        public final void setApiMappingSelectionExpression(String apiMappingSelectionExpression) {
            this.apiMappingSelectionExpression = apiMappingSelectionExpression;
        }

        @Override
        public final Builder apiMappingSelectionExpression(String apiMappingSelectionExpression) {
            this.apiMappingSelectionExpression = apiMappingSelectionExpression;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameArn() {
            return domainNameArn;
        }

        public final void setDomainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
        }

        @Override
        public final Builder domainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
            return this;
        }

        public final List<DomainNameConfiguration.Builder> getDomainNameConfigurations() {
            List<DomainNameConfiguration.Builder> result = DomainNameConfigurationsCopier
                    .copyToBuilder(this.domainNameConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNameConfigurations(Collection<DomainNameConfiguration.BuilderImpl> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copyFromBuilder(domainNameConfigurations);
        }

        @Override
        public final Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copy(domainNameConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations) {
            domainNameConfigurations(Arrays.asList(domainNameConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations) {
            domainNameConfigurations(Stream.of(domainNameConfigurations)
                    .map(c -> DomainNameConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MutualTlsAuthentication.Builder getMutualTlsAuthentication() {
            return mutualTlsAuthentication != null ? mutualTlsAuthentication.toBuilder() : null;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthentication.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        @Override
        public final Builder mutualTlsAuthentication(MutualTlsAuthentication mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        public final String getRoutingMode() {
            return routingMode;
        }

        public final void setRoutingMode(String routingMode) {
            this.routingMode = routingMode;
        }

        @Override
        public final Builder routingMode(String routingMode) {
            this.routingMode = routingMode;
            return this;
        }

        @Override
        public final Builder routingMode(RoutingMode routingMode) {
            this.routingMode(routingMode == null ? null : routingMode.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public CreateDomainNameResponse build() {
            return new CreateDomainNameResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
