/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRoutingRuleRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<DeleteRoutingRuleRequest.Builder, DeleteRoutingRuleRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DeleteRoutingRuleRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()).build();

    private static final SdkField<String> DOMAIN_NAME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainNameId").getter(getter(DeleteRoutingRuleRequest::domainNameId))
            .setter(setter(Builder::domainNameId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainNameId").build()).build();

    private static final SdkField<String> ROUTING_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingRuleId").getter(getter(DeleteRoutingRuleRequest::routingRuleId))
            .setter(setter(Builder::routingRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("routingRuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_NAME_ID_FIELD, ROUTING_RULE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String domainNameId;

    private final String routingRuleId;

    private DeleteRoutingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameId = builder.domainNameId;
        this.routingRuleId = builder.routingRuleId;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The domain name ID.
     * </p>
     * 
     * @return The domain name ID.
     */
    public final String domainNameId() {
        return domainNameId;
    }

    /**
     * <p>
     * The routing rule ID.
     * </p>
     * 
     * @return The routing rule ID.
     */
    public final String routingRuleId() {
        return routingRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainNameId());
        hashCode = 31 * hashCode + Objects.hashCode(routingRuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRoutingRuleRequest)) {
            return false;
        }
        DeleteRoutingRuleRequest other = (DeleteRoutingRuleRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(domainNameId(), other.domainNameId())
                && Objects.equals(routingRuleId(), other.routingRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRoutingRuleRequest").add("DomainName", domainName()).add("DomainNameId", domainNameId())
                .add("RoutingRuleId", routingRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainNameId":
            return Optional.ofNullable(clazz.cast(domainNameId()));
        case "RoutingRuleId":
            return Optional.ofNullable(clazz.cast(routingRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainNameId", DOMAIN_NAME_ID_FIELD);
        map.put("routingRuleId", ROUTING_RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRoutingRuleRequest, T> g) {
        return obj -> g.apply((DeleteRoutingRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRoutingRuleRequest> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The domain name ID.
         * </p>
         * 
         * @param domainNameId
         *        The domain name ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameId(String domainNameId);

        /**
         * <p>
         * The routing rule ID.
         * </p>
         * 
         * @param routingRuleId
         *        The routing rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRuleId(String routingRuleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String domainName;

        private String domainNameId;

        private String routingRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRoutingRuleRequest model) {
            super(model);
            domainName(model.domainName);
            domainNameId(model.domainNameId);
            routingRuleId(model.routingRuleId);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameId() {
            return domainNameId;
        }

        public final void setDomainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
        }

        @Override
        public final Builder domainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
            return this;
        }

        public final String getRoutingRuleId() {
            return routingRuleId;
        }

        public final void setRoutingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
        }

        @Override
        public final Builder routingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRoutingRuleRequest build() {
            return new DeleteRoutingRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
