/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a routing rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingRule implements SdkPojo, Serializable, ToCopyableBuilder<RoutingRule.Builder, RoutingRule> {
    private static final SdkField<List<RoutingRuleAction>> ACTIONS_FIELD = SdkField
            .<List<RoutingRuleAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(RoutingRule::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingRuleAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingRuleAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RoutingRuleCondition>> CONDITIONS_FIELD = SdkField
            .<List<RoutingRuleCondition>> builder(MarshallingType.LIST)
            .memberName("Conditions")
            .getter(getter(RoutingRule::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingRuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingRuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(RoutingRule::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> ROUTING_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingRuleArn").getter(getter(RoutingRule::routingRuleArn)).setter(setter(Builder::routingRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingRuleArn").build()).build();

    private static final SdkField<String> ROUTING_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingRuleId").getter(getter(RoutingRule::routingRuleId)).setter(setter(Builder::routingRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingRuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            CONDITIONS_FIELD, PRIORITY_FIELD, ROUTING_RULE_ARN_FIELD, ROUTING_RULE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RoutingRuleAction> actions;

    private final List<RoutingRuleCondition> conditions;

    private final Integer priority;

    private final String routingRuleArn;

    private final String routingRuleId;

    private RoutingRule(BuilderImpl builder) {
        this.actions = builder.actions;
        this.conditions = builder.conditions;
        this.priority = builder.priority;
        this.routingRuleArn = builder.routingRuleArn;
        this.routingRuleId = builder.routingRuleId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routing rule action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The routing rule action.
     */
    public final List<RoutingRuleAction> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routing rule condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return The routing rule condition.
     */
    public final List<RoutingRuleCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * The routing rule priority.
     * </p>
     * 
     * @return The routing rule priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The routing rule ARN.
     * </p>
     * 
     * @return The routing rule ARN.
     */
    public final String routingRuleArn() {
        return routingRuleArn;
    }

    /**
     * <p>
     * The routing rule ID.
     * </p>
     * 
     * @return The routing rule ID.
     */
    public final String routingRuleId() {
        return routingRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(routingRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingRuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingRule)) {
            return false;
        }
        RoutingRule other = (RoutingRule) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && hasConditions() == other.hasConditions() && Objects.equals(conditions(), other.conditions())
                && Objects.equals(priority(), other.priority()) && Objects.equals(routingRuleArn(), other.routingRuleArn())
                && Objects.equals(routingRuleId(), other.routingRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingRule").add("Actions", hasActions() ? actions() : null)
                .add("Conditions", hasConditions() ? conditions() : null).add("Priority", priority())
                .add("RoutingRuleArn", routingRuleArn()).add("RoutingRuleId", routingRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "RoutingRuleArn":
            return Optional.ofNullable(clazz.cast(routingRuleArn()));
        case "RoutingRuleId":
            return Optional.ofNullable(clazz.cast(routingRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actions", ACTIONS_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("routingRuleArn", ROUTING_RULE_ARN_FIELD);
        map.put("routingRuleId", ROUTING_RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingRule, T> g) {
        return obj -> g.apply((RoutingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingRule> {
        /**
         * <p>
         * The routing rule action.
         * </p>
         * 
         * @param actions
         *        The routing rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<RoutingRuleAction> actions);

        /**
         * <p>
         * The routing rule action.
         * </p>
         * 
         * @param actions
         *        The routing rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(RoutingRuleAction... actions);

        /**
         * <p>
         * The routing rule action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleAction.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<RoutingRuleAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<RoutingRuleAction>)
         */
        Builder actions(Consumer<RoutingRuleAction.Builder>... actions);

        /**
         * <p>
         * The routing rule condition.
         * </p>
         * 
         * @param conditions
         *        The routing rule condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<RoutingRuleCondition> conditions);

        /**
         * <p>
         * The routing rule condition.
         * </p>
         * 
         * @param conditions
         *        The routing rule condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(RoutingRuleCondition... conditions);

        /**
         * <p>
         * The routing rule condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #conditions(List<RoutingRuleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<RoutingRuleCondition>)
         */
        Builder conditions(Consumer<RoutingRuleCondition.Builder>... conditions);

        /**
         * <p>
         * The routing rule priority.
         * </p>
         * 
         * @param priority
         *        The routing rule priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The routing rule ARN.
         * </p>
         * 
         * @param routingRuleArn
         *        The routing rule ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRuleArn(String routingRuleArn);

        /**
         * <p>
         * The routing rule ID.
         * </p>
         * 
         * @param routingRuleId
         *        The routing rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRuleId(String routingRuleId);
    }

    static final class BuilderImpl implements Builder {
        private List<RoutingRuleAction> actions = DefaultSdkAutoConstructList.getInstance();

        private List<RoutingRuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private Integer priority;

        private String routingRuleArn;

        private String routingRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingRule model) {
            actions(model.actions);
            conditions(model.conditions);
            priority(model.priority);
            routingRuleArn(model.routingRuleArn);
            routingRuleId(model.routingRuleId);
        }

        public final List<RoutingRuleAction.Builder> getActions() {
            List<RoutingRuleAction.Builder> result = ___listOfRoutingRuleActionCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RoutingRuleAction.BuilderImpl> actions) {
            this.actions = ___listOfRoutingRuleActionCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RoutingRuleAction> actions) {
            this.actions = ___listOfRoutingRuleActionCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RoutingRuleAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RoutingRuleAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> RoutingRuleAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RoutingRuleCondition.Builder> getConditions() {
            List<RoutingRuleCondition.Builder> result = ___listOfRoutingRuleConditionCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<RoutingRuleCondition.BuilderImpl> conditions) {
            this.conditions = ___listOfRoutingRuleConditionCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<RoutingRuleCondition> conditions) {
            this.conditions = ___listOfRoutingRuleConditionCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RoutingRuleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RoutingRuleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> RoutingRuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRoutingRuleArn() {
            return routingRuleArn;
        }

        public final void setRoutingRuleArn(String routingRuleArn) {
            this.routingRuleArn = routingRuleArn;
        }

        @Override
        public final Builder routingRuleArn(String routingRuleArn) {
            this.routingRuleArn = routingRuleArn;
            return this;
        }

        public final String getRoutingRuleId() {
            return routingRuleId;
        }

        public final void setRoutingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
        }

        @Override
        public final Builder routingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
            return this;
        }

        @Override
        public RoutingRule build() {
            return new RoutingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
