/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an InvokeApi action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingRuleActionInvokeApi implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingRuleActionInvokeApi.Builder, RoutingRuleActionInvokeApi> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(RoutingRuleActionInvokeApi::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(RoutingRuleActionInvokeApi::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<Boolean> STRIP_BASE_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StripBasePath").getter(getter(RoutingRuleActionInvokeApi::stripBasePath))
            .setter(setter(Builder::stripBasePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stripBasePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, STAGE_FIELD,
            STRIP_BASE_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiId;

    private final String stage;

    private final Boolean stripBasePath;

    private RoutingRuleActionInvokeApi(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.stage = builder.stage;
        this.stripBasePath = builder.stripBasePath;
    }

    /**
     * Returns the value of the ApiId property for this object.
     * 
     * @return The value of the ApiId property for this object.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * Returns the value of the Stage property for this object.
     * 
     * @return The value of the Stage property for this object.
     */
    public final String stage() {
        return stage;
    }

    /**
     * <p>
     * The strip base path setting.
     * </p>
     * 
     * @return The strip base path setting.
     */
    public final Boolean stripBasePath() {
        return stripBasePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(stripBasePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingRuleActionInvokeApi)) {
            return false;
        }
        RoutingRuleActionInvokeApi other = (RoutingRuleActionInvokeApi) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(stage(), other.stage())
                && Objects.equals(stripBasePath(), other.stripBasePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingRuleActionInvokeApi").add("ApiId", apiId()).add("Stage", stage())
                .add("StripBasePath", stripBasePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "StripBasePath":
            return Optional.ofNullable(clazz.cast(stripBasePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiId", API_ID_FIELD);
        map.put("stage", STAGE_FIELD);
        map.put("stripBasePath", STRIP_BASE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingRuleActionInvokeApi, T> g) {
        return obj -> g.apply((RoutingRuleActionInvokeApi) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingRuleActionInvokeApi> {
        /**
         * Sets the value of the ApiId property for this object.
         *
         * @param apiId
         *        The new value for the ApiId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * Sets the value of the Stage property for this object.
         *
         * @param stage
         *        The new value for the Stage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);

        /**
         * <p>
         * The strip base path setting.
         * </p>
         * 
         * @param stripBasePath
         *        The strip base path setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stripBasePath(Boolean stripBasePath);
    }

    static final class BuilderImpl implements Builder {
        private String apiId;

        private String stage;

        private Boolean stripBasePath;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingRuleActionInvokeApi model) {
            apiId(model.apiId);
            stage(model.stage);
            stripBasePath(model.stripBasePath);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final Boolean getStripBasePath() {
            return stripBasePath;
        }

        public final void setStripBasePath(Boolean stripBasePath) {
            this.stripBasePath = stripBasePath;
        }

        @Override
        public final Builder stripBasePath(Boolean stripBasePath) {
            this.stripBasePath = stripBasePath;
            return this;
        }

        @Override
        public RoutingRuleActionInvokeApi build() {
            return new RoutingRuleActionInvokeApi(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
