/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a routing rule condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingRuleCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingRuleCondition.Builder, RoutingRuleCondition> {
    private static final SdkField<RoutingRuleMatchBasePaths> MATCH_BASE_PATHS_FIELD = SdkField
            .<RoutingRuleMatchBasePaths> builder(MarshallingType.SDK_POJO).memberName("MatchBasePaths")
            .getter(getter(RoutingRuleCondition::matchBasePaths)).setter(setter(Builder::matchBasePaths))
            .constructor(RoutingRuleMatchBasePaths::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchBasePaths").build()).build();

    private static final SdkField<RoutingRuleMatchHeaders> MATCH_HEADERS_FIELD = SdkField
            .<RoutingRuleMatchHeaders> builder(MarshallingType.SDK_POJO).memberName("MatchHeaders")
            .getter(getter(RoutingRuleCondition::matchHeaders)).setter(setter(Builder::matchHeaders))
            .constructor(RoutingRuleMatchHeaders::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchHeaders").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_BASE_PATHS_FIELD,
            MATCH_HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoutingRuleMatchBasePaths matchBasePaths;

    private final RoutingRuleMatchHeaders matchHeaders;

    private RoutingRuleCondition(BuilderImpl builder) {
        this.matchBasePaths = builder.matchBasePaths;
        this.matchHeaders = builder.matchHeaders;
    }

    /**
     * <p>
     * The base path to be matched.
     * </p>
     * 
     * @return The base path to be matched.
     */
    public final RoutingRuleMatchBasePaths matchBasePaths() {
        return matchBasePaths;
    }

    /**
     * <p>
     * The headers to be matched.
     * </p>
     * 
     * @return The headers to be matched.
     */
    public final RoutingRuleMatchHeaders matchHeaders() {
        return matchHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchBasePaths());
        hashCode = 31 * hashCode + Objects.hashCode(matchHeaders());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingRuleCondition)) {
            return false;
        }
        RoutingRuleCondition other = (RoutingRuleCondition) obj;
        return Objects.equals(matchBasePaths(), other.matchBasePaths()) && Objects.equals(matchHeaders(), other.matchHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingRuleCondition").add("MatchBasePaths", matchBasePaths())
                .add("MatchHeaders", matchHeaders()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchBasePaths":
            return Optional.ofNullable(clazz.cast(matchBasePaths()));
        case "MatchHeaders":
            return Optional.ofNullable(clazz.cast(matchHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("matchBasePaths", MATCH_BASE_PATHS_FIELD);
        map.put("matchHeaders", MATCH_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingRuleCondition, T> g) {
        return obj -> g.apply((RoutingRuleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingRuleCondition> {
        /**
         * <p>
         * The base path to be matched.
         * </p>
         * 
         * @param matchBasePaths
         *        The base path to be matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchBasePaths(RoutingRuleMatchBasePaths matchBasePaths);

        /**
         * <p>
         * The base path to be matched.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingRuleMatchBasePaths.Builder}
         * avoiding the need to create one manually via {@link RoutingRuleMatchBasePaths#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingRuleMatchBasePaths.Builder#build()} is called immediately
         * and its result is passed to {@link #matchBasePaths(RoutingRuleMatchBasePaths)}.
         * 
         * @param matchBasePaths
         *        a consumer that will call methods on {@link RoutingRuleMatchBasePaths.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchBasePaths(RoutingRuleMatchBasePaths)
         */
        default Builder matchBasePaths(Consumer<RoutingRuleMatchBasePaths.Builder> matchBasePaths) {
            return matchBasePaths(RoutingRuleMatchBasePaths.builder().applyMutation(matchBasePaths).build());
        }

        /**
         * <p>
         * The headers to be matched.
         * </p>
         * 
         * @param matchHeaders
         *        The headers to be matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchHeaders(RoutingRuleMatchHeaders matchHeaders);

        /**
         * <p>
         * The headers to be matched.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingRuleMatchHeaders.Builder} avoiding
         * the need to create one manually via {@link RoutingRuleMatchHeaders#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingRuleMatchHeaders.Builder#build()} is called immediately
         * and its result is passed to {@link #matchHeaders(RoutingRuleMatchHeaders)}.
         * 
         * @param matchHeaders
         *        a consumer that will call methods on {@link RoutingRuleMatchHeaders.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchHeaders(RoutingRuleMatchHeaders)
         */
        default Builder matchHeaders(Consumer<RoutingRuleMatchHeaders.Builder> matchHeaders) {
            return matchHeaders(RoutingRuleMatchHeaders.builder().applyMutation(matchHeaders).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoutingRuleMatchBasePaths matchBasePaths;

        private RoutingRuleMatchHeaders matchHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingRuleCondition model) {
            matchBasePaths(model.matchBasePaths);
            matchHeaders(model.matchHeaders);
        }

        public final RoutingRuleMatchBasePaths.Builder getMatchBasePaths() {
            return matchBasePaths != null ? matchBasePaths.toBuilder() : null;
        }

        public final void setMatchBasePaths(RoutingRuleMatchBasePaths.BuilderImpl matchBasePaths) {
            this.matchBasePaths = matchBasePaths != null ? matchBasePaths.build() : null;
        }

        @Override
        public final Builder matchBasePaths(RoutingRuleMatchBasePaths matchBasePaths) {
            this.matchBasePaths = matchBasePaths;
            return this;
        }

        public final RoutingRuleMatchHeaders.Builder getMatchHeaders() {
            return matchHeaders != null ? matchHeaders.toBuilder() : null;
        }

        public final void setMatchHeaders(RoutingRuleMatchHeaders.BuilderImpl matchHeaders) {
            this.matchHeaders = matchHeaders != null ? matchHeaders.build() : null;
        }

        @Override
        public final Builder matchHeaders(RoutingRuleMatchHeaders matchHeaders) {
            this.matchHeaders = matchHeaders;
            return this;
        }

        @Override
        public RoutingRuleCondition build() {
            return new RoutingRuleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
