/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates a Stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStageRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateStageRequest.Builder, UpdateStageRequest> {
    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField
            .<AccessLogSettings> builder(MarshallingType.SDK_POJO).memberName("AccessLogSettings")
            .getter(getter(UpdateStageRequest::accessLogSettings)).setter(setter(Builder::accessLogSettings))
            .constructor(AccessLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(UpdateStageRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<Boolean> AUTO_DEPLOY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoDeploy").getter(getter(UpdateStageRequest::autoDeploy)).setter(setter(Builder::autoDeploy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoDeploy").build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCertificateId").getter(getter(UpdateStageRequest::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField
            .<RouteSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultRouteSettings")
            .getter(getter(UpdateStageRequest::defaultRouteSettings)).setter(setter(Builder::defaultRouteSettings))
            .constructor(RouteSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRouteSettings").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(UpdateStageRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateStageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, RouteSettings>> ROUTE_SETTINGS_FIELD = SdkField
            .<Map<String, RouteSettings>> builder(MarshallingType.MAP)
            .memberName("RouteSettings")
            .getter(getter(UpdateStageRequest::routeSettings))
            .setter(setter(Builder::routeSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RouteSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(UpdateStageRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stageName").build()).build();

    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StageVariables")
            .getter(getter(UpdateStageRequest::stageVariables))
            .setter(setter(Builder::stageVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_SETTINGS_FIELD,
            API_ID_FIELD, AUTO_DEPLOY_FIELD, CLIENT_CERTIFICATE_ID_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD,
            DESCRIPTION_FIELD, ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccessLogSettings accessLogSettings;

    private final String apiId;

    private final Boolean autoDeploy;

    private final String clientCertificateId;

    private final RouteSettings defaultRouteSettings;

    private final String deploymentId;

    private final String description;

    private final Map<String, RouteSettings> routeSettings;

    private final String stageName;

    private final Map<String, String> stageVariables;

    private UpdateStageRequest(BuilderImpl builder) {
        super(builder);
        this.accessLogSettings = builder.accessLogSettings;
        this.apiId = builder.apiId;
        this.autoDeploy = builder.autoDeploy;
        this.clientCertificateId = builder.clientCertificateId;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
    }

    /**
     * <p>
     * Settings for logging access in this stage.
     * </p>
     * 
     * @return Settings for logging access in this stage.
     */
    public final AccessLogSettings accessLogSettings() {
        return accessLogSettings;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
     * </p>
     * 
     * @return Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
     */
    public final Boolean autoDeploy() {
        return autoDeploy;
    }

    /**
     * <p>
     * The identifier of a client certificate for a Stage.
     * </p>
     * 
     * @return The identifier of a client certificate for a Stage.
     */
    public final String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The default route settings for the stage.
     * </p>
     * 
     * @return The default route settings for the stage.
     */
    public final RouteSettings defaultRouteSettings() {
        return defaultRouteSettings;
    }

    /**
     * <p>
     * The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.
     * </p>
     * 
     * @return The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The description for the API stage.
     * </p>
     * 
     * @return The description for the API stage.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteSettings() {
        return routeSettings != null && !(routeSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Route settings for the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteSettings} method.
     * </p>
     * 
     * @return Route settings for the stage.
     */
    public final Map<String, RouteSettings> routeSettings() {
        return routeSettings;
    }

    /**
     * <p>
     * The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default.
     * Maximum length is 128 characters.
     * </p>
     * 
     * @return The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be
     *         $default. Maximum length is 128 characters.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StageVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStageVariables() {
        return stageVariables != null && !(stageVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
     * characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStageVariables} method.
     * </p>
     * 
     * @return A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
     *         characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
     */
    public final Map<String, String> stageVariables() {
        return stageVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeploy());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteSettings() ? routeSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageVariables() ? stageVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageRequest)) {
            return false;
        }
        UpdateStageRequest other = (UpdateStageRequest) obj;
        return Objects.equals(accessLogSettings(), other.accessLogSettings()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(autoDeploy(), other.autoDeploy())
                && Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(defaultRouteSettings(), other.defaultRouteSettings())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(description(), other.description())
                && hasRouteSettings() == other.hasRouteSettings() && Objects.equals(routeSettings(), other.routeSettings())
                && Objects.equals(stageName(), other.stageName()) && hasStageVariables() == other.hasStageVariables()
                && Objects.equals(stageVariables(), other.stageVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStageRequest").add("AccessLogSettings", accessLogSettings()).add("ApiId", apiId())
                .add("AutoDeploy", autoDeploy()).add("ClientCertificateId", clientCertificateId())
                .add("DefaultRouteSettings", defaultRouteSettings()).add("DeploymentId", deploymentId())
                .add("Description", description()).add("RouteSettings", hasRouteSettings() ? routeSettings() : null)
                .add("StageName", stageName()).add("StageVariables", hasStageVariables() ? stageVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessLogSettings":
            return Optional.ofNullable(clazz.cast(accessLogSettings()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "AutoDeploy":
            return Optional.ofNullable(clazz.cast(autoDeploy()));
        case "ClientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "DefaultRouteSettings":
            return Optional.ofNullable(clazz.cast(defaultRouteSettings()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RouteSettings":
            return Optional.ofNullable(clazz.cast(routeSettings()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "StageVariables":
            return Optional.ofNullable(clazz.cast(stageVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessLogSettings", ACCESS_LOG_SETTINGS_FIELD);
        map.put("apiId", API_ID_FIELD);
        map.put("autoDeploy", AUTO_DEPLOY_FIELD);
        map.put("clientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
        map.put("defaultRouteSettings", DEFAULT_ROUTE_SETTINGS_FIELD);
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routeSettings", ROUTE_SETTINGS_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("stageVariables", STAGE_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStageRequest, T> g) {
        return obj -> g.apply((UpdateStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStageRequest> {
        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * 
         * @param accessLogSettings
         *        Settings for logging access in this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogSettings(AccessLogSettings accessLogSettings);

        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessLogSettings.Builder} avoiding the
         * need to create one manually via {@link AccessLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLogSettings(AccessLogSettings)}.
         * 
         * @param accessLogSettings
         *        a consumer that will call methods on {@link AccessLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogSettings(AccessLogSettings)
         */
        default Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return accessLogSettings(AccessLogSettings.builder().applyMutation(accessLogSettings).build());
        }

        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
         * </p>
         * 
         * @param autoDeploy
         *        Specifies whether updates to an API automatically trigger a new deployment. The default value is
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeploy(Boolean autoDeploy);

        /**
         * <p>
         * The identifier of a client certificate for a Stage.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of a client certificate for a Stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The default route settings for the stage.
         * </p>
         * 
         * @param defaultRouteSettings
         *        The default route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRouteSettings(RouteSettings defaultRouteSettings);

        /**
         * <p>
         * The default route settings for the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteSettings.Builder} avoiding the need
         * to create one manually via {@link RouteSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultRouteSettings(RouteSettings)}.
         * 
         * @param defaultRouteSettings
         *        a consumer that will call methods on {@link RouteSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRouteSettings(RouteSettings)
         */
        default Builder defaultRouteSettings(Consumer<RouteSettings.Builder> defaultRouteSettings) {
            return defaultRouteSettings(RouteSettings.builder().applyMutation(defaultRouteSettings).build());
        }

        /**
         * <p>
         * The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.
         * </p>
         * 
         * @param deploymentId
         *        The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The description for the API stage.
         * </p>
         * 
         * @param description
         *        The description for the API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Route settings for the stage.
         * </p>
         * 
         * @param routeSettings
         *        Route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSettings(Map<String, RouteSettings> routeSettings);

        /**
         * <p>
         * The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be
         * $default. Maximum length is 128 characters.
         * </p>
         * 
         * @param stageName
         *        The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be
         *        $default. Maximum length is 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
         * characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
         * </p>
         * 
         * @param stageVariables
         *        A map that defines the stage variables for a Stage. Variable names can have alphanumeric and
         *        underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageVariables(Map<String, String> stageVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private AccessLogSettings accessLogSettings;

        private String apiId;

        private Boolean autoDeploy;

        private String clientCertificateId;

        private RouteSettings defaultRouteSettings;

        private String deploymentId;

        private String description;

        private Map<String, RouteSettings> routeSettings = DefaultSdkAutoConstructMap.getInstance();

        private String stageName;

        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStageRequest model) {
            super(model);
            accessLogSettings(model.accessLogSettings);
            apiId(model.apiId);
            autoDeploy(model.autoDeploy);
            clientCertificateId(model.clientCertificateId);
            defaultRouteSettings(model.defaultRouteSettings);
            deploymentId(model.deploymentId);
            description(model.description);
            routeSettings(model.routeSettings);
            stageName(model.stageName);
            stageVariables(model.stageVariables);
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return accessLogSettings != null ? accessLogSettings.toBuilder() : null;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final Boolean getAutoDeploy() {
            return autoDeploy;
        }

        public final void setAutoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
        }

        @Override
        public final Builder autoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final RouteSettings.Builder getDefaultRouteSettings() {
            return defaultRouteSettings != null ? defaultRouteSettings.toBuilder() : null;
        }

        public final void setDefaultRouteSettings(RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        @Override
        public final Builder defaultRouteSettings(RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, RouteSettings.Builder> getRouteSettings() {
            Map<String, RouteSettings.Builder> result = RouteSettingsMapCopier.copyToBuilder(this.routeSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRouteSettings(Map<String, RouteSettings.BuilderImpl> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copyFromBuilder(routeSettings);
        }

        @Override
        public final Builder routeSettings(Map<String, RouteSettings> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copy(routeSettings);
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final Map<String, String> getStageVariables() {
            if (stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return stageVariables;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStageRequest build() {
            return new UpdateStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
