/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.DisplayOrder;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPortalProductResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, GetPortalProductResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetPortalProductResponse.getter(GetPortalProductResponse::description)).setter(GetPortalProductResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(GetPortalProductResponse.getter(GetPortalProductResponse::displayName)).setter(GetPortalProductResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<DisplayOrder> DISPLAY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOrder").getter(GetPortalProductResponse.getter(GetPortalProductResponse::displayOrder)).setter(GetPortalProductResponse.setter(Builder::displayOrder)).constructor(DisplayOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayOrder").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(GetPortalProductResponse.getter(GetPortalProductResponse::lastModified)).setter(GetPortalProductResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PORTAL_PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductArn").getter(GetPortalProductResponse.getter(GetPortalProductResponse::portalProductArn)).setter(GetPortalProductResponse.setter(Builder::portalProductArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalProductArn").build()}).build();
    private static final SdkField<String> PORTAL_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductId").getter(GetPortalProductResponse.getter(GetPortalProductResponse::portalProductId)).setter(GetPortalProductResponse.setter(Builder::portalProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalProductId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetPortalProductResponse.getter(GetPortalProductResponse::tags)).setter(GetPortalProductResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, DISPLAY_ORDER_FIELD, LAST_MODIFIED_FIELD, PORTAL_PRODUCT_ARN_FIELD, PORTAL_PRODUCT_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPortalProductResponse.memberNameToFieldInitializer();
    private final String description;
    private final String displayName;
    private final DisplayOrder displayOrder;
    private final Instant lastModified;
    private final String portalProductArn;
    private final String portalProductId;
    private final Map<String, String> tags;

    private GetPortalProductResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.displayOrder = builder.displayOrder;
        this.lastModified = builder.lastModified;
        this.portalProductArn = builder.portalProductArn;
        this.portalProductId = builder.portalProductId;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final DisplayOrder displayOrder() {
        return this.displayOrder;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String portalProductArn() {
        return this.portalProductArn;
    }

    public final String portalProductId() {
        return this.portalProductId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPortalProductResponse)) {
            return false;
        }
        GetPortalProductResponse other = (GetPortalProductResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.displayOrder(), other.displayOrder()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.portalProductArn(), other.portalProductArn()) && Objects.equals(this.portalProductId(), other.portalProductId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetPortalProductResponse").add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("DisplayOrder", (Object)this.displayOrder()).add("LastModified", (Object)this.lastModified()).add("PortalProductArn", (Object)this.portalProductArn()).add("PortalProductId", (Object)this.portalProductId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "DisplayOrder": {
                return Optional.ofNullable(clazz.cast(this.displayOrder()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "PortalProductArn": {
                return Optional.ofNullable(clazz.cast(this.portalProductArn()));
            }
            case "PortalProductId": {
                return Optional.ofNullable(clazz.cast(this.portalProductId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("displayOrder", DISPLAY_ORDER_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("portalProductArn", PORTAL_PRODUCT_ARN_FIELD);
        map.put("portalProductId", PORTAL_PRODUCT_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPortalProductResponse, T> g) {
        return obj -> g.apply((GetPortalProductResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private String description;
        private String displayName;
        private DisplayOrder displayOrder;
        private Instant lastModified;
        private String portalProductArn;
        private String portalProductId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPortalProductResponse model) {
            super(model);
            this.description(model.description);
            this.displayName(model.displayName);
            this.displayOrder(model.displayOrder);
            this.lastModified(model.lastModified);
            this.portalProductArn(model.portalProductArn);
            this.portalProductId(model.portalProductId);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final DisplayOrder.Builder getDisplayOrder() {
            return this.displayOrder != null ? this.displayOrder.toBuilder() : null;
        }

        public final void setDisplayOrder(DisplayOrder.BuilderImpl displayOrder) {
            this.displayOrder = displayOrder != null ? displayOrder.build() : null;
        }

        @Override
        public final Builder displayOrder(DisplayOrder displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getPortalProductArn() {
            return this.portalProductArn;
        }

        public final void setPortalProductArn(String portalProductArn) {
            this.portalProductArn = portalProductArn;
        }

        @Override
        public final Builder portalProductArn(String portalProductArn) {
            this.portalProductArn = portalProductArn;
            return this;
        }

        public final String getPortalProductId() {
            return this.portalProductId;
        }

        public final void setPortalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
        }

        @Override
        public final Builder portalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetPortalProductResponse build() {
            return new GetPortalProductResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPortalProductResponse> {
        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder displayOrder(DisplayOrder var1);

        default public Builder displayOrder(Consumer<DisplayOrder.Builder> displayOrder) {
            return this.displayOrder((DisplayOrder)((DisplayOrder.Builder)DisplayOrder.builder().applyMutation(displayOrder)).build());
        }

        public Builder lastModified(Instant var1);

        public Builder portalProductArn(String var1);

        public Builder portalProductId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

