/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPortalProductSharingPolicyResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, GetPortalProductSharingPolicyResponse> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(GetPortalProductSharingPolicyResponse.getter(GetPortalProductSharingPolicyResponse::policyDocument)).setter(GetPortalProductSharingPolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> PORTAL_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductId").getter(GetPortalProductSharingPolicyResponse.getter(GetPortalProductSharingPolicyResponse::portalProductId)).setter(GetPortalProductSharingPolicyResponse.setter(Builder::portalProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalProductId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD, PORTAL_PRODUCT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPortalProductSharingPolicyResponse.memberNameToFieldInitializer();
    private final String policyDocument;
    private final String portalProductId;

    private GetPortalProductSharingPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyDocument = builder.policyDocument;
        this.portalProductId = builder.portalProductId;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final String portalProductId() {
        return this.portalProductId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPortalProductSharingPolicyResponse)) {
            return false;
        }
        GetPortalProductSharingPolicyResponse other = (GetPortalProductSharingPolicyResponse)((Object)obj);
        return Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.portalProductId(), other.portalProductId());
    }

    public final String toString() {
        return ToString.builder((String)"GetPortalProductSharingPolicyResponse").add("PolicyDocument", (Object)this.policyDocument()).add("PortalProductId", (Object)this.portalProductId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "PortalProductId": {
                return Optional.ofNullable(clazz.cast(this.portalProductId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("portalProductId", PORTAL_PRODUCT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPortalProductSharingPolicyResponse, T> g) {
        return obj -> g.apply((GetPortalProductSharingPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private String policyDocument;
        private String portalProductId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPortalProductSharingPolicyResponse model) {
            super(model);
            this.policyDocument(model.policyDocument);
            this.portalProductId(model.portalProductId);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPortalProductId() {
            return this.portalProductId;
        }

        public final void setPortalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
        }

        @Override
        public final Builder portalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
            return this;
        }

        @Override
        public GetPortalProductSharingPolicyResponse build() {
            return new GetPortalProductSharingPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPortalProductSharingPolicyResponse> {
        public Builder policyDocument(String var1);

        public Builder portalProductId(String var1);
    }
}

