/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.PreviewStatus;
import software.amazon.awssdk.services.apigatewayv2.model.StatusException;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Preview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Preview> {
    private static final SdkField<String> PREVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviewStatus").getter(Preview.getter(Preview::previewStatusAsString)).setter(Preview.setter(Builder::previewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewStatus").build()}).build();
    private static final SdkField<String> PREVIEW_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviewUrl").getter(Preview.getter(Preview::previewUrl)).setter(Preview.setter(Builder::previewUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewUrl").build()}).build();
    private static final SdkField<StatusException> STATUS_EXCEPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusException").getter(Preview.getter(Preview::statusException)).setter(Preview.setter(Builder::statusException)).constructor(StatusException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusException").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_STATUS_FIELD, PREVIEW_URL_FIELD, STATUS_EXCEPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Preview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String previewStatus;
    private final String previewUrl;
    private final StatusException statusException;

    private Preview(BuilderImpl builder) {
        this.previewStatus = builder.previewStatus;
        this.previewUrl = builder.previewUrl;
        this.statusException = builder.statusException;
    }

    public final PreviewStatus previewStatus() {
        return PreviewStatus.fromValue(this.previewStatus);
    }

    public final String previewStatusAsString() {
        return this.previewStatus;
    }

    public final String previewUrl() {
        return this.previewUrl;
    }

    public final StatusException statusException() {
        return this.statusException;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.previewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previewUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusException());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preview)) {
            return false;
        }
        Preview other = (Preview)obj;
        return Objects.equals(this.previewStatusAsString(), other.previewStatusAsString()) && Objects.equals(this.previewUrl(), other.previewUrl()) && Objects.equals(this.statusException(), other.statusException());
    }

    public final String toString() {
        return ToString.builder((String)"Preview").add("PreviewStatus", (Object)this.previewStatusAsString()).add("PreviewUrl", (Object)this.previewUrl()).add("StatusException", (Object)this.statusException()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreviewStatus": {
                return Optional.ofNullable(clazz.cast(this.previewStatusAsString()));
            }
            case "PreviewUrl": {
                return Optional.ofNullable(clazz.cast(this.previewUrl()));
            }
            case "StatusException": {
                return Optional.ofNullable(clazz.cast(this.statusException()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("previewStatus", PREVIEW_STATUS_FIELD);
        map.put("previewUrl", PREVIEW_URL_FIELD);
        map.put("statusException", STATUS_EXCEPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Preview, T> g) {
        return obj -> g.apply((Preview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String previewStatus;
        private String previewUrl;
        private StatusException statusException;

        private BuilderImpl() {
        }

        private BuilderImpl(Preview model) {
            this.previewStatus(model.previewStatus);
            this.previewUrl(model.previewUrl);
            this.statusException(model.statusException);
        }

        public final String getPreviewStatus() {
            return this.previewStatus;
        }

        public final void setPreviewStatus(String previewStatus) {
            this.previewStatus = previewStatus;
        }

        @Override
        public final Builder previewStatus(String previewStatus) {
            this.previewStatus = previewStatus;
            return this;
        }

        @Override
        public final Builder previewStatus(PreviewStatus previewStatus) {
            this.previewStatus(previewStatus == null ? null : previewStatus.toString());
            return this;
        }

        public final String getPreviewUrl() {
            return this.previewUrl;
        }

        public final void setPreviewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
        }

        @Override
        public final Builder previewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
            return this;
        }

        public final StatusException.Builder getStatusException() {
            return this.statusException != null ? this.statusException.toBuilder() : null;
        }

        public final void setStatusException(StatusException.BuilderImpl statusException) {
            this.statusException = statusException != null ? statusException.build() : null;
        }

        @Override
        public final Builder statusException(StatusException statusException) {
            this.statusException = statusException;
            return this;
        }

        public Preview build() {
            return new Preview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Preview> {
        public Builder previewStatus(String var1);

        public Builder previewStatus(PreviewStatus var1);

        public Builder previewUrl(String var1);

        public Builder statusException(StatusException var1);

        default public Builder statusException(Consumer<StatusException.Builder> statusException) {
            return this.statusException((StatusException)((StatusException.Builder)StatusException.builder().applyMutation(statusException)).build());
        }
    }
}

