/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListPortalsRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListPortalsResponse;
import software.amazon.awssdk.services.apigatewayv2.model.PortalSummary;

public class ListPortalsPublisher
implements SdkPublisher<ListPortalsResponse> {
    private final ApiGatewayV2AsyncClient client;
    private final ListPortalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPortalsPublisher(ApiGatewayV2AsyncClient client, ListPortalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPortalsPublisher(ApiGatewayV2AsyncClient client, ListPortalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPortalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPortalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PortalSummary> items() {
        Function<ListPortalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPortalsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPortalsResponseFetcher
    implements AsyncPageFetcher<ListPortalsResponse> {
        private ListPortalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPortalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPortalsResponse> nextPage(ListPortalsResponse previousPage) {
            if (previousPage == null) {
                return ListPortalsPublisher.this.client.listPortals(ListPortalsPublisher.this.firstRequest);
            }
            return ListPortalsPublisher.this.client.listPortals((ListPortalsRequest)((Object)ListPortalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

