/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2Client;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductPagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductPagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ProductPageSummaryNoBody;

public class ListProductPagesIterable
implements SdkIterable<ListProductPagesResponse> {
    private final ApiGatewayV2Client client;
    private final ListProductPagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProductPagesIterable(ApiGatewayV2Client client, ListProductPagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProductPagesResponseFetcher();
    }

    public Iterator<ListProductPagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProductPageSummaryNoBody> items() {
        Function<ListProductPagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProductPagesResponseFetcher
    implements SyncPageFetcher<ListProductPagesResponse> {
        private ListProductPagesResponseFetcher() {
        }

        public boolean hasNextPage(ListProductPagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProductPagesResponse nextPage(ListProductPagesResponse previousPage) {
            if (previousPage == null) {
                return ListProductPagesIterable.this.client.listProductPages(ListProductPagesIterable.this.firstRequest);
            }
            return ListProductPagesIterable.this.client.listProductPages((ListProductPagesRequest)((Object)ListProductPagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

