/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient;
import software.amazon.awssdk.services.apigatewayv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductPagesRequest;
import software.amazon.awssdk.services.apigatewayv2.model.ListProductPagesResponse;
import software.amazon.awssdk.services.apigatewayv2.model.ProductPageSummaryNoBody;

public class ListProductPagesPublisher
implements SdkPublisher<ListProductPagesResponse> {
    private final ApiGatewayV2AsyncClient client;
    private final ListProductPagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProductPagesPublisher(ApiGatewayV2AsyncClient client, ListProductPagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProductPagesPublisher(ApiGatewayV2AsyncClient client, ListProductPagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProductPagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProductPagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProductPageSummaryNoBody> items() {
        Function<ListProductPagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProductPagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProductPagesResponseFetcher
    implements AsyncPageFetcher<ListProductPagesResponse> {
        private ListProductPagesResponseFetcher() {
        }

        public boolean hasNextPage(ListProductPagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProductPagesResponse> nextPage(ListProductPagesResponse previousPage) {
            if (previousPage == null) {
                return ListProductPagesPublisher.this.client.listProductPages(ListProductPagesPublisher.this.firstRequest);
            }
            return ListProductPagesPublisher.this.client.listProductPages((ListProductPagesRequest)((Object)ListProductPagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

