/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * Internal implementation of {@link ApiGatewayV2AsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayV2AsyncClientBuilder extends
        DefaultApiGatewayV2BaseClientBuilder<ApiGatewayV2AsyncClientBuilder, ApiGatewayV2AsyncClient> implements
        ApiGatewayV2AsyncClientBuilder {
    @Override
    protected final ApiGatewayV2AsyncClient buildClient() {
        return new DefaultApiGatewayV2AsyncClient(super.asyncClientConfiguration());
    }
}
