/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<CreateApiRequest.Builder, CreateApiRequest> {
    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiRequest::apiKeySelectionExpression)).setter(setter(Builder::apiKeySelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateApiRequest::disableSchemaValidation)).setter(setter(Builder::disableSchemaValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiRequest::protocolTypeAsString)).setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()).build();

    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiRequest::routeSelectionExpression)).setter(setter(Builder::routeSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build())
            .build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateApiRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            API_KEY_SELECTION_EXPRESSION_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, NAME_FIELD,
            PROTOCOL_TYPE_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, VERSION_FIELD, TAGS_FIELD));

    private final String apiKeySelectionExpression;

    private final String description;

    private final Boolean disableSchemaValidation;

    private final String name;

    private final String protocolType;

    private final String routeSelectionExpression;

    private final String version;

    private final Map<String, String> tags;

    private CreateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.version = builder.version;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An API key selection expression. See <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     * >API Key Selection Expressions</a>.
     * </p>
     * 
     * @return An API key selection expression. See <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     *         >API Key Selection Expressions</a>.
     */
    public String apiKeySelectionExpression() {
        return apiKeySelectionExpression;
    }

    /**
     * <p>
     * The description of the API.
     * </p>
     * 
     * @return The description of the API.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Avoid validating models when creating a deployment.
     * </p>
     * 
     * @return Avoid validating models when creating a deployment.
     */
    public Boolean disableSchemaValidation() {
        return disableSchemaValidation;
    }

    /**
     * <p>
     * The name of the API.
     * </p>
     * 
     * @return The name of the API.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The API protocol: Currently only WEBSOCKET is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The API protocol: Currently only WEBSOCKET is supported.
     * @see ProtocolType
     */
    public ProtocolType protocolType() {
        return ProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * The API protocol: Currently only WEBSOCKET is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The API protocol: Currently only WEBSOCKET is supported.
     * @see ProtocolType
     */
    public String protocolTypeAsString() {
        return protocolType;
    }

    /**
     * <p>
     * The route selection expression for the API.
     * </p>
     * 
     * @return The route selection expression for the API.
     */
    public String routeSelectionExpression() {
        return routeSelectionExpression;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters
     * and must not start with aws:. The tag value can be up to 256 characters..
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
     *         characters and must not start with aws:. The tag value can be up to 256 characters..
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiRequest)) {
            return false;
        }
        CreateApiRequest other = (CreateApiRequest) obj;
        return Objects.equals(apiKeySelectionExpression(), other.apiKeySelectionExpression())
                && Objects.equals(description(), other.description())
                && Objects.equals(disableSchemaValidation(), other.disableSchemaValidation())
                && Objects.equals(name(), other.name()) && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString())
                && Objects.equals(routeSelectionExpression(), other.routeSelectionExpression())
                && Objects.equals(version(), other.version()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateApiRequest").add("ApiKeySelectionExpression", apiKeySelectionExpression())
                .add("Description", description()).add("DisableSchemaValidation", disableSchemaValidation()).add("Name", name())
                .add("ProtocolType", protocolTypeAsString()).add("RouteSelectionExpression", routeSelectionExpression())
                .add("Version", version()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiKeySelectionExpression":
            return Optional.ofNullable(clazz.cast(apiKeySelectionExpression()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisableSchemaValidation":
            return Optional.ofNullable(clazz.cast(disableSchemaValidation()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProtocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        case "RouteSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeSelectionExpression()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiRequest, T> g) {
        return obj -> g.apply((CreateApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateApiRequest> {
        /**
         * <p>
         * An API key selection expression. See <a href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         * >API Key Selection Expressions</a>.
         * </p>
         * 
         * @param apiKeySelectionExpression
         *        An API key selection expression. See <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         *        >API Key Selection Expressions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySelectionExpression(String apiKeySelectionExpression);

        /**
         * <p>
         * The description of the API.
         * </p>
         * 
         * @param description
         *        The description of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Avoid validating models when creating a deployment.
         * </p>
         * 
         * @param disableSchemaValidation
         *        Avoid validating models when creating a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSchemaValidation(Boolean disableSchemaValidation);

        /**
         * <p>
         * The name of the API.
         * </p>
         * 
         * @param name
         *        The name of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API protocol: Currently only WEBSOCKET is supported.
         * </p>
         * 
         * @param protocolType
         *        The API protocol: Currently only WEBSOCKET is supported.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The API protocol: Currently only WEBSOCKET is supported.
         * </p>
         * 
         * @param protocolType
         *        The API protocol: Currently only WEBSOCKET is supported.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(ProtocolType protocolType);

        /**
         * <p>
         * The route selection expression for the API.
         * </p>
         * 
         * @param routeSelectionExpression
         *        The route selection expression for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSelectionExpression(String routeSelectionExpression);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         * characters and must not start with aws:. The tag value can be up to 256 characters..
         * </p>
         * 
         * @param tags
         *        The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         *        characters and must not start with aws:. The tag value can be up to 256 characters..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiKeySelectionExpression;

        private String description;

        private Boolean disableSchemaValidation;

        private String name;

        private String protocolType;

        private String routeSelectionExpression;

        private String version;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiRequest model) {
            super(model);
            apiKeySelectionExpression(model.apiKeySelectionExpression);
            description(model.description);
            disableSchemaValidation(model.disableSchemaValidation);
            name(model.name);
            protocolType(model.protocolType);
            routeSelectionExpression(model.routeSelectionExpression);
            version(model.version);
            tags(model.tags);
        }

        public final String getApiKeySelectionExpression() {
            return apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getDisableSchemaValidation() {
            return disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocolTypeAsString() {
            return protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        public final String getRouteSelectionExpression() {
            return routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiRequest build() {
            return new CreateApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
