/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiMappingResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<UpdateApiMappingResponse.Builder, UpdateApiMappingResponse> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiMappingResponse::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> API_MAPPING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiMappingResponse::apiMappingId)).setter(setter(Builder::apiMappingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingId").build()).build();

    private static final SdkField<String> API_MAPPING_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiMappingResponse::apiMappingKey)).setter(setter(Builder::apiMappingKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingKey").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiMappingResponse::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            API_MAPPING_ID_FIELD, API_MAPPING_KEY_FIELD, STAGE_FIELD));

    private final String apiId;

    private final String apiMappingId;

    private final String apiMappingKey;

    private final String stage;

    private UpdateApiMappingResponse(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiMappingId = builder.apiMappingId;
        this.apiMappingKey = builder.apiMappingKey;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The API mapping identifier.
     * </p>
     * 
     * @return The API mapping identifier.
     */
    public String apiMappingId() {
        return apiMappingId;
    }

    /**
     * <p>
     * The API mapping key.
     * </p>
     * 
     * @return The API mapping key.
     */
    public String apiMappingKey() {
        return apiMappingKey;
    }

    /**
     * <p>
     * The API stage.
     * </p>
     * 
     * @return The API stage.
     */
    public String stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiMappingId());
        hashCode = 31 * hashCode + Objects.hashCode(apiMappingKey());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiMappingResponse)) {
            return false;
        }
        UpdateApiMappingResponse other = (UpdateApiMappingResponse) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(apiMappingId(), other.apiMappingId())
                && Objects.equals(apiMappingKey(), other.apiMappingKey()) && Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateApiMappingResponse").add("ApiId", apiId()).add("ApiMappingId", apiMappingId())
                .add("ApiMappingKey", apiMappingKey()).add("Stage", stage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiMappingId":
            return Optional.ofNullable(clazz.cast(apiMappingId()));
        case "ApiMappingKey":
            return Optional.ofNullable(clazz.cast(apiMappingKey()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiMappingResponse, T> g) {
        return obj -> g.apply((UpdateApiMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiMappingResponse> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The API mapping identifier.
         * </p>
         * 
         * @param apiMappingId
         *        The API mapping identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiMappingId(String apiMappingId);

        /**
         * <p>
         * The API mapping key.
         * </p>
         * 
         * @param apiMappingKey
         *        The API mapping key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiMappingKey(String apiMappingKey);

        /**
         * <p>
         * The API stage.
         * </p>
         * 
         * @param stage
         *        The API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String apiId;

        private String apiMappingId;

        private String apiMappingKey;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiMappingResponse model) {
            super(model);
            apiId(model.apiId);
            apiMappingId(model.apiMappingId);
            apiMappingKey(model.apiMappingKey);
            stage(model.stage);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiMappingId() {
            return apiMappingId;
        }

        @Override
        public final Builder apiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
            return this;
        }

        public final void setApiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
        }

        public final String getApiMappingKey() {
            return apiMappingKey;
        }

        @Override
        public final Builder apiMappingKey(String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
            return this;
        }

        public final void setApiMappingKey(String apiMappingKey) {
            this.apiMappingKey = apiMappingKey;
        }

        public final String getStage() {
            return stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public UpdateApiMappingResponse build() {
            return new UpdateApiMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
