/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateApiRequest.Builder, UpdateApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiRequest::apiKeySelectionExpression)).setter(setter(Builder::apiKeySelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateApiRequest::disableSchemaValidation)).setter(setter(Builder::disableSchemaValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiRequest::routeSelectionExpression)).setter(setter(Builder::routeSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build())
            .build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateApiRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            API_KEY_SELECTION_EXPRESSION_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, NAME_FIELD,
            ROUTE_SELECTION_EXPRESSION_FIELD, VERSION_FIELD));

    private final String apiId;

    private final String apiKeySelectionExpression;

    private final String description;

    private final Boolean disableSchemaValidation;

    private final String name;

    private final String routeSelectionExpression;

    private final String version;

    private UpdateApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.name = builder.name;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.version = builder.version;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * An API key selection expression. See <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     * >API Key Selection Expressions</a>.
     * </p>
     * 
     * @return An API key selection expression. See <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     *         >API Key Selection Expressions</a>.
     */
    public String apiKeySelectionExpression() {
        return apiKeySelectionExpression;
    }

    /**
     * <p>
     * The description of the API.
     * </p>
     * 
     * @return The description of the API.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Avoid validating models when creating a deployment.
     * </p>
     * 
     * @return Avoid validating models when creating a deployment.
     */
    public Boolean disableSchemaValidation() {
        return disableSchemaValidation;
    }

    /**
     * <p>
     * The name of the API.
     * </p>
     * 
     * @return The name of the API.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The route selection expression for the API.
     * </p>
     * 
     * @return The route selection expression for the API.
     */
    public String routeSelectionExpression() {
        return routeSelectionExpression;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiRequest)) {
            return false;
        }
        UpdateApiRequest other = (UpdateApiRequest) obj;
        return Objects.equals(apiId(), other.apiId())
                && Objects.equals(apiKeySelectionExpression(), other.apiKeySelectionExpression())
                && Objects.equals(description(), other.description())
                && Objects.equals(disableSchemaValidation(), other.disableSchemaValidation())
                && Objects.equals(name(), other.name())
                && Objects.equals(routeSelectionExpression(), other.routeSelectionExpression())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateApiRequest").add("ApiId", apiId())
                .add("ApiKeySelectionExpression", apiKeySelectionExpression()).add("Description", description())
                .add("DisableSchemaValidation", disableSchemaValidation()).add("Name", name())
                .add("RouteSelectionExpression", routeSelectionExpression()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiKeySelectionExpression":
            return Optional.ofNullable(clazz.cast(apiKeySelectionExpression()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisableSchemaValidation":
            return Optional.ofNullable(clazz.cast(disableSchemaValidation()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RouteSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeSelectionExpression()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiRequest, T> g) {
        return obj -> g.apply((UpdateApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * An API key selection expression. See <a href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         * >API Key Selection Expressions</a>.
         * </p>
         * 
         * @param apiKeySelectionExpression
         *        An API key selection expression. See <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         *        >API Key Selection Expressions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySelectionExpression(String apiKeySelectionExpression);

        /**
         * <p>
         * The description of the API.
         * </p>
         * 
         * @param description
         *        The description of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Avoid validating models when creating a deployment.
         * </p>
         * 
         * @param disableSchemaValidation
         *        Avoid validating models when creating a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSchemaValidation(Boolean disableSchemaValidation);

        /**
         * <p>
         * The name of the API.
         * </p>
         * 
         * @param name
         *        The name of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The route selection expression for the API.
         * </p>
         * 
         * @param routeSelectionExpression
         *        The route selection expression for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSelectionExpression(String routeSelectionExpression);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String apiKeySelectionExpression;

        private String description;

        private Boolean disableSchemaValidation;

        private String name;

        private String routeSelectionExpression;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiRequest model) {
            super(model);
            apiId(model.apiId);
            apiKeySelectionExpression(model.apiKeySelectionExpression);
            description(model.description);
            disableSchemaValidation(model.disableSchemaValidation);
            name(model.name);
            routeSelectionExpression(model.routeSelectionExpression);
            version(model.version);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiKeySelectionExpression() {
            return apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getDisableSchemaValidation() {
            return disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRouteSelectionExpression() {
            return routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiRequest build() {
            return new UpdateApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
