/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationProfileRequest extends AppConfigRequest implements
        ToCopyableBuilder<CreateConfigurationProfileRequest.Builder, CreateConfigurationProfileRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConfigurationProfileRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConfigurationProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConfigurationProfileRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConfigurationProfileRequest::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConfigurationProfileRequest::retrievalRoleArn)).setter(setter(Builder::retrievalRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()).build();

    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField
            .<List<Validator>> builder(MarshallingType.LIST)
            .getter(getter(CreateConfigurationProfileRequest::validators))
            .setter(setter(Builder::validators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Validator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Validator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateConfigurationProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD, TAGS_FIELD));

    private final String applicationId;

    private final String name;

    private final String description;

    private final String locationUri;

    private final String retrievalRoleArn;

    private final List<Validator> validators;

    private final Map<String, String> tags;

    private CreateConfigurationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A name for the configuration profile.
     * </p>
     * 
     * @return A name for the configuration profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the configuration profile.
     * </p>
     * 
     * @return A description of the configuration profile.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A URI to locate the configuration. You can specify either a Systems Manager (SSM) document or an SSM Parameter
     * Store parameter. For an SSM document, specify either the document name in the format
     * <code>ssm-document://&lt;Document name&gt;</code> or the Amazon Resource Name (ARN). For a parameter, specify
     * either the parameter name in the format <code>ssm-parameter://&lt;Parameter name&gt;</code> or the ARN.
     * </p>
     * 
     * @return A URI to locate the configuration. You can specify either a Systems Manager (SSM) document or an SSM
     *         Parameter Store parameter. For an SSM document, specify either the document name in the format
     *         <code>ssm-document://&lt;Document name&gt;</code> or the Amazon Resource Name (ARN). For a parameter,
     *         specify either the parameter name in the format <code>ssm-parameter://&lt;Parameter name&gt;</code> or
     *         the ARN.
     */
    public String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
     * </p>
     * 
     * @return The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
     */
    public String retrievalRoleArn() {
        return retrievalRoleArn;
    }

    /**
     * <p>
     * A list of methods for validating the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of methods for validating the configuration.
     */
    public List<Validator> validators() {
        return validators;
    }

    /**
     * <p>
     * Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each
     * tag consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig
     *         resources. Each tag consists of a key and an optional value, both of which you define.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(validators());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationProfileRequest)) {
            return false;
        }
        CreateConfigurationProfileRequest other = (CreateConfigurationProfileRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(retrievalRoleArn(), other.retrievalRoleArn())
                && Objects.equals(validators(), other.validators()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateConfigurationProfileRequest").add("ApplicationId", applicationId()).add("Name", name())
                .add("Description", description()).add("LocationUri", locationUri()).add("RetrievalRoleArn", retrievalRoleArn())
                .add("Validators", validators()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "RetrievalRoleArn":
            return Optional.ofNullable(clazz.cast(retrievalRoleArn()));
        case "Validators":
            return Optional.ofNullable(clazz.cast(validators()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationProfileRequest, T> g) {
        return obj -> g.apply((CreateConfigurationProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationProfileRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A name for the configuration profile.
         * </p>
         * 
         * @param name
         *        A name for the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the configuration profile.
         * </p>
         * 
         * @param description
         *        A description of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A URI to locate the configuration. You can specify either a Systems Manager (SSM) document or an SSM
         * Parameter Store parameter. For an SSM document, specify either the document name in the format
         * <code>ssm-document://&lt;Document name&gt;</code> or the Amazon Resource Name (ARN). For a parameter, specify
         * either the parameter name in the format <code>ssm-parameter://&lt;Parameter name&gt;</code> or the ARN.
         * </p>
         * 
         * @param locationUri
         *        A URI to locate the configuration. You can specify either a Systems Manager (SSM) document or an SSM
         *        Parameter Store parameter. For an SSM document, specify either the document name in the format
         *        <code>ssm-document://&lt;Document name&gt;</code> or the Amazon Resource Name (ARN). For a parameter,
         *        specify either the parameter name in the format <code>ssm-parameter://&lt;Parameter name&gt;</code> or
         *        the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
         * </p>
         * 
         * @param retrievalRoleArn
         *        The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalRoleArn(String retrievalRoleArn);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Collection<Validator> validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Validator... validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Validator>.Builder} avoiding the need to
         * create one manually via {@link List<Validator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Validator>.Builder#build()} is called immediately and its
         * result is passed to {@link #validators(List<Validator>)}.
         * 
         * @param validators
         *        a consumer that will call methods on {@link List<Validator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validators(List<Validator>)
         */
        Builder validators(Consumer<Validator.Builder>... validators);

        /**
         * <p>
         * Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources.
         * Each tag consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig
         *        resources. Each tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String name;

        private String description;

        private String locationUri;

        private String retrievalRoleArn;

        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationProfileRequest model) {
            super(model);
            applicationId(model.applicationId);
            name(model.name);
            description(model.description);
            locationUri(model.locationUri);
            retrievalRoleArn(model.retrievalRoleArn);
            validators(model.validators);
            tags(model.tags);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final String getRetrievalRoleArn() {
            return retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        public final Collection<Validator.Builder> getValidators() {
            return validators != null ? validators.stream().map(Validator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator... validators) {
            validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder>... validators) {
            validators(Stream.of(validators).map(c -> Validator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationProfileRequest build() {
            return new CreateConfigurationProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
