/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.DeploymentState;
import software.amazon.awssdk.services.appconfig.model.GrowthType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, GetDeploymentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::applicationId)).setter(GetDeploymentResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::environmentId)).setter(GetDeploymentResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentStrategyId)).setter(GetDeploymentResponse.setter(Builder::deploymentStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::configurationProfileId)).setter(GetDeploymentResponse.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentNumber)).setter(GetDeploymentResponse.setter(Builder::deploymentNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentNumber").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::configurationName)).setter(GetDeploymentResponse.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> CONFIGURATION_LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::configurationLocationUri)).setter(GetDeploymentResponse.setter(Builder::configurationLocationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationLocationUri").build()}).build();
    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::configurationVersion)).setter(GetDeploymentResponse.setter(Builder::configurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::description)).setter(GetDeploymentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentDurationInMinutes)).setter(GetDeploymentResponse.setter(Builder::deploymentDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes").build()}).build();
    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::growthTypeAsString)).setter(GetDeploymentResponse.setter(Builder::growthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()}).build();
    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(GetDeploymentResponse.getter(GetDeploymentResponse::growthFactor)).setter(GetDeploymentResponse.setter(Builder::growthFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()}).build();
    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetDeploymentResponse.getter(GetDeploymentResponse::finalBakeTimeInMinutes)).setter(GetDeploymentResponse.setter(Builder::finalBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeploymentResponse.getter(GetDeploymentResponse::stateAsString)).setter(GetDeploymentResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Float> PERCENTAGE_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(GetDeploymentResponse.getter(GetDeploymentResponse::percentageComplete)).setter(GetDeploymentResponse.setter(Builder::percentageComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetDeploymentResponse.getter(GetDeploymentResponse::startedAt)).setter(GetDeploymentResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetDeploymentResponse.getter(GetDeploymentResponse::completedAt)).setter(GetDeploymentResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, DEPLOYMENT_NUMBER_FIELD, CONFIGURATION_NAME_FIELD, CONFIGURATION_LOCATION_URI_FIELD, CONFIGURATION_VERSION_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD, GROWTH_FACTOR_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, STATE_FIELD, PERCENTAGE_COMPLETE_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD));
    private final String applicationId;
    private final String environmentId;
    private final String deploymentStrategyId;
    private final String configurationProfileId;
    private final Integer deploymentNumber;
    private final String configurationName;
    private final String configurationLocationUri;
    private final String configurationVersion;
    private final String description;
    private final Integer deploymentDurationInMinutes;
    private final String growthType;
    private final Float growthFactor;
    private final Integer finalBakeTimeInMinutes;
    private final String state;
    private final Float percentageComplete;
    private final Instant startedAt;
    private final Instant completedAt;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.deploymentNumber = builder.deploymentNumber;
        this.configurationName = builder.configurationName;
        this.configurationLocationUri = builder.configurationLocationUri;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.state = builder.state;
        this.percentageComplete = builder.percentageComplete;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String deploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    public String configurationProfileId() {
        return this.configurationProfileId;
    }

    public Integer deploymentNumber() {
        return this.deploymentNumber;
    }

    public String configurationName() {
        return this.configurationName;
    }

    public String configurationLocationUri() {
        return this.configurationLocationUri;
    }

    public String configurationVersion() {
        return this.configurationVersion;
    }

    public String description() {
        return this.description;
    }

    public Integer deploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    public GrowthType growthType() {
        return GrowthType.fromValue(this.growthType);
    }

    public String growthTypeAsString() {
        return this.growthType;
    }

    public Float growthFactor() {
        return this.growthFactor;
    }

    public Integer finalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    public DeploymentState state() {
        return DeploymentState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Float percentageComplete() {
        return this.percentageComplete;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public Instant completedAt() {
        return this.completedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationLocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.deploymentStrategyId(), other.deploymentStrategyId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.deploymentNumber(), other.deploymentNumber()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.configurationLocationUri(), other.configurationLocationUri()) && Objects.equals(this.configurationVersion(), other.configurationVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deploymentDurationInMinutes(), other.deploymentDurationInMinutes()) && Objects.equals(this.growthTypeAsString(), other.growthTypeAsString()) && Objects.equals(this.growthFactor(), other.growthFactor()) && Objects.equals(this.finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.percentageComplete(), other.percentageComplete()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt());
    }

    public String toString() {
        return ToString.builder((String)"GetDeploymentResponse").add("ApplicationId", (Object)this.applicationId()).add("EnvironmentId", (Object)this.environmentId()).add("DeploymentStrategyId", (Object)this.deploymentStrategyId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("DeploymentNumber", (Object)this.deploymentNumber()).add("ConfigurationName", (Object)this.configurationName()).add("ConfigurationLocationUri", (Object)this.configurationLocationUri()).add("ConfigurationVersion", (Object)this.configurationVersion()).add("Description", (Object)this.description()).add("DeploymentDurationInMinutes", (Object)this.deploymentDurationInMinutes()).add("GrowthType", (Object)this.growthTypeAsString()).add("GrowthFactor", (Object)this.growthFactor()).add("FinalBakeTimeInMinutes", (Object)this.finalBakeTimeInMinutes()).add("State", (Object)this.stateAsString()).add("PercentageComplete", (Object)this.percentageComplete()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "DeploymentStrategyId": {
                return Optional.ofNullable(clazz.cast(this.deploymentStrategyId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "DeploymentNumber": {
                return Optional.ofNullable(clazz.cast(this.deploymentNumber()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "ConfigurationLocationUri": {
                return Optional.ofNullable(clazz.cast(this.configurationLocationUri()));
            }
            case "ConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.configurationVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeploymentDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.deploymentDurationInMinutes()));
            }
            case "GrowthType": {
                return Optional.ofNullable(clazz.cast(this.growthTypeAsString()));
            }
            case "GrowthFactor": {
                return Optional.ofNullable(clazz.cast(this.growthFactor()));
            }
            case "FinalBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.finalBakeTimeInMinutes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PercentageComplete": {
                return Optional.ofNullable(clazz.cast(this.percentageComplete()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String environmentId;
        private String deploymentStrategyId;
        private String configurationProfileId;
        private Integer deploymentNumber;
        private String configurationName;
        private String configurationLocationUri;
        private String configurationVersion;
        private String description;
        private Integer deploymentDurationInMinutes;
        private String growthType;
        private Float growthFactor;
        private Integer finalBakeTimeInMinutes;
        private String state;
        private Float percentageComplete;
        private Instant startedAt;
        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.environmentId(model.environmentId);
            this.deploymentStrategyId(model.deploymentStrategyId);
            this.configurationProfileId(model.configurationProfileId);
            this.deploymentNumber(model.deploymentNumber);
            this.configurationName(model.configurationName);
            this.configurationLocationUri(model.configurationLocationUri);
            this.configurationVersion(model.configurationVersion);
            this.description(model.description);
            this.deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            this.growthType(model.growthType);
            this.growthFactor(model.growthFactor);
            this.finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            this.state(model.state);
            this.percentageComplete(model.percentageComplete);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getDeploymentStrategyId() {
            return this.deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        public final Integer getDeploymentNumber() {
            return this.deploymentNumber;
        }

        @Override
        public final Builder deploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        public final void setDeploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public final String getConfigurationLocationUri() {
            return this.configurationLocationUri;
        }

        @Override
        public final Builder configurationLocationUri(String configurationLocationUri) {
            this.configurationLocationUri = configurationLocationUri;
            return this;
        }

        public final void setConfigurationLocationUri(String configurationLocationUri) {
            this.configurationLocationUri = configurationLocationUri;
        }

        public final String getConfigurationVersion() {
            return this.configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        public final String getGrowthTypeAsString() {
            return this.growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        public final Float getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DeploymentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Float getPercentageComplete() {
            return this.percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final void setPercentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentResponse> {
        public Builder applicationId(String var1);

        public Builder environmentId(String var1);

        public Builder deploymentStrategyId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder deploymentNumber(Integer var1);

        public Builder configurationName(String var1);

        public Builder configurationLocationUri(String var1);

        public Builder configurationVersion(String var1);

        public Builder description(String var1);

        public Builder deploymentDurationInMinutes(Integer var1);

        public Builder growthType(String var1);

        public Builder growthType(GrowthType var1);

        public Builder growthFactor(Float var1);

        public Builder finalBakeTimeInMinutes(Integer var1);

        public Builder state(String var1);

        public Builder state(DeploymentState var1);

        public Builder percentageComplete(Float var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);
    }
}

