/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a configuration profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationProfileSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationProfileSummary.Builder, ConfigurationProfileSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationProfileSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationProfileSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationProfileSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationProfileSummary::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<List<String>> VALIDATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ConfigurationProfileSummary::validatorTypesAsStrings))
            .setter(setter(Builder::validatorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidatorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ID_FIELD, NAME_FIELD, LOCATION_URI_FIELD, VALIDATOR_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String id;

    private final String name;

    private final String locationUri;

    private final List<String> validatorTypes;

    private ConfigurationProfileSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.locationUri = builder.locationUri;
        this.validatorTypes = builder.validatorTypes;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the configuration profile.
     * </p>
     * 
     * @return The ID of the configuration profile.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the configuration profile.
     * </p>
     * 
     * @return The name of the configuration profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The URI location of the configuration.
     * </p>
     * 
     * @return The URI location of the configuration.
     */
    public String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The types of validators in the configuration profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidatorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The types of validators in the configuration profile.
     */
    public List<ValidatorType> validatorTypes() {
        return ValidatorTypeListCopier.copyStringToEnum(validatorTypes);
    }

    /**
     * Returns true if the ValidatorTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValidatorTypes() {
        return validatorTypes != null && !(validatorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of validators in the configuration profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidatorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The types of validators in the configuration profile.
     */
    public List<String> validatorTypesAsStrings() {
        return validatorTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(validatorTypesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationProfileSummary)) {
            return false;
        }
        ConfigurationProfileSummary other = (ConfigurationProfileSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(validatorTypesAsStrings(), other.validatorTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigurationProfileSummary").add("ApplicationId", applicationId()).add("Id", id())
                .add("Name", name()).add("LocationUri", locationUri()).add("ValidatorTypes", validatorTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "ValidatorTypes":
            return Optional.ofNullable(clazz.cast(validatorTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationProfileSummary, T> g) {
        return obj -> g.apply((ConfigurationProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationProfileSummary> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the configuration profile.
         * </p>
         * 
         * @param id
         *        The ID of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the configuration profile.
         * </p>
         * 
         * @param name
         *        The name of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URI location of the configuration.
         * </p>
         * 
         * @param locationUri
         *        The URI location of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The types of validators in the configuration profile.
         * </p>
         * 
         * @param validatorTypes
         *        The types of validators in the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validatorTypesWithStrings(Collection<String> validatorTypes);

        /**
         * <p>
         * The types of validators in the configuration profile.
         * </p>
         * 
         * @param validatorTypes
         *        The types of validators in the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validatorTypesWithStrings(String... validatorTypes);

        /**
         * <p>
         * The types of validators in the configuration profile.
         * </p>
         * 
         * @param validatorTypes
         *        The types of validators in the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validatorTypes(Collection<ValidatorType> validatorTypes);

        /**
         * <p>
         * The types of validators in the configuration profile.
         * </p>
         * 
         * @param validatorTypes
         *        The types of validators in the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validatorTypes(ValidatorType... validatorTypes);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String id;

        private String name;

        private String locationUri;

        private List<String> validatorTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationProfileSummary model) {
            applicationId(model.applicationId);
            id(model.id);
            name(model.name);
            locationUri(model.locationUri);
            validatorTypesWithStrings(model.validatorTypes);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final Collection<String> getValidatorTypesAsStrings() {
            return validatorTypes;
        }

        @Override
        public final Builder validatorTypesWithStrings(Collection<String> validatorTypes) {
            this.validatorTypes = ValidatorTypeListCopier.copy(validatorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validatorTypesWithStrings(String... validatorTypes) {
            validatorTypesWithStrings(Arrays.asList(validatorTypes));
            return this;
        }

        @Override
        public final Builder validatorTypes(Collection<ValidatorType> validatorTypes) {
            this.validatorTypes = ValidatorTypeListCopier.copyEnumToString(validatorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validatorTypes(ValidatorType... validatorTypes) {
            validatorTypes(Arrays.asList(validatorTypes));
            return this;
        }

        public final void setValidatorTypesWithStrings(Collection<String> validatorTypes) {
            this.validatorTypes = ValidatorTypeListCopier.copy(validatorTypes);
        }

        @Override
        public ConfigurationProfileSummary build() {
            return new ConfigurationProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
