/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationProfileRequest extends AppConfigRequest implements
        ToCopyableBuilder<UpdateConfigurationProfileRequest.Builder, UpdateConfigurationProfileRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationProfileRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationProfileRequest::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationProfileRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationProfileRequest::retrievalRoleArn)).setter(setter(Builder::retrievalRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()).build();

    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField
            .<List<Validator>> builder(MarshallingType.LIST)
            .getter(getter(UpdateConfigurationProfileRequest::validators))
            .setter(setter(Builder::validators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Validator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Validator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_PROFILE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD));

    private final String applicationId;

    private final String configurationProfileId;

    private final String name;

    private final String description;

    private final String retrievalRoleArn;

    private final List<Validator> validators;

    private UpdateConfigurationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.name = builder.name;
        this.description = builder.description;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the configuration profile.
     * </p>
     * 
     * @return The ID of the configuration profile.
     */
    public String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The name of the configuration profile.
     * </p>
     * 
     * @return The name of the configuration profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the configuration profile.
     * </p>
     * 
     * @return A description of the configuration profile.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
     * </p>
     * 
     * @return The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
     */
    public String retrievalRoleArn() {
        return retrievalRoleArn;
    }

    /**
     * Returns true if the Validators property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValidators() {
        return validators != null && !(validators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of methods for validating the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of methods for validating the configuration.
     */
    public List<Validator> validators() {
        return validators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(validators());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationProfileRequest)) {
            return false;
        }
        UpdateConfigurationProfileRequest other = (UpdateConfigurationProfileRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(retrievalRoleArn(), other.retrievalRoleArn())
                && Objects.equals(validators(), other.validators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateConfigurationProfileRequest").add("ApplicationId", applicationId())
                .add("ConfigurationProfileId", configurationProfileId()).add("Name", name()).add("Description", description())
                .add("RetrievalRoleArn", retrievalRoleArn()).add("Validators", validators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RetrievalRoleArn":
            return Optional.ofNullable(clazz.cast(retrievalRoleArn()));
        case "Validators":
            return Optional.ofNullable(clazz.cast(validators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationProfileRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationProfileRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the configuration profile.
         * </p>
         * 
         * @param configurationProfileId
         *        The ID of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The name of the configuration profile.
         * </p>
         * 
         * @param name
         *        The name of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the configuration profile.
         * </p>
         * 
         * @param description
         *        A description of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
         * </p>
         * 
         * @param retrievalRoleArn
         *        The ARN of an IAM role with permission to access the configuration at the specified LocationUri.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalRoleArn(String retrievalRoleArn);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Collection<Validator> validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Validator... validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Validator>.Builder} avoiding the need to
         * create one manually via {@link List<Validator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Validator>.Builder#build()} is called immediately and its
         * result is passed to {@link #validators(List<Validator>)}.
         * 
         * @param validators
         *        a consumer that will call methods on {@link List<Validator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validators(List<Validator>)
         */
        Builder validators(Consumer<Validator.Builder>... validators);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String configurationProfileId;

        private String name;

        private String description;

        private String retrievalRoleArn;

        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationProfileRequest model) {
            super(model);
            applicationId(model.applicationId);
            configurationProfileId(model.configurationProfileId);
            name(model.name);
            description(model.description);
            retrievalRoleArn(model.retrievalRoleArn);
            validators(model.validators);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRetrievalRoleArn() {
            return retrievalRoleArn;
        }

        @Override
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        public final Collection<Validator.Builder> getValidators() {
            return validators != null ? validators.stream().map(Validator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Validator... validators) {
            validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder>... validators) {
            validators(Stream.of(validators).map(c -> Validator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationProfileRequest build() {
            return new UpdateConfigurationProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
