/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationResponse extends AppConfigResponse implements
        ToCopyableBuilder<GetConfigurationResponse.Builder, GetConfigurationResponse> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(GetConfigurationResponse::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationResponse::configurationVersion)).setter(setter(Builder::configurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Configuration-Version").build())
            .build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConfigurationResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            CONFIGURATION_VERSION_FIELD, CONTENT_TYPE_FIELD));

    private final SdkBytes content;

    private final String configurationVersion;

    private final String contentType;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.configurationVersion = builder.configurationVersion;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The content of the configuration or the configuration data.
     * </p>
     * 
     * @return The content of the configuration or the configuration data.
     */
    public SdkBytes content() {
        return content;
    }

    /**
     * <p>
     * The configuration version.
     * </p>
     * 
     * @return The configuration version.
     */
    public String configurationVersion() {
        return configurationVersion;
    }

    /**
     * <p>
     * A standard MIME type describing the format of the configuration content. For more information, see <a
     * href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.
     * </p>
     * 
     * @return A standard MIME type describing the format of the configuration content. For more information, see <a
     *         href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(configurationVersion(), other.configurationVersion())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConfigurationResponse").add("Content", content())
                .add("ConfigurationVersion", configurationVersion()).add("ContentType", contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ConfigurationVersion":
            return Optional.ofNullable(clazz.cast(configurationVersion()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigurationResponse> {
        /**
         * <p>
         * The content of the configuration or the configuration data.
         * </p>
         * 
         * @param content
         *        The content of the configuration or the configuration data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(SdkBytes content);

        /**
         * <p>
         * The configuration version.
         * </p>
         * 
         * @param configurationVersion
         *        The configuration version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationVersion(String configurationVersion);

        /**
         * <p>
         * A standard MIME type describing the format of the configuration content. For more information, see <a
         * href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.
         * </p>
         * 
         * @param contentType
         *        A standard MIME type describing the format of the configuration content. For more information, see <a
         *        href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private SdkBytes content;

        private String configurationVersion;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            content(model.content);
            configurationVersion(model.configurationVersion);
            contentType(model.contentType);
        }

        public final ByteBuffer getContent() {
            return content == null ? null : content.asByteBuffer();
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = StandardMemberCopier.copy(content);
            return this;
        }

        public final void setContent(ByteBuffer content) {
            content(content == null ? null : SdkBytes.fromByteBuffer(content));
        }

        public final String getConfigurationVersion() {
            return configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
