/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration size is too large.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PayloadTooLargeException extends AppConfigException implements
        ToCopyableBuilder<PayloadTooLargeException.Builder, PayloadTooLargeException> {
    private static final SdkField<String> MEASURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PayloadTooLargeException::measureAsString)).setter(setter(Builder::measure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Measure").build()).build();

    private static final SdkField<Float> LIMIT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(PayloadTooLargeException::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<Float> SIZE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(PayloadTooLargeException::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_FIELD, LIMIT_FIELD,
            SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String measure;

    private final Float limit;

    private final Float size;

    private PayloadTooLargeException(BuilderImpl builder) {
        super(builder);
        this.measure = builder.measure;
        this.limit = builder.limit;
        this.size = builder.size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Measure property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measure} will
     * return {@link BytesMeasure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #measureAsString}.
     * </p>
     * 
     * @return The value of the Measure property for this object.
     * @see BytesMeasure
     */
    public BytesMeasure measure() {
        return BytesMeasure.fromValue(measure);
    }

    /**
     * Returns the value of the Measure property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measure} will
     * return {@link BytesMeasure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #measureAsString}.
     * </p>
     * 
     * @return The value of the Measure property for this object.
     * @see BytesMeasure
     */
    public String measureAsString() {
        return measure;
    }

    /**
     * Returns the value of the Limit property for this object.
     * 
     * @return The value of the Limit property for this object.
     */
    public Float limit() {
        return limit;
    }

    /**
     * Returns the value of the Size property for this object.
     * 
     * @return The value of the Size property for this object.
     */
    public Float size() {
        return size;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PayloadTooLargeException, T> g) {
        return obj -> g.apply((PayloadTooLargeException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PayloadTooLargeException>, AppConfigException.Builder {
        /**
         * Sets the value of the Measure property for this object.
         *
         * @param measure
         *        The new value for the Measure property for this object.
         * @see BytesMeasure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BytesMeasure
         */
        Builder measure(String measure);

        /**
         * Sets the value of the Measure property for this object.
         *
         * @param measure
         *        The new value for the Measure property for this object.
         * @see BytesMeasure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BytesMeasure
         */
        Builder measure(BytesMeasure measure);

        /**
         * Sets the value of the Limit property for this object.
         *
         * @param limit
         *        The new value for the Limit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Float limit);

        /**
         * Sets the value of the Size property for this object.
         *
         * @param size
         *        The new value for the Size property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Float size);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends AppConfigException.BuilderImpl implements Builder {
        private String measure;

        private Float limit;

        private Float size;

        private BuilderImpl() {
        }

        private BuilderImpl(PayloadTooLargeException model) {
            super(model);
            measure(model.measure);
            limit(model.limit);
            size(model.size);
        }

        public final String getMeasure() {
            return measure;
        }

        @Override
        public final Builder measure(String measure) {
            this.measure = measure;
            return this;
        }

        @Override
        public final Builder measure(BytesMeasure measure) {
            this.measure(measure == null ? null : measure.toString());
            return this;
        }

        public final void setMeasure(String measure) {
            this.measure = measure;
        }

        public final Float getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Float limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Float limit) {
            this.limit = limit;
        }

        public final Float getSize() {
            return size;
        }

        @Override
        public final Builder size(Float size) {
            this.size = size;
            return this;
        }

        public final void setSize(Float size) {
            this.size = size;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public PayloadTooLargeException build() {
            return new PayloadTooLargeException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
