/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon CloudWatch alarms to monitor during the deployment process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Monitor implements SdkPojo, Serializable, ToCopyableBuilder<Monitor.Builder, Monitor> {
    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Monitor::alarmArn)).setter(setter(Builder::alarmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmArn").build()).build();

    private static final SdkField<String> ALARM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Monitor::alarmRoleArn)).setter(setter(Builder::alarmRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_ARN_FIELD,
            ALARM_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmArn;

    private final String alarmRoleArn;

    private Monitor(BuilderImpl builder) {
        this.alarmArn = builder.alarmArn;
        this.alarmRoleArn = builder.alarmRoleArn;
    }

    /**
     * <p>
     * ARN of the Amazon CloudWatch alarm.
     * </p>
     * 
     * @return ARN of the Amazon CloudWatch alarm.
     */
    public String alarmArn() {
        return alarmArn;
    }

    /**
     * <p>
     * ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.
     * </p>
     * 
     * @return ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.
     */
    public String alarmRoleArn() {
        return alarmRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Monitor)) {
            return false;
        }
        Monitor other = (Monitor) obj;
        return Objects.equals(alarmArn(), other.alarmArn()) && Objects.equals(alarmRoleArn(), other.alarmRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Monitor").add("AlarmArn", alarmArn()).add("AlarmRoleArn", alarmRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmArn":
            return Optional.ofNullable(clazz.cast(alarmArn()));
        case "AlarmRoleArn":
            return Optional.ofNullable(clazz.cast(alarmRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Monitor, T> g) {
        return obj -> g.apply((Monitor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Monitor> {
        /**
         * <p>
         * ARN of the Amazon CloudWatch alarm.
         * </p>
         * 
         * @param alarmArn
         *        ARN of the Amazon CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmArn(String alarmArn);

        /**
         * <p>
         * ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.
         * </p>
         * 
         * @param alarmRoleArn
         *        ARN of an IAM role for AppConfig to monitor <code>AlarmArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRoleArn(String alarmRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String alarmArn;

        private String alarmRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Monitor model) {
            alarmArn(model.alarmArn);
            alarmRoleArn(model.alarmRoleArn);
        }

        public final String getAlarmArn() {
            return alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        public final String getAlarmRoleArn() {
            return alarmRoleArn;
        }

        @Override
        public final Builder alarmRoleArn(String alarmRoleArn) {
            this.alarmRoleArn = alarmRoleArn;
            return this;
        }

        public final void setAlarmRoleArn(String alarmRoleArn) {
            this.alarmRoleArn = alarmRoleArn;
        }

        @Override
        public Monitor build() {
            return new Monitor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
