/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentStrategyRequest extends AppConfigRequest implements
        ToCopyableBuilder<CreateDeploymentStrategyRequest.Builder, CreateDeploymentStrategyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDeploymentStrategyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDeploymentStrategyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentDurationInMinutes")
            .getter(getter(CreateDeploymentStrategyRequest::deploymentDurationInMinutes))
            .setter(setter(Builder::deploymentDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes")
                    .build()).build();

    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FinalBakeTimeInMinutes").getter(getter(CreateDeploymentStrategyRequest::finalBakeTimeInMinutes))
            .setter(setter(Builder::finalBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build())
            .build();

    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("GrowthFactor").getter(getter(CreateDeploymentStrategyRequest::growthFactor))
            .setter(setter(Builder::growthFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()).build();

    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrowthType").getter(getter(CreateDeploymentStrategyRequest::growthTypeAsString))
            .setter(setter(Builder::growthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()).build();

    private static final SdkField<String> REPLICATE_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicateTo").getter(getter(CreateDeploymentStrategyRequest::replicateToAsString))
            .setter(setter(Builder::replicateTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicateTo").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDeploymentStrategyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DEPLOYMENT_DURATION_IN_MINUTES_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, GROWTH_FACTOR_FIELD, GROWTH_TYPE_FIELD,
            REPLICATE_TO_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final Integer deploymentDurationInMinutes;

    private final Integer finalBakeTimeInMinutes;

    private final Float growthFactor;

    private final String growthType;

    private final String replicateTo;

    private final Map<String, String> tags;

    private CreateDeploymentStrategyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.growthFactor = builder.growthFactor;
        this.growthType = builder.growthType;
        this.replicateTo = builder.replicateTo;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the deployment strategy.
     * </p>
     * 
     * @return A name for the deployment strategy.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the deployment strategy.
     * </p>
     * 
     * @return A description of the deployment strategy.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Total amount of time for a deployment to last.
     * </p>
     * 
     * @return Total amount of time for a deployment to last.
     */
    public Integer deploymentDurationInMinutes() {
        return deploymentDurationInMinutes;
    }

    /**
     * <p>
     * The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer
     * eligible for automatic roll back.
     * </p>
     * 
     * @return The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no
     *         longer eligible for automatic roll back.
     */
    public Integer finalBakeTimeInMinutes() {
        return finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @return The percentage of targets to receive a deployed configuration during each interval.
     */
    public Float growthFactor() {
        return growthFactor;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:
     * </p>
     * <p>
     * <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the
     * value specified for <code>Step percentage</code>. For example, a linear deployment that uses a
     * <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments
     * are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the
     * targets have successfully received the configuration.
     * </p>
     * <p>
     * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula:
     * <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
     * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
     * specify a growth factor of 2, then the system rolls out the configuration as follows:
     * </p>
     * <p>
     * <code>2*(2^0)</code>
     * </p>
     * <p>
     * <code>2*(2^1)</code>
     * </p>
     * <p>
     * <code>2*(2^2)</code>
     * </p>
     * <p>
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
     * targets, and continues until the configuration has been deployed to all targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
     *         types:</p>
     *         <p>
     *         <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets
     *         by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a
     *         <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those
     *         deployments are complete, the system deploys the configuration to the next 10 percent. This continues
     *         until 100% of the targets have successfully received the configuration.
     *         </p>
     *         <p>
     *         <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
     *         formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user
     *         and <code>N</code> is the number of steps until the configuration is deployed to all targets. For
     *         example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     *         </p>
     *         <p>
     *         <code>2*(2^0)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^1)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^2)</code>
     *         </p>
     *         <p>
     *         Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of
     *         the targets, and continues until the configuration has been deployed to all targets.
     * @see GrowthType
     */
    public GrowthType growthType() {
        return GrowthType.fromValue(growthType);
    }

    /**
     * <p>
     * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:
     * </p>
     * <p>
     * <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the
     * value specified for <code>Step percentage</code>. For example, a linear deployment that uses a
     * <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments
     * are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the
     * targets have successfully received the configuration.
     * </p>
     * <p>
     * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula:
     * <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
     * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
     * specify a growth factor of 2, then the system rolls out the configuration as follows:
     * </p>
     * <p>
     * <code>2*(2^0)</code>
     * </p>
     * <p>
     * <code>2*(2^1)</code>
     * </p>
     * <p>
     * <code>2*(2^2)</code>
     * </p>
     * <p>
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
     * targets, and continues until the configuration has been deployed to all targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
     *         types:</p>
     *         <p>
     *         <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets
     *         by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a
     *         <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those
     *         deployments are complete, the system deploys the configuration to the next 10 percent. This continues
     *         until 100% of the targets have successfully received the configuration.
     *         </p>
     *         <p>
     *         <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
     *         formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user
     *         and <code>N</code> is the number of steps until the configuration is deployed to all targets. For
     *         example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     *         </p>
     *         <p>
     *         <code>2*(2^0)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^1)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^2)</code>
     *         </p>
     *         <p>
     *         Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of
     *         the targets, and continues until the configuration has been deployed to all targets.
     * @see GrowthType
     */
    public String growthTypeAsString() {
        return growthType;
    }

    /**
     * <p>
     * Save the deployment strategy to a Systems Manager (SSM) document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicateTo} will
     * return {@link ReplicateTo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicateToAsString}.
     * </p>
     * 
     * @return Save the deployment strategy to a Systems Manager (SSM) document.
     * @see ReplicateTo
     */
    public ReplicateTo replicateTo() {
        return ReplicateTo.fromValue(replicateTo);
    }

    /**
     * <p>
     * Save the deployment strategy to a Systems Manager (SSM) document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicateTo} will
     * return {@link ReplicateTo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicateToAsString}.
     * </p>
     * 
     * @return Save the deployment strategy to a Systems Manager (SSM) document.
     * @see ReplicateTo
     */
    public String replicateToAsString() {
        return replicateTo;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each
     * tag consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig
     *         resources. Each tag consists of a key and an optional value, both of which you define.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicateToAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentStrategyRequest)) {
            return false;
        }
        CreateDeploymentStrategyRequest other = (CreateDeploymentStrategyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(deploymentDurationInMinutes(), other.deploymentDurationInMinutes())
                && Objects.equals(finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes())
                && Objects.equals(growthFactor(), other.growthFactor())
                && Objects.equals(growthTypeAsString(), other.growthTypeAsString())
                && Objects.equals(replicateToAsString(), other.replicateToAsString()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentStrategyRequest").add("Name", name()).add("Description", description())
                .add("DeploymentDurationInMinutes", deploymentDurationInMinutes())
                .add("FinalBakeTimeInMinutes", finalBakeTimeInMinutes()).add("GrowthFactor", growthFactor())
                .add("GrowthType", growthTypeAsString()).add("ReplicateTo", replicateToAsString()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeploymentDurationInMinutes":
            return Optional.ofNullable(clazz.cast(deploymentDurationInMinutes()));
        case "FinalBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(finalBakeTimeInMinutes()));
        case "GrowthFactor":
            return Optional.ofNullable(clazz.cast(growthFactor()));
        case "GrowthType":
            return Optional.ofNullable(clazz.cast(growthTypeAsString()));
        case "ReplicateTo":
            return Optional.ofNullable(clazz.cast(replicateToAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentStrategyRequest, T> g) {
        return obj -> g.apply((CreateDeploymentStrategyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentStrategyRequest> {
        /**
         * <p>
         * A name for the deployment strategy.
         * </p>
         * 
         * @param name
         *        A name for the deployment strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the deployment strategy.
         * </p>
         * 
         * @param description
         *        A description of the deployment strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Total amount of time for a deployment to last.
         * </p>
         * 
         * @param deploymentDurationInMinutes
         *        Total amount of time for a deployment to last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes);

        /**
         * <p>
         * The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no
         * longer eligible for automatic roll back.
         * </p>
         * 
         * @param finalBakeTimeInMinutes
         *        The amount of time AppConfig monitors for alarms before considering the deployment to be complete and
         *        no longer eligible for automatic roll back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes);

        /**
         * <p>
         * The percentage of targets to receive a deployed configuration during each interval.
         * </p>
         * 
         * @param growthFactor
         *        The percentage of targets to receive a deployed configuration during each interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder growthFactor(Float growthFactor);

        /**
         * <p>
         * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
         * types:
         * </p>
         * <p>
         * <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by
         * the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a
         * <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those
         * deployments are complete, the system deploys the configuration to the next 10 percent. This continues until
         * 100% of the targets have successfully received the configuration.
         * </p>
         * <p>
         * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
         * formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
         * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
         * specify a growth factor of 2, then the system rolls out the configuration as follows:
         * </p>
         * <p>
         * <code>2*(2^0)</code>
         * </p>
         * <p>
         * <code>2*(2^1)</code>
         * </p>
         * <p>
         * <code>2*(2^2)</code>
         * </p>
         * <p>
         * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
         * targets, and continues until the configuration has been deployed to all targets.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following
         *        growth types:</p>
         *        <p>
         *        <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of
         *        targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that
         *        uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After
         *        those deployments are complete, the system deploys the configuration to the next 10 percent. This
         *        continues until 100% of the targets have successfully received the configuration.
         *        </p>
         *        <p>
         *        <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the
         *        following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor
         *        specified by the user and <code>N</code> is the number of steps until the configuration is deployed to
         *        all targets. For example, if you specify a growth factor of 2, then the system rolls out the
         *        configuration as follows:
         *        </p>
         *        <p>
         *        <code>2*(2^0)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^1)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^2)</code>
         *        </p>
         *        <p>
         *        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8%
         *        of the targets, and continues until the configuration has been deployed to all targets.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(String growthType);

        /**
         * <p>
         * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
         * types:
         * </p>
         * <p>
         * <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by
         * the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a
         * <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those
         * deployments are complete, the system deploys the configuration to the next 10 percent. This continues until
         * 100% of the targets have successfully received the configuration.
         * </p>
         * <p>
         * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
         * formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
         * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
         * specify a growth factor of 2, then the system rolls out the configuration as follows:
         * </p>
         * <p>
         * <code>2*(2^0)</code>
         * </p>
         * <p>
         * <code>2*(2^1)</code>
         * </p>
         * <p>
         * <code>2*(2^2)</code>
         * </p>
         * <p>
         * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
         * targets, and continues until the configuration has been deployed to all targets.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following
         *        growth types:</p>
         *        <p>
         *        <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of
         *        targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that
         *        uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After
         *        those deployments are complete, the system deploys the configuration to the next 10 percent. This
         *        continues until 100% of the targets have successfully received the configuration.
         *        </p>
         *        <p>
         *        <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the
         *        following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor
         *        specified by the user and <code>N</code> is the number of steps until the configuration is deployed to
         *        all targets. For example, if you specify a growth factor of 2, then the system rolls out the
         *        configuration as follows:
         *        </p>
         *        <p>
         *        <code>2*(2^0)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^1)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^2)</code>
         *        </p>
         *        <p>
         *        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8%
         *        of the targets, and continues until the configuration has been deployed to all targets.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(GrowthType growthType);

        /**
         * <p>
         * Save the deployment strategy to a Systems Manager (SSM) document.
         * </p>
         * 
         * @param replicateTo
         *        Save the deployment strategy to a Systems Manager (SSM) document.
         * @see ReplicateTo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicateTo
         */
        Builder replicateTo(String replicateTo);

        /**
         * <p>
         * Save the deployment strategy to a Systems Manager (SSM) document.
         * </p>
         * 
         * @param replicateTo
         *        Save the deployment strategy to a Systems Manager (SSM) document.
         * @see ReplicateTo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicateTo
         */
        Builder replicateTo(ReplicateTo replicateTo);

        /**
         * <p>
         * Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources.
         * Each tag consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig
         *        resources. Each tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Integer deploymentDurationInMinutes;

        private Integer finalBakeTimeInMinutes;

        private Float growthFactor;

        private String growthType;

        private String replicateTo;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentStrategyRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            growthFactor(model.growthFactor);
            growthType(model.growthType);
            replicateTo(model.replicateTo);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        public final Float getGrowthFactor() {
            return growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        public final String getGrowthType() {
            return growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        public final String getReplicateTo() {
            return replicateTo;
        }

        @Override
        public final Builder replicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
            return this;
        }

        @Override
        public final Builder replicateTo(ReplicateTo replicateTo) {
            this.replicateTo(replicateTo == null ? null : replicateTo.toString());
            return this;
        }

        public final void setReplicateTo(String replicateTo) {
            this.replicateTo = replicateTo;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentStrategyRequest build() {
            return new CreateDeploymentStrategyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
