/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDeploymentStrategyRequest extends AppConfigRequest implements
        ToCopyableBuilder<DeleteDeploymentStrategyRequest.Builder, DeleteDeploymentStrategyRequest> {
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStrategyId").getter(getter(DeleteDeploymentStrategyRequest::deploymentStrategyId))
            .setter(setter(Builder::deploymentStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeploymentStrategyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STRATEGY_ID_FIELD));

    private final String deploymentStrategyId;

    private DeleteDeploymentStrategyRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentStrategyId = builder.deploymentStrategyId;
    }

    /**
     * <p>
     * The ID of the deployment strategy you want to delete.
     * </p>
     * 
     * @return The ID of the deployment strategy you want to delete.
     */
    public String deploymentStrategyId() {
        return deploymentStrategyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStrategyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeploymentStrategyRequest)) {
            return false;
        }
        DeleteDeploymentStrategyRequest other = (DeleteDeploymentStrategyRequest) obj;
        return Objects.equals(deploymentStrategyId(), other.deploymentStrategyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDeploymentStrategyRequest").add("DeploymentStrategyId", deploymentStrategyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentStrategyId":
            return Optional.ofNullable(clazz.cast(deploymentStrategyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDeploymentStrategyRequest, T> g) {
        return obj -> g.apply((DeleteDeploymentStrategyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDeploymentStrategyRequest> {
        /**
         * <p>
         * The ID of the deployment strategy you want to delete.
         * </p>
         * 
         * @param deploymentStrategyId
         *        The ID of the deployment strategy you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStrategyId(String deploymentStrategyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String deploymentStrategyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeploymentStrategyRequest model) {
            super(model);
            deploymentStrategyId(model.deploymentStrategyId);
        }

        public final String getDeploymentStrategyId() {
            return deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDeploymentStrategyRequest build() {
            return new DeleteDeploymentStrategyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
