/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentSummary.Builder, DeploymentSummary> {
    private static final SdkField<Integer> DEPLOYMENT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentNumber").getter(getter(DeploymentSummary::deploymentNumber))
            .setter(setter(Builder::deploymentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentNumber").build()).build();

    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationName").getter(getter(DeploymentSummary::configurationName))
            .setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()).build();

    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationVersion").getter(getter(DeploymentSummary::configurationVersion))
            .setter(setter(Builder::configurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build())
            .build();

    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentDurationInMinutes")
            .getter(getter(DeploymentSummary::deploymentDurationInMinutes))
            .setter(setter(Builder::deploymentDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes")
                    .build()).build();

    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrowthType").getter(getter(DeploymentSummary::growthTypeAsString)).setter(setter(Builder::growthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()).build();

    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("GrowthFactor").getter(getter(DeploymentSummary::growthFactor)).setter(setter(Builder::growthFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()).build();

    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FinalBakeTimeInMinutes").getter(getter(DeploymentSummary::finalBakeTimeInMinutes))
            .setter(setter(Builder::finalBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DeploymentSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Float> PERCENTAGE_COMPLETE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("PercentageComplete").getter(getter(DeploymentSummary::percentageComplete))
            .setter(setter(Builder::percentageComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build())
            .build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt")
            .getter(getter(DeploymentSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedAt")
            .getter(getter(DeploymentSummary::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_NUMBER_FIELD,
            CONFIGURATION_NAME_FIELD, CONFIGURATION_VERSION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD,
            GROWTH_FACTOR_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, STATE_FIELD, PERCENTAGE_COMPLETE_FIELD, STARTED_AT_FIELD,
            COMPLETED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer deploymentNumber;

    private final String configurationName;

    private final String configurationVersion;

    private final Integer deploymentDurationInMinutes;

    private final String growthType;

    private final Float growthFactor;

    private final Integer finalBakeTimeInMinutes;

    private final String state;

    private final Float percentageComplete;

    private final Instant startedAt;

    private final Instant completedAt;

    private DeploymentSummary(BuilderImpl builder) {
        this.deploymentNumber = builder.deploymentNumber;
        this.configurationName = builder.configurationName;
        this.configurationVersion = builder.configurationVersion;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.state = builder.state;
        this.percentageComplete = builder.percentageComplete;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     * 
     * @return The sequence number of the deployment.
     */
    public Integer deploymentNumber() {
        return deploymentNumber;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public String configurationName() {
        return configurationName;
    }

    /**
     * <p>
     * The version of the configuration.
     * </p>
     * 
     * @return The version of the configuration.
     */
    public String configurationVersion() {
        return configurationVersion;
    }

    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     * 
     * @return Total amount of time the deployment lasted.
     */
    public Integer deploymentDurationInMinutes() {
        return deploymentDurationInMinutes;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grows over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grows over time.
     * @see GrowthType
     */
    public GrowthType growthType() {
        return GrowthType.fromValue(growthType);
    }

    /**
     * <p>
     * The algorithm used to define how percentage grows over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grows over time.
     * @see GrowthType
     */
    public String growthTypeAsString() {
        return growthType;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @return The percentage of targets to receive a deployed configuration during each interval.
     */
    public Float growthFactor() {
        return growthFactor;
    }

    /**
     * <p>
     * The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer
     * eligible for automatic roll back.
     * </p>
     * 
     * @return The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no
     *         longer eligible for automatic roll back.
     */
    public Integer finalBakeTimeInMinutes() {
        return finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DeploymentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */
    public DeploymentState state() {
        return DeploymentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DeploymentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The percentage of targets for which the deployment is available.
     * </p>
     * 
     * @return The percentage of targets for which the deployment is available.
     */
    public Float percentageComplete() {
        return percentageComplete;
    }

    /**
     * <p>
     * Time the deployment started.
     * </p>
     * 
     * @return Time the deployment started.
     */
    public Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * Time the deployment completed.
     * </p>
     * 
     * @return Time the deployment completed.
     */
    public Instant completedAt() {
        return completedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentSummary)) {
            return false;
        }
        DeploymentSummary other = (DeploymentSummary) obj;
        return Objects.equals(deploymentNumber(), other.deploymentNumber())
                && Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(configurationVersion(), other.configurationVersion())
                && Objects.equals(deploymentDurationInMinutes(), other.deploymentDurationInMinutes())
                && Objects.equals(growthTypeAsString(), other.growthTypeAsString())
                && Objects.equals(growthFactor(), other.growthFactor())
                && Objects.equals(finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(percentageComplete(), other.percentageComplete())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(completedAt(), other.completedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentSummary").add("DeploymentNumber", deploymentNumber())
                .add("ConfigurationName", configurationName()).add("ConfigurationVersion", configurationVersion())
                .add("DeploymentDurationInMinutes", deploymentDurationInMinutes()).add("GrowthType", growthTypeAsString())
                .add("GrowthFactor", growthFactor()).add("FinalBakeTimeInMinutes", finalBakeTimeInMinutes())
                .add("State", stateAsString()).add("PercentageComplete", percentageComplete()).add("StartedAt", startedAt())
                .add("CompletedAt", completedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentNumber":
            return Optional.ofNullable(clazz.cast(deploymentNumber()));
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "ConfigurationVersion":
            return Optional.ofNullable(clazz.cast(configurationVersion()));
        case "DeploymentDurationInMinutes":
            return Optional.ofNullable(clazz.cast(deploymentDurationInMinutes()));
        case "GrowthType":
            return Optional.ofNullable(clazz.cast(growthTypeAsString()));
        case "GrowthFactor":
            return Optional.ofNullable(clazz.cast(growthFactor()));
        case "FinalBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(finalBakeTimeInMinutes()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "PercentageComplete":
            return Optional.ofNullable(clazz.cast(percentageComplete()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentSummary, T> g) {
        return obj -> g.apply((DeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentSummary> {
        /**
         * <p>
         * The sequence number of the deployment.
         * </p>
         * 
         * @param deploymentNumber
         *        The sequence number of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentNumber(Integer deploymentNumber);

        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param configurationName
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * <p>
         * The version of the configuration.
         * </p>
         * 
         * @param configurationVersion
         *        The version of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationVersion(String configurationVersion);

        /**
         * <p>
         * Total amount of time the deployment lasted.
         * </p>
         * 
         * @param deploymentDurationInMinutes
         *        Total amount of time the deployment lasted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes);

        /**
         * <p>
         * The algorithm used to define how percentage grows over time.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grows over time.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(String growthType);

        /**
         * <p>
         * The algorithm used to define how percentage grows over time.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grows over time.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(GrowthType growthType);

        /**
         * <p>
         * The percentage of targets to receive a deployed configuration during each interval.
         * </p>
         * 
         * @param growthFactor
         *        The percentage of targets to receive a deployed configuration during each interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder growthFactor(Float growthFactor);

        /**
         * <p>
         * The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no
         * longer eligible for automatic roll back.
         * </p>
         * 
         * @param finalBakeTimeInMinutes
         *        The amount of time AppConfig monitors for alarms before considering the deployment to be complete and
         *        no longer eligible for automatic roll back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes);

        /**
         * <p>
         * The state of the deployment.
         * </p>
         * 
         * @param state
         *        The state of the deployment.
         * @see DeploymentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the deployment.
         * </p>
         * 
         * @param state
         *        The state of the deployment.
         * @see DeploymentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentState
         */
        Builder state(DeploymentState state);

        /**
         * <p>
         * The percentage of targets for which the deployment is available.
         * </p>
         * 
         * @param percentageComplete
         *        The percentage of targets for which the deployment is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageComplete(Float percentageComplete);

        /**
         * <p>
         * Time the deployment started.
         * </p>
         * 
         * @param startedAt
         *        Time the deployment started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * Time the deployment completed.
         * </p>
         * 
         * @param completedAt
         *        Time the deployment completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);
    }

    static final class BuilderImpl implements Builder {
        private Integer deploymentNumber;

        private String configurationName;

        private String configurationVersion;

        private Integer deploymentDurationInMinutes;

        private String growthType;

        private Float growthFactor;

        private Integer finalBakeTimeInMinutes;

        private String state;

        private Float percentageComplete;

        private Instant startedAt;

        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentSummary model) {
            deploymentNumber(model.deploymentNumber);
            configurationName(model.configurationName);
            configurationVersion(model.configurationVersion);
            deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            growthType(model.growthType);
            growthFactor(model.growthFactor);
            finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            state(model.state);
            percentageComplete(model.percentageComplete);
            startedAt(model.startedAt);
            completedAt(model.completedAt);
        }

        public final Integer getDeploymentNumber() {
            return deploymentNumber;
        }

        @Override
        public final Builder deploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        public final void setDeploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public final String getConfigurationVersion() {
            return configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        public final String getGrowthType() {
            return growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        public final Float getGrowthFactor() {
            return growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DeploymentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Float getPercentageComplete() {
            return percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final void setPercentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public DeploymentSummary build() {
            return new DeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
