/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends AppConfigRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateEnvironmentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Monitor>> MONITORS_FIELD = SdkField
            .<List<Monitor>> builder(MarshallingType.LIST)
            .memberName("Monitors")
            .getter(getter(CreateEnvironmentRequest::monitors))
            .setter(setter(Builder::monitors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Monitor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Monitor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, MONITORS_FIELD, TAGS_FIELD));

    private final String applicationId;

    private final String name;

    private final String description;

    private final List<Monitor> monitors;

    private final Map<String, String> tags;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.description = builder.description;
        this.monitors = builder.monitors;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A name for the environment.
     * </p>
     * 
     * @return A name for the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the environment.
     * </p>
     * 
     * @return A description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Monitors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMonitors() {
        return monitors != null && !(monitors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon CloudWatch alarms to monitor during the deployment process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMonitors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Amazon CloudWatch alarms to monitor during the deployment process.
     */
    public final List<Monitor> monitors() {
        return monitors;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each
     *         tag consists of a key and an optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitors() ? monitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasMonitors() == other.hasMonitors()
                && Objects.equals(monitors(), other.monitors()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("ApplicationId", applicationId()).add("Name", name())
                .add("Description", description()).add("Monitors", hasMonitors() ? monitors() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Monitors":
            return Optional.ofNullable(clazz.cast(monitors()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A name for the environment.
         * </p>
         * 
         * @param name
         *        A name for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the environment.
         * </p>
         * 
         * @param description
         *        A description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Amazon CloudWatch alarms to monitor during the deployment process.
         * </p>
         * 
         * @param monitors
         *        Amazon CloudWatch alarms to monitor during the deployment process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitors(Collection<Monitor> monitors);

        /**
         * <p>
         * Amazon CloudWatch alarms to monitor during the deployment process.
         * </p>
         * 
         * @param monitors
         *        Amazon CloudWatch alarms to monitor during the deployment process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitors(Monitor... monitors);

        /**
         * <p>
         * Amazon CloudWatch alarms to monitor during the deployment process.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Monitor>.Builder} avoiding the need to
         * create one manually via {@link List<Monitor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Monitor>.Builder#build()} is called immediately and its
         * result is passed to {@link #monitors(List<Monitor>)}.
         * 
         * @param monitors
         *        a consumer that will call methods on {@link List<Monitor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitors(List<Monitor>)
         */
        Builder monitors(Consumer<Monitor.Builder>... monitors);

        /**
         * <p>
         * Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources.
         *        Each tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String name;

        private String description;

        private List<Monitor> monitors = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            applicationId(model.applicationId);
            name(model.name);
            description(model.description);
            monitors(model.monitors);
            tags(model.tags);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Monitor.Builder> getMonitors() {
            if (monitors instanceof SdkAutoConstructList) {
                return null;
            }
            return monitors != null ? monitors.stream().map(Monitor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder monitors(Collection<Monitor> monitors) {
            this.monitors = MonitorListCopier.copy(monitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Monitor... monitors) {
            monitors(Arrays.asList(monitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Consumer<Monitor.Builder>... monitors) {
            monitors(Stream.of(monitors).map(c -> Monitor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMonitors(Collection<Monitor.BuilderImpl> monitors) {
            this.monitors = MonitorListCopier.copyFromBuilder(monitors);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
