/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsResponse extends AppConfigResponse implements
        ToCopyableBuilder<ListEnvironmentsResponse.Builder, ListEnvironmentsResponse> {
    private static final SdkField<List<Environment>> ITEMS_FIELD = SdkField
            .<List<Environment>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ListEnvironmentsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Environment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Environment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Environment> items;

    private final String nextToken;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The elements from this collection.
     */
    public final List<Environment> items() {
        return items;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsResponse").add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsResponse> {
        /**
         * <p>
         * The elements from this collection.
         * </p>
         * 
         * @param items
         *        The elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Environment> items);

        /**
         * <p>
         * The elements from this collection.
         * </p>
         * 
         * @param items
         *        The elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Environment... items);

        /**
         * <p>
         * The elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Environment>.Builder} avoiding the need to
         * create one manually via {@link List<Environment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Environment>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<Environment>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Environment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Environment>)
         */
        Builder items(Consumer<Environment.Builder>... items);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private List<Environment> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final List<Environment.Builder> getItems() {
            List<Environment.Builder> result = EnvironmentListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<Environment.BuilderImpl> items) {
            this.items = EnvironmentListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<Environment> items) {
            this.items = EnvironmentListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Environment... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<Environment.Builder>... items) {
            items(Stream.of(items).map(c -> Environment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
