/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationProfileResponse extends AppConfigResponse implements
        ToCopyableBuilder<GetConfigurationProfileResponse.Builder, GetConfigurationProfileResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetConfigurationProfileResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetConfigurationProfileResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConfigurationProfileResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetConfigurationProfileResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(GetConfigurationProfileResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<String> RETRIEVAL_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievalRoleArn").getter(getter(GetConfigurationProfileResponse::retrievalRoleArn))
            .setter(setter(Builder::retrievalRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalRoleArn").build()).build();

    private static final SdkField<List<Validator>> VALIDATORS_FIELD = SdkField
            .<List<Validator>> builder(MarshallingType.LIST)
            .memberName("Validators")
            .getter(getter(GetConfigurationProfileResponse::validators))
            .setter(setter(Builder::validators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Validator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Validator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetConfigurationProfileResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOCATION_URI_FIELD, RETRIEVAL_ROLE_ARN_FIELD, VALIDATORS_FIELD, TYPE_FIELD));

    private final String applicationId;

    private final String id;

    private final String name;

    private final String description;

    private final String locationUri;

    private final String retrievalRoleArn;

    private final List<Validator> validators;

    private final String type;

    private GetConfigurationProfileResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.retrievalRoleArn = builder.retrievalRoleArn;
        this.validators = builder.validators;
        this.type = builder.type;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The configuration profile ID.
     * </p>
     * 
     * @return The configuration profile ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the configuration profile.
     * </p>
     * 
     * @return The name of the configuration profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration profile description.
     * </p>
     * 
     * @return The configuration profile description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The URI location of the configuration.
     * </p>
     * 
     * @return The URI location of the configuration.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * <p>
     * The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.
     * </p>
     * 
     * @return The ARN of an IAM role with permission to access the configuration at the specified
     *         <code>LocationUri</code>.
     */
    public final String retrievalRoleArn() {
        return retrievalRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Validators property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValidators() {
        return validators != null && !(validators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of methods for validating the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidators} method.
     * </p>
     * 
     * @return A list of methods for validating the configuration.
     */
    public final List<Validator> validators() {
        return validators;
    }

    /**
     * <p>
     * The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
     * <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable
     * new features and freeform configurations to distribute configurations to an application. When calling this API,
     * enter one of the following values for <code>Type</code>:
     * </p>
     * <p>
     * <code>AWS.AppConfig.FeatureFlags</code>
     * </p>
     * <p>
     * <code>AWS.Freeform</code>
     * </p>
     * 
     * @return The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
     *         <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or
     *         disable new features and freeform configurations to distribute configurations to an application. When
     *         calling this API, enter one of the following values for <code>Type</code>:</p>
     *         <p>
     *         <code>AWS.AppConfig.FeatureFlags</code>
     *         </p>
     *         <p>
     *         <code>AWS.Freeform</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidators() ? validators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationProfileResponse)) {
            return false;
        }
        GetConfigurationProfileResponse other = (GetConfigurationProfileResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(locationUri(), other.locationUri())
                && Objects.equals(retrievalRoleArn(), other.retrievalRoleArn()) && hasValidators() == other.hasValidators()
                && Objects.equals(validators(), other.validators()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationProfileResponse").add("ApplicationId", applicationId()).add("Id", id())
                .add("Name", name()).add("Description", description()).add("LocationUri", locationUri())
                .add("RetrievalRoleArn", retrievalRoleArn()).add("Validators", hasValidators() ? validators() : null)
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "RetrievalRoleArn":
            return Optional.ofNullable(clazz.cast(retrievalRoleArn()));
        case "Validators":
            return Optional.ofNullable(clazz.cast(validators()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationProfileResponse, T> g) {
        return obj -> g.apply((GetConfigurationProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfigurationProfileResponse> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The configuration profile ID.
         * </p>
         * 
         * @param id
         *        The configuration profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the configuration profile.
         * </p>
         * 
         * @param name
         *        The name of the configuration profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration profile description.
         * </p>
         * 
         * @param description
         *        The configuration profile description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URI location of the configuration.
         * </p>
         * 
         * @param locationUri
         *        The URI location of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.
         * </p>
         * 
         * @param retrievalRoleArn
         *        The ARN of an IAM role with permission to access the configuration at the specified
         *        <code>LocationUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalRoleArn(String retrievalRoleArn);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Collection<Validator> validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * 
         * @param validators
         *        A list of methods for validating the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validators(Validator... validators);

        /**
         * <p>
         * A list of methods for validating the configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Validator>.Builder} avoiding the need to
         * create one manually via {@link List<Validator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Validator>.Builder#build()} is called immediately and its
         * result is passed to {@link #validators(List<Validator>)}.
         * 
         * @param validators
         *        a consumer that will call methods on {@link List<Validator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validators(List<Validator>)
         */
        Builder validators(Consumer<Validator.Builder>... validators);

        /**
         * <p>
         * The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
         * <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or
         * disable new features and freeform configurations to distribute configurations to an application. When calling
         * this API, enter one of the following values for <code>Type</code>:
         * </p>
         * <p>
         * <code>AWS.AppConfig.FeatureFlags</code>
         * </p>
         * <p>
         * <code>AWS.Freeform</code>
         * </p>
         * 
         * @param type
         *        The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and
         *        <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or
         *        disable new features and freeform configurations to distribute configurations to an application. When
         *        calling this API, enter one of the following values for <code>Type</code>:</p>
         *        <p>
         *        <code>AWS.AppConfig.FeatureFlags</code>
         *        </p>
         *        <p>
         *        <code>AWS.Freeform</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String id;

        private String name;

        private String description;

        private String locationUri;

        private String retrievalRoleArn;

        private List<Validator> validators = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationProfileResponse model) {
            super(model);
            applicationId(model.applicationId);
            id(model.id);
            name(model.name);
            description(model.description);
            locationUri(model.locationUri);
            retrievalRoleArn(model.retrievalRoleArn);
            validators(model.validators);
            type(model.type);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        @Transient
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getRetrievalRoleArn() {
            return retrievalRoleArn;
        }

        public final void setRetrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
        }

        @Override
        @Transient
        public final Builder retrievalRoleArn(String retrievalRoleArn) {
            this.retrievalRoleArn = retrievalRoleArn;
            return this;
        }

        public final List<Validator.Builder> getValidators() {
            List<Validator.Builder> result = ValidatorListCopier.copyToBuilder(this.validators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidators(Collection<Validator.BuilderImpl> validators) {
            this.validators = ValidatorListCopier.copyFromBuilder(validators);
        }

        @Override
        @Transient
        public final Builder validators(Collection<Validator> validators) {
            this.validators = ValidatorListCopier.copy(validators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validators(Validator... validators) {
            validators(Arrays.asList(validators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validators(Consumer<Validator.Builder>... validators) {
            validators(Stream.of(validators).map(c -> Validator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public GetConfigurationProfileResponse build() {
            return new GetConfigurationProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
