/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the bad request exception error when creating a hosted configuration version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidConfigurationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidConfigurationDetail.Builder, InvalidConfigurationDetail> {
    private static final SdkField<String> CONSTRAINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Constraint").getter(getter(InvalidConfigurationDetail::constraint)).setter(setter(Builder::constraint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraint").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(InvalidConfigurationDetail::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(InvalidConfigurationDetail::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(InvalidConfigurationDetail::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINT_FIELD,
            LOCATION_FIELD, REASON_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constraint;

    private final String location;

    private final String reason;

    private final String type;

    private InvalidConfigurationDetail(BuilderImpl builder) {
        this.constraint = builder.constraint;
        this.location = builder.location;
        this.reason = builder.reason;
        this.type = builder.type;
    }

    /**
     * <p>
     * The invalid or out-of-range validation constraint in your JSON schema that failed validation.
     * </p>
     * 
     * @return The invalid or out-of-range validation constraint in your JSON schema that failed validation.
     */
    public final String constraint() {
        return constraint;
    }

    /**
     * <p>
     * Location of the validation constraint in the configuration JSON schema that failed validation.
     * </p>
     * 
     * @return Location of the validation constraint in the configuration JSON schema that failed validation.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The reason for an invalid configuration error.
     * </p>
     * 
     * @return The reason for an invalid configuration error.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The type of error for an invalid configuration.
     * </p>
     * 
     * @return The type of error for an invalid configuration.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constraint());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidConfigurationDetail)) {
            return false;
        }
        InvalidConfigurationDetail other = (InvalidConfigurationDetail) obj;
        return Objects.equals(constraint(), other.constraint()) && Objects.equals(location(), other.location())
                && Objects.equals(reason(), other.reason()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidConfigurationDetail").add("Constraint", constraint()).add("Location", location())
                .add("Reason", reason()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Constraint":
            return Optional.ofNullable(clazz.cast(constraint()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidConfigurationDetail, T> g) {
        return obj -> g.apply((InvalidConfigurationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidConfigurationDetail> {
        /**
         * <p>
         * The invalid or out-of-range validation constraint in your JSON schema that failed validation.
         * </p>
         * 
         * @param constraint
         *        The invalid or out-of-range validation constraint in your JSON schema that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraint(String constraint);

        /**
         * <p>
         * Location of the validation constraint in the configuration JSON schema that failed validation.
         * </p>
         * 
         * @param location
         *        Location of the validation constraint in the configuration JSON schema that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The reason for an invalid configuration error.
         * </p>
         * 
         * @param reason
         *        The reason for an invalid configuration error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The type of error for an invalid configuration.
         * </p>
         * 
         * @param type
         *        The type of error for an invalid configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String constraint;

        private String location;

        private String reason;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidConfigurationDetail model) {
            constraint(model.constraint);
            location(model.location);
            reason(model.reason);
            type(model.type);
        }

        public final String getConstraint() {
            return constraint;
        }

        public final void setConstraint(String constraint) {
            this.constraint = constraint;
        }

        @Override
        public final Builder constraint(String constraint) {
            this.constraint = constraint;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public InvalidConfigurationDetail build() {
            return new InvalidConfigurationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
